/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetLinesize
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_LINESIZE;

    public SetLinesize() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String str = cmd.getSql();
        String[] tokens = str.split(" ");
        int linesize = 0;
        try {
            if (tokens.length > 3) {
                linesize = Integer.parseInt(tokens[2]);
            } else if (tokens.length != 3) {
                ctx.write(Messages.getString("SetLinesize.1"));
                return true;
            }
            linesize = Integer.parseInt(tokens[2]);
            if (linesize <= 0 || linesize > Short.MAX_VALUE) {
                String msg = ScriptRunnerDbArb.format("ZERO_LNSIZE", new Integer(linesize).toString());
                this.writeToMain(msg + "\n", ctx);
                return false;
            }
        }
        catch (NumberFormatException e) {
            ctx.write(Messages.getString("SetLinesize.3"));
            return false;
        }
        this.setProperties(cmd, ctx, ctx.getProperty("script.runner.setlinesize").toString(), "linesize", "script.runner.setlinesize");
        this.writeShowMode(cmd, ctx, new Integer(linesize).toString());
        ctx.putProperty("script.runner.setlinesize", linesize);
        return true;
    }

    public void writeToMain(String op, ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream existing = ctx.getOutputStream();
        if (existing != null) {
            try {
                existing.write(op.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }
}

