/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParameterBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class SetJavaProperty
extends CommandListener {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private final Type _typeCommand = Factory.type(TypeId.SET).name("SET").add(Factory.type(TypeId.PROPERTY).name("PROPERTY").add(((ParameterBuilder)((ParameterBuilder)Factory.parameter(TypeId.KEY).name("KEY").dataType(String.class)).required()).build()).add(((ParameterBuilder)((ParameterBuilder)Factory.parameter(TypeId.VALUE).name("VALUE").dataType(String.class)).required()).build()).build()).build();

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Parser parser = new Parser(this._typeCommand, ctx.getEnvironment());
        Optional<ParsedCommand> parsedCommand = parser.parse(cmd.getSql(), error -> ctx.write(error + "\n"));
        boolean correctlyParsed = parsedCommand.isPresent();
        if (correctlyParsed) {
            ParsedCommand command = parsedCommand.get();
            String KEY = (String)command.getParameterValue(TypeId.KEY);
            String VALUE = (String)command.getParameterValue(TypeId.VALUE);
            Object old = System.getProperty(KEY);
            old = old != null ? " (" + (String)old + ")\n" : "\n";
            String message = MessageFormat.format(Messages.getString("ChangeLoggerLevel.1"), KEY, VALUE + (String)old);
            this.logger.info(message);
            ctx.write(message);
            System.setProperty(KEY, VALUE);
            return true;
        }
        return false;
    }

    public static enum TypeId implements Id
    {
        SET,
        PROPERTY,
        KEY,
        VALUE;

    }
}

