/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.Messages;

public class SetExitCommit
extends CommandListener
implements IShowCommand,
IStoreCommand {
    String[] aliases = new String[]{"exitcommit", "exitcomm", "exitcom", "exitc"};

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sql = cmd.getSql();
        String[] tokens = sql.split("\\s+");
        if (tokens.length != 3) {
            ctx.write("");
        } else {
            String token = tokens[2];
            if (token.toLowerCase().equals("on") || token.toLowerCase().equals("off")) {
                ctx.putProperty("script.runner.exitcommit", token.toUpperCase());
            } else {
                ctx.write(Messages.getString("SetExitCommit.0"));
                ctx.errorLog(ctx.getSourceRef(), Messages.getString("SetExitCommit.0"), cmd.getSql());
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getProperty("script.runner.exitcommit") == null) {
            ctx.write(Messages.getString("SetExitCommit.6"));
        } else if (ctx.getProperty("script.runner.exitcommit").equals("OFF")) {
            ctx.write(Messages.getString("SetExitCommit.9"));
        } else if (ctx.getProperty("script.runner.exitcommit").equals("ON")) {
            ctx.write(Messages.getString("SetExitCommit.12"));
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        if (ctx.getProperty("script.runner.exitcommit") != null && ctx.getProperty("script.runner.exitcommit").equals("ON")) {
            return StoreRegistry.getCommand("exitcommit", "ON");
        }
        return StoreRegistry.getCommand("exitcommit", "OFF");
    }
}

