/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class ScriptTimer
extends CommandListener {
    Date m_startDate = null;
    DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private Logger m_logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void beginScript(Connection conn, ScriptRunnerContext ctx) {
        try {
            this.m_startDate = new Date();
            if (ctx != null && ctx.getOutputStream() != null) {
                ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(Messages.getString("ScriptTimer.1") + this.dateFormat.format(this.m_startDate) + "\n"));
                ctx.getOutputStream().write(ScriptRunner.FORCE_PRINT_BYTES);
            }
        }
        catch (IOException e) {
            this.m_logger.log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
        }
    }

    @Override
    public void endScript(Connection conn, ScriptRunnerContext ctx) {
        try {
            Date endDate = new Date();
            if (ctx != null && ctx.getOutputStream() != null) {
                ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(Messages.getString("ScriptTimer.3") + this.dateFormat.format(this.m_startDate)));
                ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(Messages.getString("ScriptTimer.4") + this.dateFormat.format(endDate)));
                ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(Messages.getString("ScriptTimer.5") + (endDate.getTime() - this.m_startDate.getTime())));
            }
        }
        catch (IOException e) {
            this.m_logger.log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }
}

