/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.StructuredHelpPage;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.util.print.FormattedTable;
import oracle.dbtools.util.print.PrintTheme;
import oracle.dbtools.util.print.TerminalTableFormatter;

public class Help
extends ParsedCommandListener {
    private final String linesep = System.lineSeparator();
    private final int defaultWidth = 82;

    @Override
    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        try {
            Optional<Integer> lineNumber;
            Optional<StructuredHelpPage> structuredPage;
            String pagePath;
            HelpArgs args = (HelpArgs)parsedCommand.getGrammarValue();
            String command = args.command;
            String subcommand = args.subcommand;
            String string = pagePath = command != null ? command.toUpperCase() : "";
            if (subcommand != null && !subcommand.isEmpty() && (structuredPage = this.getStructuredHelpForCommand(command, pagePath, ctx)).isPresent() && (lineNumber = structuredPage.get().getSectionLineNumber(subcommand)).isPresent()) {
                this.write(ctx, structuredPage.get().getContent() + this.linesep, lineNumber.get());
                return true;
            }
            String helpContent = this.HelpOnOrIndex(command, pagePath, ctx) + this.linesep;
            this.write(ctx, helpContent);
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage() + "\n");
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return true;
    }

    protected String highlightBold(String text) {
        return text;
    }

    protected void write(ScriptRunnerContext ctx, String content) {
        this.write(ctx, content, 0);
    }

    protected void write(ScriptRunnerContext ctx, String content, int lineNumber) {
        ctx.write(content);
    }

    private String HelpOnOrIndex(String command, String pagePath, ScriptRunnerContext ctx) throws Exception {
        if (command == null || command.isBlank()) {
            return this.getHelpProperty("", "", ctx);
        }
        if (command.equalsIgnoreCase("help") || command.equalsIgnoreCase("?")) {
            return this.getHelp(ctx, Id.HELP.getName()).orElse("");
        }
        Object help = "";
        help = (String)help + this.getHelpProperty(command, pagePath, ctx);
        return help;
    }

    private Optional<StructuredHelpPage> getStructuredHelpForCommand(String command, String pagePath, ScriptRunnerContext ctx) {
        if (command == null || command.isBlank()) {
            return Optional.empty();
        }
        String reqKey = command.toUpperCase();
        for (IHelp help : CommandRegistry.getCommandsWithHelp()) {
            if (!help.getCommand().toUpperCase().equals(reqKey) || !(help instanceof CommandListener)) continue;
            Type type = ((CommandListener)((Object)help)).getParserType();
            if (type == null) break;
            return this.buildHelpPagesForCommand(help, type, ctx).getStructured(pagePath);
        }
        return Optional.empty();
    }

    private HelpPages buildHelpPagesForCommand(IHelp help, Type type, ScriptRunnerContext ctx) {
        int lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString());
        return new HelpPagesBuilder(ctx.getEnvironment()).lineSize(lineSize).enableColorCode(ctx.isCommandLine()).addHelpContainerFor(help).addPages(new CommandPageAssemblers(type, new Type[0])).build();
    }

    @Override
    protected Type createType() {
        return Factory.type(Id.HELP).abbrevs("?").addHelpContainer(new HelpBundleBuilder("oracle.dbtools.raptor.newscriptrunner.commands.help.Help").build()).set(Factory.grammar().dataType(HelpArgs.class).defaultValue(new HelpArgs(null, null)).add(Factory.rule(Id.HELP).helpId().eq(Factory.choice(Factory.ref(Id.SET_VARIABLE), Factory.ref(Id.SHOW_VARIABLE), Factory.ref(Id.PATH)))).add(Factory.rule(Id.SET_VARIABLE).flattened().helpId().eq(Factory.seq(HelpArgs::fromSet, Factory.word("set").helpId(), Factory.var("VARIABLE").helpId("VARIABLE")))).add(Factory.rule(Id.SHOW_VARIABLE).flattened().helpId().eq(Factory.seq(HelpArgs::fromShow, Factory.word("show").helpId(), Factory.var("VARIABLE").helpId("VARIABLE")))).add(Factory.rule(Id.PATH).flattened().helpId().eq(Factory.star(HelpArgs::fromPath, Factory.var("PATH")))).build()).build();
    }

    @Override
    public String getDescription() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getHelpProperty(String command, String pagePath, ScriptRunnerContext ctx) throws Exception {
        void var12_22;
        void var12_20;
        void var12_18;
        void var12_16;
        String expandedReqKey;
        TreeMap<String, Supplier<String>> setHelps = new TreeMap<String, Supplier<String>>();
        TreeMap<String, Supplier<String>> showHelps = new TreeMap<String, Supplier<String>>();
        TreeMap<String, Supplier<String>> commandHelps = new TreeMap<String, Supplier<String>>();
        HashSet<String> sqlplusTags = new HashSet<String>();
        HashMap<String, String> commandDescriptions = new HashMap<String, String>();
        Enumeration<String> tagsEnumeration = HelpMessages.getKeys();
        if (tagsEnumeration == null) {
            throw new Exception(Messages.getString("NO_HELP_KEYS"));
        }
        ArrayList<String> tags = Collections.list(tagsEnumeration);
        for (String string : tags) {
            String key = string.toUpperCase();
            if (key.equals("SET")) {
                commandDescriptions.put(string, HelpMessages.getString("SET_DESC"));
                commandHelps.put(key, () -> this.buildSetHelp(() -> this.buildHelpMessageHelp("SET"), setHelps));
                continue;
            }
            if (key.startsWith("SET")) {
                commandDescriptions.put(string, HelpMessages.getString("SET_DESC"));
                setHelps.put(key, () -> this.buildHelpMessageHelp(string));
                continue;
            }
            if (key.equals("SHOW")) {
                commandDescriptions.put(string, HelpMessages.getString("SHOW_DESC"));
                commandHelps.put(key, () -> this.buildShowHelp(() -> this.buildHelpMessageHelp("SHOW"), showHelps));
                continue;
            }
            if (key.startsWith("SHOW")) {
                commandDescriptions.put(string, HelpMessages.getString("SHOW_DESC"));
                showHelps.put(key, () -> this.buildHelpMessageHelp(string));
                continue;
            }
            if (string.trim().length() <= 0) continue;
            commandDescriptions.put(string, HelpMessages.getString(string.toUpperCase() + "_DESC"));
            commandHelps.put(key, () -> this.buildHelpMessageHelp(string));
        }
        HashMap<String, String> expandedCommands = new HashMap<String, String>();
        for (IHelp help : CommandRegistry.getCommandsWithHelp()) {
            String tag = help.getCommand();
            String key = tag.toUpperCase();
            if (key.equals("SET")) {
                commandHelps.put(key, () -> this.buildSetHelp(this.getHelpSupplier(help, ctx, pagePath), setHelps));
            } else if (key.startsWith("SET")) {
                setHelps.put(key, this.getHelpSupplier(help, ctx, pagePath));
            } else if (key.equals("SHOW")) {
                commandHelps.put(key, () -> this.buildShowHelp(this.getHelpSupplier(help, ctx, pagePath), showHelps));
            } else if (key.startsWith("SHOW")) {
                showHelps.put(key, this.getHelpSupplier(help, ctx, pagePath));
            } else if (tag.trim().length() > 0) {
                if (help instanceof CommandListener) {
                    Type type = ((CommandListener)((Object)help)).getParserType();
                    if (type != null) {
                        for (String synonym : type.getSynonyms().get()) {
                            expandedCommands.put(synonym, type.getName());
                        }
                        commandHelps.put(type.getName(), this.getHelpSupplier(help, type, ctx, pagePath));
                    } else {
                        commandHelps.put(key, this.getHelpSupplier(help, ctx, pagePath));
                    }
                } else {
                    commandHelps.put(key, this.getHelpSupplier(help, ctx, pagePath));
                }
            }
            if (!help.isSqlPlus()) {
                sqlplusTags.add(key);
            }
            commandDescriptions.put(key, help.getDescription());
        }
        Object var12_14 = null;
        String reqKey = command.toUpperCase();
        Supplier helpSupplier = (Supplier)commandHelps.get(reqKey);
        if (helpSupplier == null && (expandedReqKey = (String)expandedCommands.get(reqKey)) != null) {
            helpSupplier = (Supplier)commandHelps.get(expandedReqKey);
        }
        if (helpSupplier != null) {
            String string = (String)helpSupplier.get();
        }
        if (var12_16 == null && (helpSupplier = (Supplier)setHelps.get(reqKey)) != null) {
            String string = (String)helpSupplier.get();
        }
        if (var12_18 == null && (helpSupplier = (Supplier)showHelps.get(reqKey)) != null) {
            String string = (String)helpSupplier.get();
        }
        if (var12_20 == null) {
            String string = this.buildHelpHelp(ctx, pagePath.replace("/", " "), commandHelps, sqlplusTags, commandDescriptions);
        }
        return var12_22;
    }

    private Supplier<String> getHelpSupplier(IHelp iHelp, ScriptRunnerContext ctx, String pagePath) {
        return () -> {
            Optional<String> stringOpt = iHelp.getHelp(ctx, pagePath);
            return stringOpt.isPresent() ? stringOpt.get() : null;
        };
    }

    private Supplier<String> getHelpSupplier(IHelp iHelp, Type type, ScriptRunnerContext ctx, String pagePath) {
        return () -> {
            String expandedPagePath = this.expandPagePath(type, pagePath);
            if (expandedPagePath != null) {
                Optional<String> stringOpt = iHelp.getHelp(ctx, expandedPagePath);
                return stringOpt.isPresent() ? stringOpt.get() : null;
            }
            return null;
        };
    }

    private String expandPagePath(Type type, String pagePath) {
        StringBuilder buff = new StringBuilder(type.getName());
        String[] pageComponents = pagePath.split("/");
        for (int c = 1; c < pageComponents.length; ++c) {
            String pageComponent = pageComponents[c];
            buff.append('/');
            boolean foundComponent = false;
            for (Type nestedType : type.getNestedTypes()) {
                if (!nestedType.getSynonyms().get().contains(pageComponent)) continue;
                buff.append(nestedType.getName());
                type = nestedType;
                foundComponent = true;
                break;
            }
            if (foundComponent) continue;
            buff.append(pageComponent);
        }
        return buff.toString();
    }

    private String printColumns(Collection<? extends CharSequence> items, ScriptRunnerContext ctx, Collection<String> sqlplusTags) {
        StringBuilder s = new StringBuilder();
        if (items == null || items.isEmpty()) {
            return "";
        }
        int width = 82;
        if (ctx.isCommandLine() && ctx.getSQLPlusConsoleReader() != null && ctx.getSQLPlusConsoleReader().getWidth() > width) {
            width = ctx.getSQLPlusConsoleReader().getWidth();
        }
        int maxWidth = 0;
        for (CharSequence charSequence : items) {
            maxWidth = Math.max(maxWidth, charSequence.length());
        }
        StringBuilder buff = new StringBuilder();
        int n = width / (maxWidth += 3);
        int col = 0;
        for (CharSequence charSequence : items) {
            int i;
            String name = charSequence.toString();
            if (sqlplusTags.contains(name)) {
                name = this.highlightBold(name);
            }
            if (col < n) {
                buff.append(name);
                for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                    buff.append(' ');
                }
                ++col;
                continue;
            }
            s.append(buff.toString()).append(this.linesep);
            buff.setLength(0);
            col = 0;
            buff.append(name);
            for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                buff.append(' ');
            }
            ++col;
        }
        if (buff.length() > 0) {
            s.append(buff.toString());
        }
        return s.toString();
    }

    private String printColumns(Collection<? extends CharSequence> items, ScriptRunnerContext ctx, Collection<String> sqlplusTags, Map<String, String> commandDescriptions) {
        if (items == null || items.isEmpty()) {
            return "";
        }
        int width = ctx.getSQLPlusConsoleReader() != null ? ctx.getSQLPlusConsoleReader().getWidth() : 82;
        StringBuilder s = new StringBuilder();
        ArrayList<List<String>> helpTable = new ArrayList<List<String>>();
        PrintTheme setTheme = PrintTheme.getTheme(String.valueOf((Object)PrintTheme.EMPTY));
        for (CharSequence charSequence : items) {
            ArrayList<String> cols = new ArrayList<String>();
            String name = charSequence.toString();
            String description = commandDescriptions.get(name);
            if (sqlplusTags.contains(name)) {
                name = this.highlightBold(name);
            }
            cols.add(name == null ? "" : name);
            cols.add(description == null ? "" : description);
            helpTable.add(cols);
        }
        TerminalTableFormatter terminalTableFormatter = new TerminalTableFormatter(helpTable, setTheme, true, width);
        FormattedTable formattedTable = terminalTableFormatter.format();
        String renderedMessages = terminalTableFormatter.renderToString(formattedTable);
        return renderedMessages;
    }

    private String buildSetHelp(Supplier<String> setHeaderSupplier, SortedMap<String, Supplier<String>> setHelps) {
        StringBuilder retBuff = new StringBuilder();
        retBuff.append(setHeaderSupplier.get());
        ArrayList<String> commands = new ArrayList<String>();
        for (String mytag : setHelps.keySet()) {
            String name = mytag.replace("_", " ");
            if (!name.startsWith("SET")) continue;
            commands.add(name.substring(3).trim());
        }
        int columns = 3;
        int columnWidth = 25;
        retBuff.append(this.linesep);
        for (int i = 0; i < commands.size(); ++i) {
            String cmd = (String)commands.get(i);
            retBuff.append(String.format("  %-25s", cmd));
            if ((i + 1) % 3 != 0 && i != commands.size() - 1) continue;
            retBuff.append(this.linesep);
        }
        return retBuff.toString();
    }

    private String buildShowHelp(Supplier<String> showHeaderSupplier, SortedMap<String, Supplier<String>> showHelps) {
        StringBuilder retBuff = new StringBuilder();
        retBuff.append(showHeaderSupplier.get());
        ArrayList<String> commands = new ArrayList<String>();
        for (String mytag : showHelps.keySet()) {
            String name = mytag.replace("_", " ");
            if (!name.startsWith("SHOW")) continue;
            commands.add(name.substring(4).trim());
        }
        int columns = 3;
        int columnWidth = 25;
        retBuff.append(this.linesep);
        for (int i = 0; i < commands.size(); ++i) {
            String cmd = (String)commands.get(i);
            retBuff.append(String.format("  %-25s", cmd));
            if ((i + 1) % 3 != 0 && i != commands.size() - 1) continue;
            retBuff.append(this.linesep);
        }
        return retBuff.toString();
    }

    private String buildHelpHelp(ScriptRunnerContext ctx, String requestedTag, SortedMap<String, Supplier<String>> commandHelps, Collection<String> sqlplusTags, Map<String, String> commandDescriptions) {
        Object retVal = "";
        if (requestedTag != null && requestedTag.length() > 0) {
            retVal = (String)retVal + MessageFormat.format(Messages.getString("Help.ObjectNotFound"), requestedTag);
        }
        retVal = (String)retVal + Messages.getString("LIST_OF_HELP_TOPICS");
        StringBuilder retBuff = new StringBuilder();
        if (ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString())) {
            int cols = 120;
            int maxlen = 0;
            for (String item : commandHelps.keySet()) {
                if (item.length() <= maxlen) continue;
                maxlen = item.length();
            }
            int noscols = 120 % (maxlen + 1);
            Object output = "";
            Object line = "";
            int col = 0;
            for (String item : commandHelps.keySet()) {
                if (col >= noscols) {
                    output = (String)output + (String)line + this.linesep;
                    line = "";
                    col = 0;
                }
                String pad = new String(new char[maxlen - item.length()]).replace('\u0000', ' ');
                line = (String)line + item + pad;
                ++col;
            }
            if (((String)line).length() > 0) {
                output = (String)output + (String)line + this.linesep;
            }
            retVal = (String)retVal + (String)output;
        } else {
            retVal = (String)retVal + this.printColumns(commandHelps.keySet(), ctx, sqlplusTags, commandDescriptions);
            if (ctx.isCommandLine()) {
                retVal = (String)retVal;
            }
        }
        return retVal;
    }

    private String buildHelpMessageHelp(String tag) {
        String help = HelpMessages.getString(tag);
        if (this.wasError(help)) {
            help = null;
        }
        return help;
    }

    private boolean wasError(String retval) {
        return retval == null || retval.startsWith("!") && retval.endsWith("!");
    }

    private static class HelpArgs {
        final String command;
        final String subcommand;

        private HelpArgs(String command, String subcommand) {
            this.command = command;
            this.subcommand = subcommand;
        }

        static HelpArgs fromSet(List<Node> nodes, TransformContext context, Environment environment) {
            return new HelpArgs("set" + String.valueOf(nodes.get(1).getValue()), null);
        }

        static HelpArgs fromShow(List<Node> nodes, TransformContext context, Environment environment) {
            return new HelpArgs("show" + String.valueOf(nodes.get(1).getValue()), null);
        }

        static HelpArgs fromPath(List<Node> nodes, TransformContext context, Environment environment) {
            if (nodes.isEmpty()) {
                return new HelpArgs(null, null);
            }
            if (nodes.size() == 1) {
                return new HelpArgs((String)nodes.get(0).getValue(), null);
            }
            String cmd = (String)nodes.get(0).getValue();
            String sub = nodes.subList(1, nodes.size()).stream().map(node -> (String)node.getValue()).collect(Collectors.joining("/"));
            return new HelpArgs(cmd, sub);
        }
    }

    private static enum Id implements oracle.dbtools.raptor.newscriptrunner.util.parser.Id
    {
        HELP,
        SET_VARIABLE,
        SHOW_VARIABLE,
        PATH;

    }
}

