/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.CodeScan;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.app.BestPractice;
import oracle.dbtools.app.CodeScan;
import oracle.dbtools.app.Issue;
import oracle.dbtools.app.PsrChecks;
import oracle.dbtools.codescan.CodescanMessages;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CodeScan.CodeScanOption;
import oracle.dbtools.raptor.newscriptrunner.commands.CodeScan.CodeScanType;
import oracle.dbtools.raptor.newscriptrunner.commands.CodeScan.Commands;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.util.Directory;
import oracle.dbtools.util.Service;

public class CodeScanExtension
extends ParsedCommandListener
implements SQLCLService {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        Id command = parsedCommand.getType().getId();
        if (command == Commands.CODESCAN) {
            BestPractice scanner = BestPractice.getInstance();
            PsrChecks psrScanner = PsrChecks.getInstance();
            String pathDir = (String)parsedCommand.getOptionValue(CodeScanOption.Options.PATH);
            String format = (String)parsedCommand.getOptionValue(CodeScanOption.Options.FORMAT);
            String output = (String)parsedCommand.getOptionValue(CodeScanOption.Options.OUTPUT);
            String ignoreNo = (String)parsedCommand.getOptionValue(CodeScanOption.Options.IGNORE);
            Object settingsFile = (String)parsedCommand.getOptionValue(CodeScanOption.Options.SETTINGS);
            Boolean AllRules = (Boolean)parsedCommand.getOptionValue(CodeScanOption.Options.LIST_RULES);
            scanner.ruleExclusions = new HashSet();
            if (ignoreNo != null) {
                StringTokenizer st1 = new StringTokenizer(ignoreNo, " ");
                while (st1.hasMoreTokens()) {
                    int ic;
                    String ignoreRule = st1.nextToken();
                    if (ignoreRule.startsWith("\"")) {
                        ignoreRule = ignoreRule.substring(1);
                    }
                    if (ignoreRule.endsWith("\"")) {
                        ignoreRule = ignoreRule.substring(0, ignoreRule.length() - 1);
                    }
                    if (0 < (ic = ignoreRule.indexOf(58))) {
                        ignoreRule = ignoreRule.substring(0, ic);
                    }
                    scanner.ruleExclusions.add(ignoreRule);
                }
            }
            if (pathDir == null) {
                pathDir = ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString());
            }
            if (settingsFile != null) {
                if (((String)settingsFile).startsWith("\"")) {
                    settingsFile = ((String)settingsFile).substring(1);
                }
                if (((String)settingsFile).endsWith("\"")) {
                    settingsFile = ((String)settingsFile).substring(0, ((String)settingsFile).length() - 1);
                }
                if (pathDir != null) {
                    settingsFile = pathDir + "/" + (String)settingsFile;
                }
                try {
                    String settings = Service.readFile((String)settingsFile);
                    Map map = JSON.std.mapFrom((Object)settings);
                    List rules = (List)map.get("ignore");
                    if (rules == null) {
                        this.log_error(ctx, "Missing attribute \"ignore\"\n");
                        return true;
                    }
                    scanner.ruleExclusions = new HashSet();
                    for (String rule : rules) {
                        scanner.ruleExclusions.add(rule);
                    }
                }
                catch (AssertionError e) {
                    this.log_error(ctx, ((Throwable)((Object)e)).getMessage() + "\n");
                }
                catch (IOException e) {
                    this.log_error(ctx, "File " + (String)settingsFile + " not found \n");
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (AllRules != null) {
                Map<String, String> all;
                try {
                    all = CodeScan.listRules();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                for (String name : all.values()) {
                    ctx.writeln(name.replaceAll("^\"|\"$", ""));
                }
                return true;
            }
            boolean isJson = format != null && "json".equals(format.toLowerCase());
            StringBuilder ret = new StringBuilder(isJson ? "[\n" : "");
            ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
            int threshold = 1000000;
            try {
                List<String> files = Directory.visitor4Directory(pathDir, new String[]{"sql", "pks", "pkb", "pkh", "pls", "plb", "pck", "tps", "tpb"}, sqlcl);
                int i = 0;
                int total = 0;
                for (String file : files) {
                    if (sqlcl.getInterrupted()) {
                        System.out.println("\nCancelled codescan");
                        return true;
                    }
                    String msg = "scanned " + ++i + " files...";
                    System.out.print(msg + "\r");
                    String code = null;
                    code = Service.readFile((String)file);
                    if (threshold < code.length()) {
                        code = code.substring(0, threshold);
                    }
                    Set<Issue> report = scanner.report(code);
                    report.addAll(psrScanner.report(code));
                    if (output == null) {
                        report = Issue.filterUnique(report);
                    }
                    total += report.size();
                    if (0 >= report.size()) continue;
                    if (isJson) {
                        ret.append("{\"file\": \"" + file + "\", \"issues\": [\n");
                    } else {
                        ret.append("***** " + file + "\n");
                        ret.append("*** " + report.size() + " distinct warnings\n");
                    }
                    int j = 0;
                    for (Issue iss : report) {
                        if (isJson) {
                            ret.append("     " + iss.toJson() + ",\n");
                        } else {
                            ret.append(iss.toString() + "\n");
                        }
                        ++j;
                    }
                    if (!isJson) continue;
                    ret.deleteCharAt(ret.length() - 2);
                    ret.append("]},\n");
                }
                this.log_info(ctx, i + " files, " + total + " total distinct warnings\n");
            }
            catch (NullPointerException e) {
                this.log_error(ctx, "Directory " + pathDir + " does not exist\n");
            }
            catch (Exception e) {
                this.log_error(ctx, e.getMessage());
                return true;
            }
            if (isJson) {
                if (ret.length() <= "[\n".length()) {
                    ret.setLength(0);
                } else {
                    ret.deleteCharAt(ret.length() - 2);
                    ret.append("]\n");
                }
            }
            if (output != null) {
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(output));
                    writer.write(ret.toString());
                    writer.close();
                }
                catch (Exception e) {
                    this.log_error(ctx, e.getMessage());
                }
            } else {
                this.log_info(ctx, ret.toString());
            }
            return true;
        }
        return false;
    }

    private void log_error(ScriptRunnerContext ctx, String msg) {
        try {
            ctx.write(msg);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, msg);
        }
    }

    private void log_info(ScriptRunnerContext ctx, String msg) {
        try {
            ctx.write(msg);
        }
        catch (Throwable t) {
            this.logger.log(Level.INFO, msg);
        }
    }

    @Override
    protected Type createType() {
        return CodeScanType.commandType();
    }

    @Override
    public Class<? extends CommandListener> getCommandListener() {
        return this.getClass();
    }

    @Override
    public String getExtensionDescription() {
        return CodescanMessages.format("CODESCAN_CMD_DESC", new Object[0]);
    }

    @Override
    public String getExtensionName() {
        return CodescanMessages.format("CODESCAN_CMD_NAME", new Object[0]);
    }

    @Override
    public String getExtensionVersion() {
        return CodescanMessages.format("CODESCAN_VERSION", new Object[0]);
    }

    @Override
    public String getDescription() {
        return CodescanMessages.format("CODESCAN_CMD_DESC", new Object[0]);
    }
}

