/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.common.utils.UtilResources;
import oracle.dbtools.raptor.newscriptrunner.ProviderForSQLPATH;
import oracle.dbtools.raptor.utils.WindowsUtility;

public class SQLPlusProviderForSQLPATH
implements ProviderForSQLPATH {
    @Override
    public String getSQLPATHsetting() {
        String startDir;
        Object sqlPath = ".";
        String fromDBConfig = null;
        if (fromDBConfig == null || fromDBConfig.equals("")) {
            String envSQLPATH = System.getenv("SQLPATH");
            if (envSQLPATH != null && !envSQLPATH.equals("")) {
                if (sqlPath != null) {
                    sqlPath = (String)sqlPath + File.pathSeparator + envSQLPATH;
                }
                return sqlPath;
            }
            fromDBConfig = this.getOracleEnv("SQLPATH");
        }
        Object path = "";
        if (fromDBConfig != null) {
            path = (String)path + fromDBConfig;
        }
        if (sqlPath != null) {
            path = ((String)path).length() > 0 ? (String)sqlPath + File.pathSeparator + (String)path : (String)path + (String)sqlPath;
        }
        if ((startDir = System.getProperties().getProperty("startup.directory")) != null && startDir.trim().length() > 0) {
            path = startDir + File.pathSeparator + (String)path;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOracleEnv(String in) {
        String sqlPath = null;
        if (sqlPath == null && PlatformUtils.isWindows()) {
            String key = "SOFTWARE\\ORACLE";
            try {
                Logger l = Logger.getLogger("");
                Level level = l.getLevel();
                List<String> oracle_keys = null;
                try {
                    l.setLevel(Level.OFF);
                    oracle_keys = WindowsUtility.readStringSubKeys(-2147483646, key);
                }
                finally {
                    l.setLevel(level);
                }
                String homeKey = null;
                HashSet<String> removeDuplicates = new HashSet<String>();
                if (oracle_keys != null) {
                    for (String oracle_key : oracle_keys) {
                        removeDuplicates.add(oracle_key);
                    }
                }
                if (!removeDuplicates.isEmpty()) {
                    for (String oracle_key : removeDuplicates) {
                        String temp = key + "\\" + oracle_key;
                        homeKey = WindowsUtility.readString(-2147483646, temp, "ORACLE_HOME_KEY");
                        oracle.dbtools.util.Logger.info(this.getClass(), UtilResources.getString("TNSHelper.24") + homeKey);
                        if (homeKey == null) continue;
                        sqlPath = WindowsUtility.readString(-2147483646, homeKey, in);
                        oracle.dbtools.util.Logger.info(this.getClass(), UtilResources.getString("TNSHelper.29") + sqlPath);
                    }
                }
            }
            catch (Exception e) {
                oracle.dbtools.util.Logger.finer(this.getClass(), e.getMessage(), e.getCause());
            }
        }
        return sqlPath;
    }
}

