/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.ParsingCancelled;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.mysql.MysqlEarley;
import oracle.dbtools.raptor.newscriptrunner.BufferedReaderStack;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.IScriptParser;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.util.Service;

public class MySQLScriptParser
extends ScriptParser
implements IScriptParser {
    private LinkedList<Integer> splits = new LinkedList();
    private int offset = 0;
    static final String DELIMITER = "DELIMITER";
    static final String DEFAULT_DELIMITER = ";";
    String current_delimiter = ";";

    public MySQLScriptParser(Reader rdr) {
        super(rdr);
    }

    @Override
    List<ParseNode> statements(ParseNode root) {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        if (root.contains("sqlStatement")) {
            ret.add(root);
            return ret;
        }
        for (ParseNode child : root.children()) {
            ret.addAll(this.statements(child));
        }
        return ret;
    }

    @Override
    boolean lazyLex() {
        String rawSQL = this.getRawSQL();
        if (1000000 < rawSQL.length()) {
            return false;
        }
        if (this.src == null) {
            this.src = new ArrayList();
            this.fullSrc = new ArrayList();
            try {
                new Lexer().doParse(rawSQL, 305, "", (ArrayList)this.src, (ArrayList)this.fullSrc, null);
            }
            catch (ParsingCancelled e) {
                return false;
            }
        }
        if (this.lineMap == null) {
            this.lineMap = Service.lineMap((String)rawSQL);
        }
        return true;
    }

    @Override
    public ISQLCommand next() throws IOException {
        if (this.lazyLex() && (this.bailOut == null || !this.bailOut.booleanValue())) {
            try {
                if (this.root == null) {
                    this.root = new MysqlEarley().parse(this.src);
                }
                if (this.root.topLevel != null) {
                    throw new AssertionError((Object)"Parse Error");
                }
                if (this.stmts == null) {
                    this.stmts = this.statements(this.root);
                    if (this.stmts.size() == 0 && 0 < this.src.size()) {
                        throw new AssertionError((Object)"Parse Error");
                    }
                }
                if (0 < this.splits.size()) {
                    this.offset = this.splits.getLast() + 1;
                }
                SQLCommand ret = null;
                while (true) {
                    block36: {
                        try {
                            String sql;
                            ParseNode stmt;
                            block37: {
                                if (this.getRawSQL().length() <= this.offset) {
                                    return null;
                                }
                                LexerToken t = Lexer.getTokenAtCharOffset((List)this.fullSrc, (int)this.offset);
                                if (t.type == Token.WS || t.type == Token.INCOMPLETE) break block36;
                                if (t.type == Token.COMMENT || t.type == Token.LINE_COMMENT) {
                                    ret = new SQLCommand(t.content);
                                    if (t.type == Token.COMMENT) {
                                        ret.setStmtType(SQLCommand.StmtType.G_C_MULTILINECOMMENT);
                                    } else {
                                        ret.setStmtType(SQLCommand.StmtType.G_C_COMMENT);
                                    }
                                    ret.setStmtSubType(SQLCommand.StmtSubType.G_S_COMMENT_PLUS);
                                    ret.setStmtResultType(SQLCommand.StmtResultType.G_R_NONE);
                                    ret.setOrigSQL(t.content);
                                    ret.setModifiedSQL(t.content);
                                    ret.setOrigStartLine(Service.charPos2LineNo0((int[])this.lineMap, (int)t.begin));
                                    ret.setOrigEndLine(Service.charPos2LineNo0((int[])this.lineMap, (int)t.end));
                                    this.splits.add(t.end);
                                    return ret;
                                }
                                stmt = null;
                                for (ParseNode tmp : this.stmts) {
                                    if (((LexerToken)this.src.get((int)tmp.from)).begin > this.offset || this.offset >= ((LexerToken)this.src.get((int)(tmp.to - 1))).end) continue;
                                    stmt = tmp;
                                    break;
                                }
                                if (stmt == null) break block36;
                                String rawSql = this.getRawSQL();
                                sql = rawSql.substring(((LexerToken)this.src.get((int)stmt.from)).begin, ((LexerToken)this.src.get((int)(stmt.to - 1))).end);
                                ParseNode next = this.root.leafAtPos(stmt.to);
                                if (stmt.contains("createProcedure") && next != null && next.contains("';'") || stmt.contains("utilityStatement") && ((LexerToken)this.src.get((int)stmt.from)).content.equalsIgnoreCase("delimiter") && next != null && next.contains("delimiter")) {
                                    sql = rawSql.substring(((LexerToken)this.src.get((int)stmt.from)).begin, ((LexerToken)this.src.get((int)(next.to - 1))).end);
                                }
                                String multitoken = ((LexerToken)this.src.get((int)stmt.from)).content.toLowerCase() + ((LexerToken)this.src.get((int)(stmt.from + 1))).content.toLowerCase();
                                try {
                                    ret = SQLStatementTypes.multiToken.get(multitoken);
                                }
                                catch (Exception e) {
                                    ret = SQLStatementTypes.spaceRequiredTokens.get(((LexerToken)this.src.get((int)stmt.from)).content.toLowerCase());
                                    if (ret != null) break block37;
                                    try {
                                        ret = SQLStatementTypes.halfRecognizedMultiToken.get(((LexerToken)this.src.get((int)stmt.from)).content.toLowerCase());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (ret == null) {
                                ret = new SQLCommand(sql);
                                ret.setStmtType(SQLCommand.StmtType.G_C_SQL);
                                ret.setStmtSubType(SQLCommand.StmtSubType.G_S_UNKNOWN);
                                if (stmt.contains("administrationStatement")) {
                                    ret.setStmtType(SQLCommand.StmtType.G_C_SQLPLUS);
                                }
                                if (stmt.contains("replaceStatement")) {
                                    ret.setStmtResultType(SQLCommand.StmtResultType.G_R_DML);
                                }
                            }
                            if (ret.getStmtType() == SQLCommand.StmtType.G_C_SQL && ret.getStmtSubType() == SQLCommand.StmtSubType.G_S_EXECUTE) {
                                ret.setStmtType(SQLCommand.StmtType.G_C_PLSQL);
                                ret.setStmtSubType(SQLCommand.StmtSubType.G_S_CALL);
                            } else if (ret.getStmtSubType() == SQLCommand.StmtSubType.G_S_USE) {
                                ret.setStmtType(SQLCommand.StmtType.G_C_SQL);
                            }
                            ret.setOrigSQL(sql);
                            ret.setModifiedSQL(sql);
                            ret.setOrigStartLine(Service.charPos2LineNo0((int[])this.lineMap, (int)((LexerToken)this.src.get((int)stmt.from)).begin));
                            ret.setOrigEndLine(Service.charPos2LineNo0((int[])this.lineMap, (int)((LexerToken)this.src.get((int)(stmt.to - 1))).begin));
                            this.splits.add(((LexerToken)this.src.get((int)(stmt.to - 1))).end);
                            return ret;
                        }
                        catch (Exception t) {
                            // empty catch block
                        }
                    }
                    ++this.offset;
                }
            }
            catch (AssertionError e) {
                this.bailOut = true;
            }
        }
        ISQLCommand cmd = null;
        boolean custom_parsing = false;
        if (this.current_delimiter.equals(DEFAULT_DELIMITER)) {
            custom_parsing = false;
            this.customParsing(false);
            cmd = super.next();
        } else {
            custom_parsing = true;
            this.customParsing(true);
            cmd = super.next();
        }
        if (cmd == null) {
            return null;
        }
        if (cmd.getStmtType() == SQLCommand.StmtType.G_C_SQL && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_EXECUTE) {
            cmd.setStmtType(SQLCommand.StmtType.G_C_PLSQL);
            cmd.setStmtSubType(SQLCommand.StmtSubType.G_S_CALL);
        } else if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_DELIMITER && !custom_parsing) {
            String delimiter = this.getDelimiter(cmd.getSQLOrig());
            if (delimiter != null && delimiter.length() > 0) {
                this.current_delimiter = delimiter;
            }
        } else if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_USE) {
            cmd.setStmtType(SQLCommand.StmtType.G_C_SQL);
        }
        return cmd;
    }

    @Override
    public StringBuffer customFindEndOfStatement(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        if (stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_DELIMITER) {
            String delimiter = this.getDelimiter(line);
            if (delimiter != null && delimiter.length() > 0) {
                this.current_delimiter = delimiter;
            }
            searching = false;
            currentStatement.append(line + "\n");
        }
        while (searching) {
            int indexOfDelimiter = line.indexOf(this.current_delimiter);
            if (indexOfDelimiter == -1) {
                searching = true;
                currentStatement.append(line + "\n");
                line = reader.readline(true, false, null, true, this.stateInitial());
                ++this.m_readerLineCnt;
                if (line != null) continue;
                searching = false;
                continue;
            }
            searching = false;
            currentStatement.append(line.substring(0, indexOfDelimiter) + "\n");
            this.setLeftOver(line.substring(indexOfDelimiter + this.current_delimiter.length()));
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        String trimmed = currentStatement.toString().trim();
        if (trimmed.endsWith(this.current_delimiter) && currentStatement.length() > this.current_delimiter.length()) {
            String s = trimmed.substring(0, trimmed.length() - this.current_delimiter.length());
            currentStatement = new StringBuffer(s);
            stmtProperties.setStatementTerminator(this.current_delimiter);
            String tmp = s.trim();
            stmtProperties.setProperty("ECHOABLE_STATEMENT_TERMINATOR", s.substring(tmp.length()));
        }
        return currentStatement;
    }

    private String getDelimiter(String line) {
        return line.trim().substring(DELIMITER.length()).trim();
    }

    public static boolean isMySQL(Connection conn) {
        try {
            if (conn != null && conn.getMetaData().getDriverName().startsWith("MySQL")) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }
}

