/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.sql.Connection;
import oracle.dbtools.core.secrets.TextSecret;

public final class ConnectionDetails {
    private String m_fullString;
    private boolean m_callDialog;
    private String m_connectName;
    private TextSecret m_connectPassword;
    private String m_connectDB;
    private String m_role;
    private boolean m_roleBad;
    private int m_at;
    private int m_slash;
    private Connection m_conn;
    private boolean m_callUsage = false;
    private String m_edition;

    public ConnectionDetails(String fullString, boolean callDialog, String connectName, TextSecret connectPassword, String connectDB, String role, boolean roleBad, int at, int slash, Connection conn, String edition) {
        this.init(fullString, callDialog, connectName, connectPassword, connectDB, role, roleBad, at, slash, conn, edition);
    }

    public ConnectionDetails(String fullString, boolean callDialog, String connectName, TextSecret connectPassword, String connectDB, String role, boolean roleBad, int at, int slash, Connection conn) {
        this.init(fullString, callDialog, connectName, connectPassword, connectDB, role, roleBad, at, slash, conn, "");
    }

    private void init(String fullString, boolean callDialog, String connectName, TextSecret connectPassword, String connectDB, String role, boolean roleBad, int at, int slash, Connection conn, String edition) {
        this.m_fullString = fullString;
        this.m_callDialog = callDialog;
        this.m_connectName = connectName;
        this.m_connectPassword = connectPassword != null ? connectPassword : TextSecret.none();
        this.m_connectDB = connectDB;
        this.m_role = role;
        this.m_roleBad = roleBad;
        this.m_at = at;
        this.m_slash = slash;
        this.m_conn = conn;
        this.m_edition = edition;
    }

    public void setCallDialog(boolean callDialog) {
        this.m_callDialog = callDialog;
    }

    public void setConnectName(String connectName) {
        this.m_connectName = connectName;
    }

    public void setConnectPassword(TextSecret connectPassword) {
        this.m_connectPassword = connectPassword;
        this.m_slash = 1;
        this.rebuildFullText();
    }

    public void setConnectDB(String connectDB) {
        this.m_connectDB = connectDB;
        this.m_at = 1;
        this.rebuildFullText();
    }

    public boolean isCallDialog() {
        return this.m_callDialog;
    }

    public String getFullString() {
        return this.m_fullString;
    }

    public String getConnectName() {
        return this.m_connectName;
    }

    public TextSecret getConnectPassword() {
        return this.m_connectPassword;
    }

    public String getConnectDB() {
        return this.m_connectDB;
    }

    public String getRole() {
        return this.m_role;
    }

    public boolean getRoleBad() {
        return this.m_roleBad;
    }

    public int getAt() {
        return this.m_at;
    }

    public int getSlash() {
        return this.m_slash;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public void setConnection(Connection conn) {
        this.m_conn = conn;
    }

    public boolean getCallUsage() {
        return this.m_callUsage;
    }

    public void setCallUsage(boolean callUsage) {
        this.m_callUsage = callUsage;
    }

    public String getEdition() {
        this.m_edition = this.m_edition.trim();
        if (this.m_edition.length() > 2 && this.m_edition.startsWith("\"") && this.m_edition.endsWith("\"")) {
            return this.m_edition.substring(1, this.m_edition.length() - 1);
        }
        if (this.m_edition.length() > 2 && this.m_edition.startsWith("'") && this.m_edition.endsWith("'")) {
            return this.m_edition.substring(1, this.m_edition.length() - 1);
        }
        return this.m_edition;
    }

    public void setRole(String role) {
        this.m_role = role;
    }

    public void setEdition(String edition) {
        this.m_edition = edition;
    }

    private void rebuildFullText() {
        String edition;
        String role;
        TextSecret pwd;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getConnectName());
        if (this.getSlash() != -1 && (pwd = this.getConnectPassword()) != null && pwd.isPresent()) {
            builder.append('/').append((String)pwd.map(String::new));
        }
        if (this.getAt() != -1) {
            builder.append('@').append(this.getConnectDB());
        }
        if ((role = this.getRole()) != null && role.length() > 0) {
            builder.append(' ').append(role);
        }
        if ((edition = this.getEdition()) != null && edition.length() > 0) {
            builder.append(' ').append(edition);
        }
        this.m_fullString = builder.toString();
    }

    public void cloneFrom(ConnectionDetails source) {
        this.m_fullString = source.getFullString();
        this.m_callDialog = source.isCallDialog();
        this.m_connectName = source.getConnectName();
        this.m_connectPassword = source.getConnectPassword();
        this.m_connectDB = source.getConnectDB();
        this.m_role = source.getRole();
        this.m_roleBad = source.getRoleBad();
        this.m_at = source.getAt();
        this.m_slash = source.getSlash();
        this.m_conn = source.getConnection();
        this.m_callUsage = source.getCallUsage();
    }
}

