/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMP;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.oracle.sql.TemporalDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.util.TemporalUtil;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.sql.DATE;

public class TIMESTAMP
extends TemporalDatum {
    protected TIMESTAMP(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        switch (stringType) {
            case REST: {
                try {
                    if (internalValue instanceof oracle.sql.TIMESTAMP) {
                        TimeZone sessionTZ = NLSProvider.getProvider(connectionProvider.getNLSConnection()).getSessionTimeZone();
                        OraTIMESTAMP ts = OraTIMESTAMP.getInstance((oracle.sql.TIMESTAMP)internalValue).setSessionTimeZone(sessionTZ);
                        return new StringValue(TemporalUtil.toRestString(ts));
                    }
                }
                catch (Exception e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
            case GENERIC: {
                try {
                    return new StringValue(((oracle.sql.TIMESTAMP)internalValue).timestampValue().toString());
                }
                catch (SQLException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        oracle.sql.TIMESTAMP timestampValue = (oracle.sql.TIMESTAMP)internalValue;
        try {
            switch (valueType) {
                case JDBC: {
                    return timestampValue.timestampValue();
                }
            }
            return super.customTypedValue(connectionProvider, value, valueType, target);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return oracle.sql.TIMESTAMP.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 93;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        if (value instanceof oracle.sql.TIMESTAMP) {
            return value;
        }
        if (value instanceof DATE) {
            return new oracle.sql.TIMESTAMP((DATE)value);
        }
        if (value instanceof Timestamp) {
            return new oracle.sql.TIMESTAMP((Timestamp)value);
        }
        if (value instanceof byte[]) {
            return new oracle.sql.TIMESTAMP(Arrays.copyOf((byte[])value, ((byte[])value).length));
        }
        Object superObject = super.customInternalValue(connectionProvider, value);
        if (superObject instanceof OraTemporalDatum) {
            return new oracle.sql.TIMESTAMP(((OraTemporalDatum)superObject).toTimestamp());
        }
        return this.typedValueFromNLSString(connectionProvider, superObject.toString());
    }

    protected oracle.sql.TIMESTAMP typedValueFromNLSString(DataTypeConnectionProvider connectionProvider, String value) {
        OraTIMESTAMPFormat format;
        try {
            format = ((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).getOraTIMESTAMPFormat();
        }
        catch (ParseException pe) {
            format = null;
        }
        return format.parse(value, new ParsePosition(0));
    }

    @Override
    protected String customDataTypeString() {
        Integer scale = this.typeMetadata.get_data_scale();
        if (scale != null) {
            return "TIMESTAMP (" + scale + ")";
        }
        return "TIMESTAMP";
    }

    @Override
    protected String customUnconstrainedDataTypeString() {
        return "TIMESTAMP_UNCONSTRAINED";
    }
}

