/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTimestampDatum;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMPTZ;

public class OraTIMESTAMPTZ
extends OraTemporalDatum
implements OraTimestampDatum {
    public static OraTIMESTAMPTZ getInstance() {
        return OraTIMESTAMPTZ.getInstance(ZonedDateTime.now());
    }

    public static OraTIMESTAMPTZ getInstance(TimeZone timeZone) {
        return OraTIMESTAMPTZ.getInstance(timeZone.toZoneId());
    }

    public static OraTIMESTAMPTZ getInstance(ZoneId zone) {
        return OraTIMESTAMPTZ.getInstance(ZonedDateTime.now(zone));
    }

    public static OraTIMESTAMPTZ getInstance(Calendar calendar, Integer nanos) {
        return calendar != null ? OraTIMESTAMPTZ.getInstance(OraConversions.toInstant(calendar, nanos).atZone(calendar.getTimeZone().toZoneId())) : null;
    }

    public static OraTIMESTAMPTZ getInstance(Calendar calendar) {
        return OraTIMESTAMPTZ.getInstance(calendar, null);
    }

    public static OraTIMESTAMPTZ getInstance(TIMESTAMPTZ datetime) {
        return datetime != null ? new OraTIMESTAMPTZ(new OraTIMESTAMPTZImpl(datetime)) : null;
    }

    public static OraTIMESTAMPTZ getInstance(ZonedDateTime datetime) {
        return datetime != null ? new OraTIMESTAMPTZ(new OraTIMESTAMPTZImpl(datetime)) : null;
    }

    public static OraTIMESTAMPTZ getInstance(OraTemporalDatum temporalDatum) {
        OraTIMESTAMPTZ tsTZ;
        if (temporalDatum != null) {
            tsTZ = OraTIMESTAMPTZ.getInstance();
            tsTZ.replicate(temporalDatum);
        } else {
            tsTZ = null;
        }
        return tsTZ;
    }

    protected OraTIMESTAMPTZ(OraTIMESTAMPTZImpl impl) {
        super(impl);
    }

    @Override
    protected OraTIMESTAMPTZImpl getImpl() {
        return (OraTIMESTAMPTZImpl)super.getImpl();
    }

    @Override
    public Object clone() {
        OraTIMESTAMPTZ other = (OraTIMESTAMPTZ)super.clone();
        return other;
    }

    public void setTimeZone(TimeZone timezone) {
        this.setZone(timezone.toZoneId());
    }

    public void setZone(ZoneId zone) {
        this.getImpl().withZoneSameInstant(zone);
    }

    @Override
    public OraTIMESTAMPTZ setSessionTimeZone(TimeZone sessionTimeZone) {
        super.setSessionTimeZone(sessionTimeZone);
        return this;
    }

    @Override
    public OraTIMESTAMPTZ setSessionZone(ZoneId zone) {
        super.setSessionZone(zone);
        return this;
    }

    @Override
    public void setCalendar(Calendar calendar, Integer nanos) {
        ZonedDateTime newZDT = OraConversions.toInstant(calendar, nanos).atZone(calendar.getTimeZone().toZoneId());
        this.setZonedDateTime(newZDT);
    }

    public void setZonedDateTime(ZonedDateTime datetime) {
        this.getImpl().setZonedDateTime(datetime);
    }

    public TIMESTAMPTZ getDatum() {
        return (TIMESTAMPTZ)super.getDatum();
    }

    public String toString() {
        try {
            OraTIMESTAMPTZFormat formatter = new OraTIMESTAMPTZFormat(new OracleNLSProvider(null).getTimeStampWithTimeZoneFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US));
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static final class OraTIMESTAMPTZImpl
    extends OraTemporalDatum.OraTemporalDatumImpl
    implements OraTimestampDatum.OraTimestampDatumImpl {
        private OraTIMESTAMPTZImpl(TIMESTAMPTZ datetime) {
            super(OraTIMESTAMPTZImpl.unpackTemporalDatum(datetime.shareBytes()));
        }

        protected OraTIMESTAMPTZImpl(ZonedDateTime datetime) {
            super(datetime);
        }

        @Override
        public OraTemporalDatum.Resolution getResolution() {
            return OraTemporalDatum.Resolution.ZONED;
        }

        @Override
        public boolean sessionZoneAdjusted() {
            return false;
        }

        @Override
        public boolean userTimeZoneSupported() {
            return true;
        }

        @Override
        public boolean localSupported() {
            return false;
        }

        @Override
        public OraTemporalDatum.Change replicate(OraTemporalDatum.OraTemporalDatumImpl src) {
            OraTemporalDatum.Change a = super.replicate(src);
            OraTemporalDatum.Change b = this.setZonedDateTime(src.getZonedDateTime());
            return OraTemporalDatum.Change.combine(a, b);
        }

        @Override
        public OraTemporalDatum.Change setValue(OraTemporalDatum.OraTemporalDatumImpl src) {
            OraTemporalDatum.Change change;
            switch (src.getResolution()) {
                case ZONED: {
                    change = this.setZonedDateTime(src.getZonedDateTime());
                    break;
                }
                case INSTANT: {
                    change = this.with(src.toInstant());
                    break;
                }
                default: {
                    change = this.setZonedDateTime(src.getSessionZonedDateTime());
                }
            }
            return change;
        }

        public TIMESTAMPTZ getDatum() {
            byte[] bytes = new byte[13];
            this.packDatumBytes(bytes);
            return new TIMESTAMPTZ(bytes);
        }
    }
}

