/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.sql.Connection;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionWrapper;

public abstract class DataTypeConnectionLockableImpl<C extends Connection>
implements DataTypeConnectionWrapper<C> {
    private final Class<C> connectionClass;

    public DataTypeConnectionLockableImpl(Class<C> connectionClass) {
        this.connectionClass = connectionClass;
    }

    @Override
    public Class<C> getConnectionClass() {
        return this.connectionClass;
    }

    @Override
    public void unlockConnection() throws DataTypeConnectionException {
        LockManager.unlock(this.getConnection());
    }

    @Override
    public C lockConnection() throws DataTypeConnectionException {
        return this.lockConnection(false);
    }

    @Override
    public C lockConnection(boolean prompt) throws DataTypeConnectionException {
        Object connection = this.getConnection();
        if (LockManager.lock(connection, prompt)) {
            return connection;
        }
        return null;
    }
}

