/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.dbtools.data.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.loadservice.ColumnMetadata;
import oracle.dbtools.data.loadservice.DataLoadException;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.data.loadservice.LoadResources;
import oracle.dbtools.data.loadservice.LoadService;
import oracle.dbtools.data.loadservice.LoadSql;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.jdbc.OraclePreparedStatement;

public class LoadServiceJdbcBatch
extends LoadService {
    public static final String SERVICE_TYPE = "JDBC_BATCH";
    private String _insertForErrSql;
    ArrayList<Column> _loadCols;
    boolean _batchErrInit = false;

    @Override
    public String getType() {
        return SERVICE_TYPE;
    }

    @Override
    protected void doLoad() {
        this.getLogger().log(Level.INFO, "load start");
        int batchSize = this.getLoadParms().getBatchRows();
        ArrayList<Object> batchRowsList = new ArrayList<Object>(batchSize);
        int commitBatch = this.getLoadParms().getBatchesPerCommit();
        long batchCount = 0L;
        long fromRow = 1L;
        long toRow = 0L;
        StringBuffer exceptionMessages = null;
        boolean isStatementValid = false;
        try {
            int[] updateCounts;
            int i;
            Object[] row;
            LoadSql loadSql = new LoadSql(this.getSchemaName(), this.getTableName(), this.getLoadParms().getLocale());
            loadSql.useQuotedNames(true);
            this.getReader().start();
            if (!this.getReaderParms().isHeader()) {
                row = new String[this.getTable().getColumnCount()];
                for (int i2 = 0; i2 < this.getReaderParms().getSkipRows(); ++i2) {
                    if (!this.getReader().hasMoreRows()) continue;
                    this.getReader().readline();
                }
            } else {
                try {
                    row = this.getReader().getColumnNames();
                }
                catch (DataFormatException e) {
                    throw new DataLoadException(e.getMessage(), ExitCode.EXIT_SEVERE);
                }
                if (row == null || row.length == 0) {
                    throw new DataLoadException(this.translate("HEADER_NOT_FOUND"), ExitCode.EXIT_SEVERE);
                }
            }
            this._loadCols = new ArrayList();
            ArrayList<String> uniqueIds = new ArrayList<String>();
            for (i = 0; i < row.length; ++i) {
                String format;
                Object column = null;
                if (!this.getReaderParms().isHeader()) {
                    column = this.getTable().getColumnByIndex(i);
                } else {
                    String name = this.getCleanName(this.getColumnName(row[i]), uniqueIds).toUpperCase();
                    column = this.getTable().getColumnByName(name);
                }
                if (column == null) {
                    if (!this.getLoadParms().isUnknownColumnsFail()) continue;
                    throw new DataLoadException(this.translate("UNKNOWN_COL", new Object[]{row[i]}), ExitCode.EXIT_SEVERE);
                }
                ((Column)column).setSourceColID(i);
                boolean customFormatSet = false;
                ColumnMetadata columnMetadata = this.columnMetadata(((Column)column).getName());
                if (columnMetadata != null && (format = columnMetadata.format()) != null && !format.isEmpty()) {
                    ((Column)column).setFormat(format);
                    customFormatSet = true;
                }
                if (customFormatSet) continue;
                if (((Column)column).getType().equals("DATE")) {
                    ((Column)column).setFormat(this.useScannedModel() ? this.getScannedDateFormat() : this.getLoadParms().getDataFormat());
                    continue;
                }
                if (((Column)column).getType().equals("TIMESTAMP")) {
                    ((Column)column).setFormat(this.useScannedModel() ? this.getScannedTimestampFormat() : this.getLoadParms().getTimestampFormat());
                    continue;
                }
                if (!((Column)column).getType().equals("TIMESTAMP WITH TIME ZONE") && !((Column)column).getType().equals("TIMESTAMP WITH LOCAL TIME ZONE")) continue;
                ((Column)column).setFormat(this.useScannedModel() ? this.getScannedTimestampTZFormat() : this.getLoadParms().getTimestampTZFormat());
            }
            i = 0;
            for (Column col : this.getTable().getColumns()) {
                if (col.getSourceColID() != -1 && this.loadColumn(col.getName())) {
                    this._loadCols.add(col);
                    continue;
                }
                if (col.isNullable()) continue;
                throw new DataLoadException(this.translate("OMITTED_COLS"), ExitCode.EXIT_SEVERE);
            }
            String sql = "";
            if (this.getLoadParms().getDeleteRows() != LoadParmsAPI.DELETE_ROWS.FALSE) {
                sql = this.getLoadParms().getDeleteRows() == LoadParmsAPI.DELETE_ROWS.TRUE ? loadSql.getDeleteStatement() : loadSql.getTruncateStatement();
                PreparedStatement pstmt = this.getConnection().prepareStatement(sql);
                pstmt.executeUpdate();
            }
            Column[] loadColumns = new Column[this._loadCols.size()];
            loadColumns = this._loadCols.toArray(loadColumns);
            sql = loadSql.getInsertStatement(loadColumns, row, LoadSql.INSERT_FORMAT.PREPARE);
            if (this.getLoadParms().getResponseFormat() == LoadParmsAPI.RESPONSE_FORMAT.RESPONSE_SQL) {
                this._insertForErrSql = loadSql.getInsertStatement(loadColumns, row, LoadSql.INSERT_FORMAT.ERROR);
            }
            OraclePreparedStatement pstmt = (OraclePreparedStatement)this.getConnection().prepareStatement(sql);
            while (this.checkCanProceed() && this.getReader().hasMoreRows() && !this.importLimitReached()) {
                exceptionMessages = new StringBuffer();
                StringBuffer rowData = new StringBuffer();
                try {
                    if (this.isCancelled()) break;
                    try {
                        row = this.getReader().readline();
                    }
                    catch (DataFormatException e) {
                        exceptionMessages.append("--" + e.getMessage() + "\n");
                        row = e.getColumns();
                    }
                    if (row != null && (isStatementValid = this.getBatchForInsert(this.getTableName(), loadColumns, row, rowData, pstmt, exceptionMessages))) {
                        batchRowsList.add(rowData.toString());
                        ++batchCount;
                        this.addRowsProcessed();
                    }
                    if (batchCount == (long)batchSize || exceptionMessages.length() > 0 && batchCount > 0L) {
                        toRow = fromRow + batchCount - 1L;
                        this.updateBatch(fromRow, toRow);
                        updateCounts = pstmt.executeBatch();
                        this.processUpdateCounts(updateCounts, batchCount, fromRow, batchRowsList);
                        batchCount = 0L;
                        toRow = fromRow = toRow + 1L;
                        batchRowsList.clear();
                        if (this.getLoadParms().getBatchesPerCommit() > 0 && --commitBatch < 1) {
                            this.commitConn();
                            this.lastCommittedRow(toRow - 1L);
                            commitBatch = this.getLoadParms().getBatchesPerCommit();
                        }
                    }
                    if (exceptionMessages.length() <= 0) continue;
                    batchRowsList.add(rowData.toString());
                    this.addRowsProcessed();
                    toRow = fromRow;
                    this.handleBatchUpdateException(new BatchUpdateException(exceptionMessages.toString(), null), 1L, fromRow, toRow, batchRowsList);
                    batchRowsList.clear();
                    toRow = ++fromRow;
                }
                catch (BatchUpdateException e) {
                    this.handleBatchUpdateException(e, batchCount, fromRow, toRow, batchRowsList);
                    batchCount = 0L;
                    fromRow = toRow + 1L;
                    batchRowsList.clear();
                    if (exceptionMessages != null && exceptionMessages.length() > 0) {
                        batchRowsList.add(rowData.toString());
                        this.addRowsProcessed();
                        toRow = fromRow;
                        this.handleBatchUpdateException(new BatchUpdateException(exceptionMessages.toString(), null), 1L, fromRow, toRow, batchRowsList);
                        batchRowsList.clear();
                        toRow = ++fromRow;
                    }
                    if ((!this.checkCanProceed() || this.getLoadParms().getBatchesPerCommit() <= 0 || --commitBatch >= 1) && (this.checkCanProceed() || this.getLoadParms().doCommit() != LoadParmsAPI.DO_COMMIT.COMMIT_ON_ERROR)) continue;
                    this.commitConn();
                    this.lastCommittedRow(fromRow - 1L);
                    commitBatch = this.getLoadParms().getBatchesPerCommit();
                }
            }
            if (batchCount != 0L) {
                toRow = fromRow + batchCount - 1L;
                this.updateBatch(fromRow, toRow);
                updateCounts = pstmt.executeBatch();
                this.processUpdateCounts(updateCounts, batchCount, fromRow, batchRowsList);
                if (this.checkCanProceed()) {
                    this.lastCommittedRow(toRow);
                }
            }
        }
        catch (BatchUpdateException e) {
            this.handleBatchUpdateException(e, batchCount, fromRow, toRow, batchRowsList);
            if (this.checkCanProceed()) {
                this.lastCommittedRow(toRow);
            }
        }
        catch (SQLException e) {
            this.setExitCodeHighest(ExitCode.EXIT_SEVERE);
            this.getLogger().log(Level.WARNING, e.getMessage());
            this.signalCancel();
        }
        catch (DataLoadException e) {
            if (e.getMessage() != null & e.getMessage().length() > 0) {
                try {
                    this.responseErrorMsg(new String[]{e.getMessage()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getLogger().log(Level.WARNING, e.getMessage());
            this.setExitCodeHighest(e.getExitCode());
            this.signalCancel();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, e.getMessage());
            this.setExitCodeHighest(ExitCode.EXIT_SEVERE);
            this.signalCancel();
        }
    }

    private void handleBatchUpdateException(BatchUpdateException e, long batchCount, long fromRow, long toRow, ArrayList<Object> batchRowsList) {
        this.setExitCodeHighest(ExitCode.EXIT_WARNING);
        try {
            int[] updateCounts = e.getUpdateCounts();
            String[] lines = new String[2];
            lines[0] = this.translate("LOAD_PROGRESS_INS_FAIL2", new Object[]{" " + fromRow + " ", " " + toRow + " "});
            if (batchCount == 1L) {
                lines[0] = this.translate("LOAD_PROGRESS_INS_FAIL", new Object[]{" " + fromRow + " "});
            }
            lines[1] = e.getMessage().substring(0, e.getMessage().length() - 1);
            this.responseErrorMsg(lines);
            this.getLogger().log(Level.INFO, lines[0]);
            this.getLogger().log(Level.INFO, lines[1]);
            this.processUpdateCounts(updateCounts, batchCount, fromRow, batchRowsList);
            this.updateBatchException(fromRow, e);
            if (!this.checkCanProceed()) {
                this.signalCancel();
            }
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
            this.setExitCodeHighest(ExitCode.EXIT_SEVERE);
            this.signalCancel();
        }
    }

    private void processUpdateCounts(int[] updateCounts, long batchCount, long fromRow, ArrayList<Object> batchRowsList) throws IOException {
        String rowContents;
        long initialRow = fromRow;
        if (updateCounts == null || updateCounts.length < 1) {
            int i = 0;
            while ((long)i < batchCount) {
                String rowContents2 = (String)batchRowsList.get(i);
                this.responseWriteErrRow(fromRow, rowContents2);
                this.updateRowErrorDetails(initialRow, fromRow, this._insertForErrSql + rowContents2);
                ++i;
                ++fromRow;
            }
            return;
        }
        boolean error = false;
        int i = 0;
        while (i < updateCounts.length) {
            if (updateCounts[i] < 0 && updateCounts[i] != -2 && updateCounts[i] == -3) {
                if (!error) {
                    error = true;
                }
                rowContents = (String)batchRowsList.get(i);
                this.responseWriteErrRow(fromRow, rowContents);
                this.updateRowErrorDetails(initialRow, fromRow, this._insertForErrSql + rowContents);
            }
            ++i;
            ++fromRow;
        }
        if ((long)updateCounts.length < batchCount) {
            i = updateCounts.length;
            while ((long)i < batchCount) {
                rowContents = (String)batchRowsList.get(i);
                this.responseWriteErrRow(fromRow, rowContents);
                this.updateRowErrorDetails(initialRow, fromRow, this._insertForErrSql + rowContents);
                ++i;
                ++fromRow;
            }
            return;
        }
    }

    private void responseWriteErrRow(long rowNumber, String row) throws IOException {
        this.addRowsError();
        String msg = this.translate("ROW", new Object[]{rowNumber});
        if (this.getLoadParms().isResponseFormatSql()) {
            this.responseWrite("--" + msg);
            this.responseWrite(this._insertForErrSql + row);
        } else if (this.getLoadParms().isResponseFormatRaw()) {
            this.responseWrite("#" + this.translate("ERROR") + " " + msg);
            this.responseWrite(row.substring(1, row.length() - 2));
        }
    }

    private boolean getBatchForInsert(String tableName, Column[] cols, Object[] row, StringBuffer rowData, OraclePreparedStatement pstmt, StringBuffer exceptionMessages) {
        ArrayList<Object> orderedRowList = new ArrayList<Object>();
        for (int i = 0; i < cols.length; ++i) {
            if (i < row.length) {
                orderedRowList.add(row[cols[i].getSourceColID()]);
                continue;
            }
            orderedRowList.add("");
        }
        Object[] orderedRow = orderedRowList.toArray();
        String delim = "(";
        ITypeFormattor fmtor = null;
        for (int i = 0; i < orderedRow.length; ++i) {
            fmtor = DataTypeFormatterRegistry.getInstance().getFormattor(cols[i].getType());
            if (fmtor == null) {
                fmtor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
            }
            fmtor.setLocale(this.getLoadParms().getLocale());
            fmtor.setConnection(this.getConnection());
            try {
                rowData.append(delim);
                rowData.append(this.getLoadParms().isResponseFormatRaw() ? orderedRow[i].toString() : fmtor.formatData(orderedRow[i], cols[i]));
                Object colData = fmtor.formatDataForJava(orderedRow[i], cols[i]);
                if (colData != null && colData instanceof String) {
                    String colString = (String)colData;
                    if (colString == null || colString.length() == 0 || colString.equals("''") || colString.equals("NULL")) {
                        pstmt.setNull(i + 1, fmtor.getSqlType(cols[i].getType()));
                    } else {
                        if (cols[i].getType().equals("NCHAR") || cols[i].getType().equals("NVARCHAR2")) {
                            pstmt.setFormOfUse(i + 1, (short)2);
                        }
                        pstmt.setString(i + 1, colString);
                    }
                } else {
                    pstmt.setObject(i + 1, colData, fmtor.getSqlType(cols[i].getType()));
                }
            }
            catch (Exception e) {
                String details = e.getMessage() == null || e.getMessage().equals("null") ? LoadResources.getString("FMT_ERR") : e.getMessage();
                exceptionMessages.append(cols[i].getName() + ": " + details + " ");
            }
            delim = ",";
        }
        rowData.append(");");
        if (exceptionMessages.length() == 0) {
            try {
                pstmt.addBatch();
            }
            catch (Exception e) {
                exceptionMessages.append(e.getMessage());
            }
        }
        return exceptionMessages.length() == 0;
    }
}

