/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

public class ColumnMetadata {
    private final String name;
    private final String dataType;
    private final Integer precision;
    private final Integer scale;
    private final Boolean nullable;
    private final String defaultValue;
    private final String format;

    private ColumnMetadata(Builder builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.precision = builder.precision;
        this.scale = builder.scale;
        this.nullable = builder.nullable;
        this.defaultValue = builder.defaultValue;
        this.format = builder.format;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public String dataType() {
        return this.dataType;
    }

    public Integer precision() {
        return this.precision;
    }

    public Integer scale() {
        return this.scale;
    }

    public Boolean nullable() {
        return this.nullable;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String format() {
        return this.format;
    }

    public static class Builder {
        private String name;
        private String dataType;
        private Integer precision;
        private Integer scale;
        private Boolean nullable;
        private String defaultValue;
        private String format;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder precision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public Builder nullable(Boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public ColumnMetadata build() {
            return new ColumnMetadata(this);
        }
    }
}

