/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.io.PrintWriter;
import java.io.StringWriter;

public class SqlInjectionAnalysisFailure
extends RuntimeException {
    private static final long serialVersionUID = -7288795177855793818L;
    static final int MAX_SOURCE = 80;
    private SqlInjectionFailureTypes safType;
    private String whileParsingSource = null;

    SqlInjectionAnalysisFailure(String msg, Throwable cause) {
        super(msg, cause);
        this.safType = SqlInjectionFailureTypes.SAF_UNLABELED;
    }

    public SqlInjectionAnalysisFailure(String msg) {
        super(msg);
        this.safType = SqlInjectionFailureTypes.SAF_UNLABELED;
    }

    public SqlInjectionAnalysisFailure(SqlInjectionFailureTypes safType, Object ... args) {
        super(safType.formatMsg(args));
        this.safType = safType;
    }

    SqlInjectionFailureTypes getSafType() {
        return this.safType;
    }

    static String stackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    @Override
    public String getMessage() {
        return super.getMessage() + (String)(this.whileParsingSource == null ? "" : " at " + this.whileParsingSource);
    }

    public String getWhileParsingSource() {
        return this.whileParsingSource;
    }

    public void setWhileParsingSource(String whileParsingSource) {
        if (((String)whileParsingSource).length() > 80) {
            whileParsingSource = ((String)whileParsingSource).substring(0, ((String)whileParsingSource).length() - 3) + "...";
        }
        this.whileParsingSource = whileParsingSource;
    }

    static enum SqlInjectionFailureTypes {
        SAF_INTERNAL_ERROR("Internal error "),
        SAF_SYNTAX_ERROR("Syntax error "),
        SAF_TOO_MANY_FAILS("Too many parsing failures, stopping"),
        SAF_RULEID("No case for grammar ruleid =", null),
        SAF_UNLABELED("", null),
        SAF_BAD_TYPE("Unable to resolve PL/SQL expression type "),
        SAF_BAD_SYMB("Unable to resolve symbol "),
        SAF_BAD_PARSE("Parsing "),
        SAF_BAD_CLONE_FUNCFLOW("Attempt to clone used flow "),
        SAF_DB_CORRUPT("Database corrupt ");

        String safMsg;
        String[] seps;

        private SqlInjectionFailureTypes(String msg, String[] seps) {
            this.safMsg = msg;
            this.seps = seps;
        }

        private SqlInjectionFailureTypes(String msg) {
            this.safMsg = msg;
            this.seps = new String[0];
        }

        private String getMsg() {
            return this.safMsg;
        }

        private String[] getSeps() {
            return this.seps;
        }

        private String formatMsg(Object[] args) {
            Object ret = this.safMsg;
            for (int i = 0; i < args.length; ++i) {
                ret = (String)ret + args[i].toString();
                ret = this.seps == null || this.seps.length <= i ? (String)ret + ", " : (String)ret + this.seps[i];
            }
            return ret;
        }
    }
}

