/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.commands.init;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.dbtools.extension.langdata.commands.InitMessages;
import oracle.dbtools.extension.langdata.commands.handler.CommandInterface;
import oracle.dbtools.extension.langdata.commands.handler.LangDataOptions;
import oracle.dbtools.extension.langdata.commands.init.InitCommandCore;
import oracle.dbtools.extension.langdata.commands.init.InitPreCheck;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.exceptions.AppExpertUserInvalid;
import oracle.dbtools.extension.langdata.core.exceptions.IncompatibleDatabaseVersion;
import oracle.dbtools.extension.langdata.core.exceptions.InvalidMountDirectory;
import oracle.dbtools.extension.langdata.core.exceptions.LangDataException;
import oracle.dbtools.extension.langdata.core.exceptions.OMFNotConfigured;
import oracle.dbtools.extension.langdata.core.exceptions.OracleHomeNotFound;
import oracle.dbtools.extension.langdata.core.exceptions.OracleHomeNotReal;
import oracle.dbtools.extension.langdata.core.exceptions.SYSDBAPrivilegesRequired;
import oracle.dbtools.extension.langdata.core.messages.GeneralMessages;
import oracle.dbtools.extension.langdata.core.utils.InitUtils;
import oracle.dbtools.extension.langdata.core.utils.LangUtils;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.runner.SqlClCommandsRunner;

public class InitCommand
implements CommandInterface {
    private String getLangDataPassword(ScriptRunnerContext ctx, String prompt, String existing, String redacted, boolean hide, boolean retry) {
        ConsoleService reader = (ConsoleService)ctx.getProperty("script.runner.jline");
        if (reader != null) {
            Object haveASpace = "";
            if (ctx.getProperty("script.runner.sqlplus.silent") == null) {
                if (hide) {
                    haveASpace = prompt + "(**********?) ";
                } else {
                    if (redacted == null) {
                        redacted = "";
                    }
                    haveASpace = prompt + "('" + redacted + "'?) ";
                }
            }
            String fromConsole = null;
            try {
                fromConsole = ctx.getProperty("script.runner.sqlplus.silent") == null ? (hide ? reader.readInput((String)haveASpace, Character.valueOf('*')) : reader.readInput((String)haveASpace)) : reader.readInput((String)haveASpace, Character.valueOf(' '));
                if (fromConsole == null) {
                    fromConsole = "";
                }
            }
            catch (Exception e) {
                ctx.writeln(e.getLocalizedMessage());
            }
            return fromConsole;
        }
        return "";
    }

    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        try {
            String mount_dir;
            long startTime = System.currentTimeMillis();
            String pdb_name = (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.PDB_NAME);
            String langdata_user_password = parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.LANGDATA_USER_PASSWORD) == null ? this.getLangDataPassword(ctx, "Enter LANGDATA User Password", null, "/*********", true, false) : (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.LANGDATA_USER_PASSWORD);
            String log_directory = (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.LOG_DIRECTORY);
            boolean isAutonomousDB = InitUtils.isADB(conn);
            String utility_directory = (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.UTILITY_DIRECTORY);
            String string = mount_dir = isAutonomousDB ? "" : (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.MOUNT_DIR);
            if (!isAutonomousDB && (mount_dir.isEmpty() || mount_dir == null)) {
                GeneralMessages.errorMessage(InitMessages.getString("MOUNT_DIR_NOT_PROVIDED"));
                return;
            }
            if (!isAutonomousDB && (utility_directory.isEmpty() || utility_directory == null)) {
                GeneralMessages.errorMessage(InitMessages.getString("UTILITY_DIR_NOT_PROVIDED"));
                return;
            }
            GeneralMessages.progressMessage("\n" + InitMessages.getString("PRE_CHECKS_START") + "\n");
            if (isAutonomousDB && LangDataConfig.isVerbose()) {
                ctx.writeln(InitMessages.getString("ADB_ENV"));
            }
            Path installTempDir = Paths.get(LangUtils.getTempDir(), "langdata" + File.separator + "install");
            Path plsqlTempDir = Paths.get(LangUtils.getTempDir(), "langdata" + File.separator + "plsql");
            SqlClCommandsRunner sqlClCommandsRunner = SqlClCommandsRunner.builder().context(ctx).connection(conn).build();
            LangUtils.moveResourceFolderToTemp(this.getClass(), "oracle/dbtools/extension/langdata" + File.separator + "install", installTempDir);
            LangUtils.moveResourceFolderToTemp(this.getClass(), "oracle/dbtools/extension/langdata" + File.separator + "plsql", plsqlTempDir);
            InitPreCheck preCheck = new InitPreCheck(conn, ctx, isAutonomousDB, pdb_name, mount_dir, sqlClCommandsRunner);
            preCheck.runAllPreChecks();
            GeneralMessages.progressMessage("\n" + InitMessages.getString("INSTALLATION_START") + "\n");
            String ORACLE_HOME = isAutonomousDB ? "" : InitUtils.getOH();
            InitCommandCore initCore = new InitCommandCore(conn, ctx, sqlClCommandsRunner, log_directory, isAutonomousDB, pdb_name, langdata_user_password, utility_directory, mount_dir);
            initCore.setupLangData();
            LangUtils.updateConfigParams(conn);
            GeneralMessages.successMessage("\n" + InitMessages.getString("LANGDATA_INSTALL_SUCCESSFULL"));
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            ctx.writeln(InitMessages.format("DURATION_LOG", (double)duration / 1000.0));
        }
        catch (IOException | InterruptedException | URISyntaxException | SQLException | AppExpertUserInvalid | IncompatibleDatabaseVersion | InvalidMountDirectory | LangDataException | OMFNotConfigured | OracleHomeNotFound | OracleHomeNotReal | SYSDBAPrivilegesRequired e) {
            if (LangDataConfig.isDebug()) {
                ctx.writeln(Arrays.toString(e.getStackTrace()));
            }
            ctx.writeln(e.getLocalizedMessage());
        }
    }
}

