/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateSchedulingWindowDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSchedulingWindowRequest
extends BmcRequest<UpdateSchedulingWindowDetails> {
    private String schedulingPolicyId;
    private String schedulingWindowId;
    private UpdateSchedulingWindowDetails updateSchedulingWindowDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSchedulingPolicyId() {
        return this.schedulingPolicyId;
    }

    public String getSchedulingWindowId() {
        return this.schedulingWindowId;
    }

    public UpdateSchedulingWindowDetails getUpdateSchedulingWindowDetails() {
        return this.updateSchedulingWindowDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateSchedulingWindowDetails getBody$() {
        return this.updateSchedulingWindowDetails;
    }

    public Builder toBuilder() {
        return new Builder().schedulingPolicyId(this.schedulingPolicyId).schedulingWindowId(this.schedulingWindowId).updateSchedulingWindowDetails(this.updateSchedulingWindowDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",schedulingPolicyId=").append(String.valueOf(this.schedulingPolicyId));
        sb.append(",schedulingWindowId=").append(String.valueOf(this.schedulingWindowId));
        sb.append(",updateSchedulingWindowDetails=").append(String.valueOf((Object)this.updateSchedulingWindowDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSchedulingWindowRequest)) {
            return false;
        }
        UpdateSchedulingWindowRequest other = (UpdateSchedulingWindowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.schedulingPolicyId, other.schedulingPolicyId) && Objects.equals(this.schedulingWindowId, other.schedulingWindowId) && Objects.equals((Object)this.updateSchedulingWindowDetails, (Object)other.updateSchedulingWindowDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.schedulingPolicyId == null ? 43 : this.schedulingPolicyId.hashCode());
        result = result * 59 + (this.schedulingWindowId == null ? 43 : this.schedulingWindowId.hashCode());
        result = result * 59 + (this.updateSchedulingWindowDetails == null ? 43 : this.updateSchedulingWindowDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSchedulingWindowRequest, UpdateSchedulingWindowDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String schedulingPolicyId = null;
        private String schedulingWindowId = null;
        private UpdateSchedulingWindowDetails updateSchedulingWindowDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder schedulingPolicyId(String schedulingPolicyId) {
            this.schedulingPolicyId = schedulingPolicyId;
            return this;
        }

        public Builder schedulingWindowId(String schedulingWindowId) {
            this.schedulingWindowId = schedulingWindowId;
            return this;
        }

        public Builder updateSchedulingWindowDetails(UpdateSchedulingWindowDetails updateSchedulingWindowDetails) {
            this.updateSchedulingWindowDetails = updateSchedulingWindowDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSchedulingWindowRequest o) {
            this.schedulingPolicyId(o.getSchedulingPolicyId());
            this.schedulingWindowId(o.getSchedulingWindowId());
            this.updateSchedulingWindowDetails(o.getUpdateSchedulingWindowDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSchedulingWindowRequest build() {
            UpdateSchedulingWindowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSchedulingWindowDetails body) {
            this.updateSchedulingWindowDetails(body);
            return this;
        }

        public UpdateSchedulingWindowRequest buildWithoutInvocationCallback() {
            UpdateSchedulingWindowRequest request = new UpdateSchedulingWindowRequest();
            request.schedulingPolicyId = this.schedulingPolicyId;
            request.schedulingWindowId = this.schedulingWindowId;
            request.updateSchedulingWindowDetails = this.updateSchedulingWindowDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

