/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateDataGuardDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDataGuardRequest
extends BmcRequest<UpdateDataGuardDetails> {
    private String databaseId;
    private UpdateDataGuardDetails updateDataGuardDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public UpdateDataGuardDetails getUpdateDataGuardDetails() {
        return this.updateDataGuardDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateDataGuardDetails getBody$() {
        return this.updateDataGuardDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).updateDataGuardDetails(this.updateDataGuardDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",updateDataGuardDetails=").append(String.valueOf((Object)this.updateDataGuardDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDataGuardRequest)) {
            return false;
        }
        UpdateDataGuardRequest other = (UpdateDataGuardRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.updateDataGuardDetails, (Object)other.updateDataGuardDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.updateDataGuardDetails == null ? 43 : this.updateDataGuardDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDataGuardRequest, UpdateDataGuardDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private UpdateDataGuardDetails updateDataGuardDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder updateDataGuardDetails(UpdateDataGuardDetails updateDataGuardDetails) {
            this.updateDataGuardDetails = updateDataGuardDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDataGuardRequest o) {
            this.databaseId(o.getDatabaseId());
            this.updateDataGuardDetails(o.getUpdateDataGuardDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDataGuardRequest build() {
            UpdateDataGuardRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDataGuardDetails body) {
            this.updateDataGuardDetails(body);
            return this;
        }

        public UpdateDataGuardRequest buildWithoutInvocationCallback() {
            UpdateDataGuardRequest request = new UpdateDataGuardRequest();
            request.databaseId = this.databaseId;
            request.updateDataGuardDetails = this.updateDataGuardDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

