/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAutonomousDatabaseCharacterSetsRequest
extends BmcRequest<Void> {
    private String opcRequestId;
    private Boolean isShared;
    private Boolean isDedicated;
    private CharacterSetType characterSetType;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsShared() {
        return this.isShared;
    }

    public Boolean getIsDedicated() {
        return this.isDedicated;
    }

    public CharacterSetType getCharacterSetType() {
        return this.characterSetType;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).isShared(this.isShared).isDedicated(this.isDedicated).characterSetType(this.characterSetType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isShared=").append(String.valueOf(this.isShared));
        sb.append(",isDedicated=").append(String.valueOf(this.isDedicated));
        sb.append(",characterSetType=").append(String.valueOf((Object)this.characterSetType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAutonomousDatabaseCharacterSetsRequest)) {
            return false;
        }
        ListAutonomousDatabaseCharacterSetsRequest other = (ListAutonomousDatabaseCharacterSetsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isShared, other.isShared) && Objects.equals(this.isDedicated, other.isDedicated) && Objects.equals((Object)this.characterSetType, (Object)other.characterSetType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isShared == null ? 43 : this.isShared.hashCode());
        result = result * 59 + (this.isDedicated == null ? 43 : this.isDedicated.hashCode());
        result = result * 59 + (this.characterSetType == null ? 43 : this.characterSetType.hashCode());
        return result;
    }

    public static enum CharacterSetType implements BmcEnum
    {
        Database("DATABASE"),
        National("NATIONAL");

        private final String value;
        private static Map<String, CharacterSetType> map;

        private CharacterSetType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CharacterSetType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid CharacterSetType: " + key);
        }

        static {
            map = new HashMap<String, CharacterSetType>();
            for (CharacterSetType v : CharacterSetType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<ListAutonomousDatabaseCharacterSetsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private Boolean isShared = null;
        private Boolean isDedicated = null;
        private CharacterSetType characterSetType = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isShared(Boolean isShared) {
            this.isShared = isShared;
            return this;
        }

        public Builder isDedicated(Boolean isDedicated) {
            this.isDedicated = isDedicated;
            return this;
        }

        public Builder characterSetType(CharacterSetType characterSetType) {
            this.characterSetType = characterSetType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutonomousDatabaseCharacterSetsRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.isShared(o.getIsShared());
            this.isDedicated(o.getIsDedicated());
            this.characterSetType(o.getCharacterSetType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutonomousDatabaseCharacterSetsRequest build() {
            ListAutonomousDatabaseCharacterSetsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAutonomousDatabaseCharacterSetsRequest buildWithoutInvocationCallback() {
            ListAutonomousDatabaseCharacterSetsRequest request = new ListAutonomousDatabaseCharacterSetsRequest();
            request.opcRequestId = this.opcRequestId;
            request.isShared = this.isShared;
            request.isDedicated = this.isDedicated;
            request.characterSetType = this.characterSetType;
            return request;
        }
    }
}

