/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PdbConversionHistoryEntrySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="target")
    private final Target target;
    @JsonProperty(value="sourceDatabaseId")
    private final String sourceDatabaseId;
    @JsonProperty(value="targetDatabaseId")
    private final String targetDatabaseId;
    @JsonProperty(value="cdbName")
    private final String cdbName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="additionalCdbParams")
    private final String additionalCdbParams;

    @Deprecated
    @ConstructorProperties(value={"id", "action", "target", "sourceDatabaseId", "targetDatabaseId", "cdbName", "lifecycleState", "lifecycleDetails", "timeStarted", "timeEnded", "additionalCdbParams"})
    public PdbConversionHistoryEntrySummary(String id, Action action, Target target, String sourceDatabaseId, String targetDatabaseId, String cdbName, LifecycleState lifecycleState, String lifecycleDetails, Date timeStarted, Date timeEnded, String additionalCdbParams) {
        this.id = id;
        this.action = action;
        this.target = target;
        this.sourceDatabaseId = sourceDatabaseId;
        this.targetDatabaseId = targetDatabaseId;
        this.cdbName = cdbName;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.additionalCdbParams = additionalCdbParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public Action getAction() {
        return this.action;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getSourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    public String getTargetDatabaseId() {
        return this.targetDatabaseId;
    }

    public String getCdbName() {
        return this.cdbName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String getAdditionalCdbParams() {
        return this.additionalCdbParams;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PdbConversionHistoryEntrySummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", target=").append(String.valueOf((Object)this.target));
        sb.append(", sourceDatabaseId=").append(String.valueOf(this.sourceDatabaseId));
        sb.append(", targetDatabaseId=").append(String.valueOf(this.targetDatabaseId));
        sb.append(", cdbName=").append(String.valueOf(this.cdbName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", additionalCdbParams=").append(String.valueOf(this.additionalCdbParams));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PdbConversionHistoryEntrySummary)) {
            return false;
        }
        PdbConversionHistoryEntrySummary other = (PdbConversionHistoryEntrySummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals((Object)this.target, (Object)other.target) && Objects.equals(this.sourceDatabaseId, other.sourceDatabaseId) && Objects.equals(this.targetDatabaseId, other.targetDatabaseId) && Objects.equals(this.cdbName, other.cdbName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.additionalCdbParams, other.additionalCdbParams) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.sourceDatabaseId == null ? 43 : this.sourceDatabaseId.hashCode());
        result = result * 59 + (this.targetDatabaseId == null ? 43 : this.targetDatabaseId.hashCode());
        result = result * 59 + (this.cdbName == null ? 43 : this.cdbName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.additionalCdbParams == null ? 43 : this.additionalCdbParams.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        Precheck("PRECHECK"),
        Convert("CONVERT"),
        Sync("SYNC"),
        SyncRollback("SYNC_ROLLBACK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Target implements BmcEnum
    {
        NewDatabase("NEW_DATABASE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Target> map;

        private Target(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Target create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Target', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Target.class);
            map = new HashMap<String, Target>();
            for (Target v : Target.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="target")
        private Target target;
        @JsonProperty(value="sourceDatabaseId")
        private String sourceDatabaseId;
        @JsonProperty(value="targetDatabaseId")
        private String targetDatabaseId;
        @JsonProperty(value="cdbName")
        private String cdbName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="additionalCdbParams")
        private String additionalCdbParams;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder target(Target target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder sourceDatabaseId(String sourceDatabaseId) {
            this.sourceDatabaseId = sourceDatabaseId;
            this.__explicitlySet__.add("sourceDatabaseId");
            return this;
        }

        public Builder targetDatabaseId(String targetDatabaseId) {
            this.targetDatabaseId = targetDatabaseId;
            this.__explicitlySet__.add("targetDatabaseId");
            return this;
        }

        public Builder cdbName(String cdbName) {
            this.cdbName = cdbName;
            this.__explicitlySet__.add("cdbName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder additionalCdbParams(String additionalCdbParams) {
            this.additionalCdbParams = additionalCdbParams;
            this.__explicitlySet__.add("additionalCdbParams");
            return this;
        }

        public PdbConversionHistoryEntrySummary build() {
            PdbConversionHistoryEntrySummary model = new PdbConversionHistoryEntrySummary(this.id, this.action, this.target, this.sourceDatabaseId, this.targetDatabaseId, this.cdbName, this.lifecycleState, this.lifecycleDetails, this.timeStarted, this.timeEnded, this.additionalCdbParams);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PdbConversionHistoryEntrySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("sourceDatabaseId")) {
                this.sourceDatabaseId(model.getSourceDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("targetDatabaseId")) {
                this.targetDatabaseId(model.getTargetDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("cdbName")) {
                this.cdbName(model.getCdbName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("additionalCdbParams")) {
                this.additionalCdbParams(model.getAdditionalCdbParams());
            }
            return this;
        }
    }
}

