/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.CloudDatabaseManagementConfig;
import com.oracle.bmc.database.model.DataGuardGroup;
import com.oracle.bmc.database.model.DatabaseConnectionStrings;
import com.oracle.bmc.database.model.DbBackupConfig;
import com.oracle.bmc.database.model.EncryptionKeyLocationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="characterSet")
    private final String characterSet;
    @JsonProperty(value="ncharacterSet")
    private final String ncharacterSet;
    @JsonProperty(value="dbHomeId")
    private final String dbHomeId;
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="vmClusterId")
    private final String vmClusterId;
    @JsonProperty(value="dbName")
    private final String dbName;
    @JsonProperty(value="pdbName")
    private final String pdbName;
    @JsonProperty(value="dbWorkload")
    private final String dbWorkload;
    @JsonProperty(value="dbUniqueName")
    private final String dbUniqueName;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lastBackupTimestamp")
    private final Date lastBackupTimestamp;
    @JsonProperty(value="lastBackupDurationInSeconds")
    private final Integer lastBackupDurationInSeconds;
    @JsonProperty(value="lastFailedBackupTimestamp")
    private final Date lastFailedBackupTimestamp;
    @JsonProperty(value="dbBackupConfig")
    private final DbBackupConfig dbBackupConfig;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="connectionStrings")
    private final DatabaseConnectionStrings connectionStrings;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="kmsKeyVersionId")
    private final String kmsKeyVersionId;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="sourceDatabasePointInTimeRecoveryTimestamp")
    private final Date sourceDatabasePointInTimeRecoveryTimestamp;
    @JsonProperty(value="databaseSoftwareImageId")
    private final String databaseSoftwareImageId;
    @JsonProperty(value="isCdb")
    private final Boolean isCdb;
    @JsonProperty(value="databaseManagementConfig")
    private final CloudDatabaseManagementConfig databaseManagementConfig;
    @JsonProperty(value="sidPrefix")
    private final String sidPrefix;
    @JsonProperty(value="keyStoreId")
    private final String keyStoreId;
    @JsonProperty(value="keyStoreWalletName")
    private final String keyStoreWalletName;
    @JsonProperty(value="dataGuardGroup")
    private final DataGuardGroup dataGuardGroup;
    @JsonProperty(value="encryptionKeyLocationDetails")
    private final EncryptionKeyLocationDetails encryptionKeyLocationDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "characterSet", "ncharacterSet", "dbHomeId", "dbSystemId", "vmClusterId", "dbName", "pdbName", "dbWorkload", "dbUniqueName", "lifecycleDetails", "lifecycleState", "timeCreated", "lastBackupTimestamp", "lastBackupDurationInSeconds", "lastFailedBackupTimestamp", "dbBackupConfig", "freeformTags", "definedTags", "connectionStrings", "kmsKeyId", "kmsKeyVersionId", "vaultId", "sourceDatabasePointInTimeRecoveryTimestamp", "databaseSoftwareImageId", "isCdb", "databaseManagementConfig", "sidPrefix", "keyStoreId", "keyStoreWalletName", "dataGuardGroup", "encryptionKeyLocationDetails"})
    public DatabaseSummary(String id, String compartmentId, String characterSet, String ncharacterSet, String dbHomeId, String dbSystemId, String vmClusterId, String dbName, String pdbName, String dbWorkload, String dbUniqueName, String lifecycleDetails, LifecycleState lifecycleState, Date timeCreated, Date lastBackupTimestamp, Integer lastBackupDurationInSeconds, Date lastFailedBackupTimestamp, DbBackupConfig dbBackupConfig, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, DatabaseConnectionStrings connectionStrings, String kmsKeyId, String kmsKeyVersionId, String vaultId, Date sourceDatabasePointInTimeRecoveryTimestamp, String databaseSoftwareImageId, Boolean isCdb, CloudDatabaseManagementConfig databaseManagementConfig, String sidPrefix, String keyStoreId, String keyStoreWalletName, DataGuardGroup dataGuardGroup, EncryptionKeyLocationDetails encryptionKeyLocationDetails) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.characterSet = characterSet;
        this.ncharacterSet = ncharacterSet;
        this.dbHomeId = dbHomeId;
        this.dbSystemId = dbSystemId;
        this.vmClusterId = vmClusterId;
        this.dbName = dbName;
        this.pdbName = pdbName;
        this.dbWorkload = dbWorkload;
        this.dbUniqueName = dbUniqueName;
        this.lifecycleDetails = lifecycleDetails;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.lastBackupTimestamp = lastBackupTimestamp;
        this.lastBackupDurationInSeconds = lastBackupDurationInSeconds;
        this.lastFailedBackupTimestamp = lastFailedBackupTimestamp;
        this.dbBackupConfig = dbBackupConfig;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.connectionStrings = connectionStrings;
        this.kmsKeyId = kmsKeyId;
        this.kmsKeyVersionId = kmsKeyVersionId;
        this.vaultId = vaultId;
        this.sourceDatabasePointInTimeRecoveryTimestamp = sourceDatabasePointInTimeRecoveryTimestamp;
        this.databaseSoftwareImageId = databaseSoftwareImageId;
        this.isCdb = isCdb;
        this.databaseManagementConfig = databaseManagementConfig;
        this.sidPrefix = sidPrefix;
        this.keyStoreId = keyStoreId;
        this.keyStoreWalletName = keyStoreWalletName;
        this.dataGuardGroup = dataGuardGroup;
        this.encryptionKeyLocationDetails = encryptionKeyLocationDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getNcharacterSet() {
        return this.ncharacterSet;
    }

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public String getDbWorkload() {
        return this.dbWorkload;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getLastBackupTimestamp() {
        return this.lastBackupTimestamp;
    }

    public Integer getLastBackupDurationInSeconds() {
        return this.lastBackupDurationInSeconds;
    }

    public Date getLastFailedBackupTimestamp() {
        return this.lastFailedBackupTimestamp;
    }

    public DbBackupConfig getDbBackupConfig() {
        return this.dbBackupConfig;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public DatabaseConnectionStrings getConnectionStrings() {
        return this.connectionStrings;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getKmsKeyVersionId() {
        return this.kmsKeyVersionId;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public Date getSourceDatabasePointInTimeRecoveryTimestamp() {
        return this.sourceDatabasePointInTimeRecoveryTimestamp;
    }

    public String getDatabaseSoftwareImageId() {
        return this.databaseSoftwareImageId;
    }

    public Boolean getIsCdb() {
        return this.isCdb;
    }

    public CloudDatabaseManagementConfig getDatabaseManagementConfig() {
        return this.databaseManagementConfig;
    }

    public String getSidPrefix() {
        return this.sidPrefix;
    }

    public String getKeyStoreId() {
        return this.keyStoreId;
    }

    public String getKeyStoreWalletName() {
        return this.keyStoreWalletName;
    }

    public DataGuardGroup getDataGuardGroup() {
        return this.dataGuardGroup;
    }

    public EncryptionKeyLocationDetails getEncryptionKeyLocationDetails() {
        return this.encryptionKeyLocationDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", characterSet=").append(String.valueOf(this.characterSet));
        sb.append(", ncharacterSet=").append(String.valueOf(this.ncharacterSet));
        sb.append(", dbHomeId=").append(String.valueOf(this.dbHomeId));
        sb.append(", dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(", dbName=").append(String.valueOf(this.dbName));
        sb.append(", pdbName=").append(String.valueOf(this.pdbName));
        sb.append(", dbWorkload=").append(String.valueOf(this.dbWorkload));
        sb.append(", dbUniqueName=").append(String.valueOf(this.dbUniqueName));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lastBackupTimestamp=").append(String.valueOf(this.lastBackupTimestamp));
        sb.append(", lastBackupDurationInSeconds=").append(String.valueOf(this.lastBackupDurationInSeconds));
        sb.append(", lastFailedBackupTimestamp=").append(String.valueOf(this.lastFailedBackupTimestamp));
        sb.append(", dbBackupConfig=").append(String.valueOf((Object)this.dbBackupConfig));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", connectionStrings=").append(String.valueOf((Object)this.connectionStrings));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", kmsKeyVersionId=").append(String.valueOf(this.kmsKeyVersionId));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(", sourceDatabasePointInTimeRecoveryTimestamp=").append(String.valueOf(this.sourceDatabasePointInTimeRecoveryTimestamp));
        sb.append(", databaseSoftwareImageId=").append(String.valueOf(this.databaseSoftwareImageId));
        sb.append(", isCdb=").append(String.valueOf(this.isCdb));
        sb.append(", databaseManagementConfig=").append(String.valueOf((Object)this.databaseManagementConfig));
        sb.append(", sidPrefix=").append(String.valueOf(this.sidPrefix));
        sb.append(", keyStoreId=").append(String.valueOf(this.keyStoreId));
        sb.append(", keyStoreWalletName=").append(String.valueOf(this.keyStoreWalletName));
        sb.append(", dataGuardGroup=").append(String.valueOf((Object)this.dataGuardGroup));
        sb.append(", encryptionKeyLocationDetails=").append(String.valueOf((Object)this.encryptionKeyLocationDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseSummary)) {
            return false;
        }
        DatabaseSummary other = (DatabaseSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.characterSet, other.characterSet) && Objects.equals(this.ncharacterSet, other.ncharacterSet) && Objects.equals(this.dbHomeId, other.dbHomeId) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals(this.dbName, other.dbName) && Objects.equals(this.pdbName, other.pdbName) && Objects.equals(this.dbWorkload, other.dbWorkload) && Objects.equals(this.dbUniqueName, other.dbUniqueName) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.lastBackupTimestamp, other.lastBackupTimestamp) && Objects.equals(this.lastBackupDurationInSeconds, other.lastBackupDurationInSeconds) && Objects.equals(this.lastFailedBackupTimestamp, other.lastFailedBackupTimestamp) && Objects.equals((Object)this.dbBackupConfig, (Object)other.dbBackupConfig) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.connectionStrings, (Object)other.connectionStrings) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.kmsKeyVersionId, other.kmsKeyVersionId) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.sourceDatabasePointInTimeRecoveryTimestamp, other.sourceDatabasePointInTimeRecoveryTimestamp) && Objects.equals(this.databaseSoftwareImageId, other.databaseSoftwareImageId) && Objects.equals(this.isCdb, other.isCdb) && Objects.equals((Object)this.databaseManagementConfig, (Object)other.databaseManagementConfig) && Objects.equals(this.sidPrefix, other.sidPrefix) && Objects.equals(this.keyStoreId, other.keyStoreId) && Objects.equals(this.keyStoreWalletName, other.keyStoreWalletName) && Objects.equals((Object)this.dataGuardGroup, (Object)other.dataGuardGroup) && Objects.equals((Object)this.encryptionKeyLocationDetails, (Object)other.encryptionKeyLocationDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.characterSet == null ? 43 : this.characterSet.hashCode());
        result = result * 59 + (this.ncharacterSet == null ? 43 : this.ncharacterSet.hashCode());
        result = result * 59 + (this.dbHomeId == null ? 43 : this.dbHomeId.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.dbName == null ? 43 : this.dbName.hashCode());
        result = result * 59 + (this.pdbName == null ? 43 : this.pdbName.hashCode());
        result = result * 59 + (this.dbWorkload == null ? 43 : this.dbWorkload.hashCode());
        result = result * 59 + (this.dbUniqueName == null ? 43 : this.dbUniqueName.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lastBackupTimestamp == null ? 43 : this.lastBackupTimestamp.hashCode());
        result = result * 59 + (this.lastBackupDurationInSeconds == null ? 43 : this.lastBackupDurationInSeconds.hashCode());
        result = result * 59 + (this.lastFailedBackupTimestamp == null ? 43 : this.lastFailedBackupTimestamp.hashCode());
        result = result * 59 + (this.dbBackupConfig == null ? 43 : this.dbBackupConfig.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.connectionStrings == null ? 43 : this.connectionStrings.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.kmsKeyVersionId == null ? 43 : this.kmsKeyVersionId.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.sourceDatabasePointInTimeRecoveryTimestamp == null ? 43 : this.sourceDatabasePointInTimeRecoveryTimestamp.hashCode());
        result = result * 59 + (this.databaseSoftwareImageId == null ? 43 : this.databaseSoftwareImageId.hashCode());
        result = result * 59 + (this.isCdb == null ? 43 : this.isCdb.hashCode());
        result = result * 59 + (this.databaseManagementConfig == null ? 43 : this.databaseManagementConfig.hashCode());
        result = result * 59 + (this.sidPrefix == null ? 43 : this.sidPrefix.hashCode());
        result = result * 59 + (this.keyStoreId == null ? 43 : this.keyStoreId.hashCode());
        result = result * 59 + (this.keyStoreWalletName == null ? 43 : this.keyStoreWalletName.hashCode());
        result = result * 59 + (this.dataGuardGroup == null ? 43 : this.dataGuardGroup.hashCode());
        result = result * 59 + (this.encryptionKeyLocationDetails == null ? 43 : this.encryptionKeyLocationDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        BackupInProgress("BACKUP_IN_PROGRESS"),
        Upgrading("UPGRADING"),
        Converting("CONVERTING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        RestoreFailed("RESTORE_FAILED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="characterSet")
        private String characterSet;
        @JsonProperty(value="ncharacterSet")
        private String ncharacterSet;
        @JsonProperty(value="dbHomeId")
        private String dbHomeId;
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="vmClusterId")
        private String vmClusterId;
        @JsonProperty(value="dbName")
        private String dbName;
        @JsonProperty(value="pdbName")
        private String pdbName;
        @JsonProperty(value="dbWorkload")
        private String dbWorkload;
        @JsonProperty(value="dbUniqueName")
        private String dbUniqueName;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lastBackupTimestamp")
        private Date lastBackupTimestamp;
        @JsonProperty(value="lastBackupDurationInSeconds")
        private Integer lastBackupDurationInSeconds;
        @JsonProperty(value="lastFailedBackupTimestamp")
        private Date lastFailedBackupTimestamp;
        @JsonProperty(value="dbBackupConfig")
        private DbBackupConfig dbBackupConfig;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="connectionStrings")
        private DatabaseConnectionStrings connectionStrings;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="kmsKeyVersionId")
        private String kmsKeyVersionId;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="sourceDatabasePointInTimeRecoveryTimestamp")
        private Date sourceDatabasePointInTimeRecoveryTimestamp;
        @JsonProperty(value="databaseSoftwareImageId")
        private String databaseSoftwareImageId;
        @JsonProperty(value="isCdb")
        private Boolean isCdb;
        @JsonProperty(value="databaseManagementConfig")
        private CloudDatabaseManagementConfig databaseManagementConfig;
        @JsonProperty(value="sidPrefix")
        private String sidPrefix;
        @JsonProperty(value="keyStoreId")
        private String keyStoreId;
        @JsonProperty(value="keyStoreWalletName")
        private String keyStoreWalletName;
        @JsonProperty(value="dataGuardGroup")
        private DataGuardGroup dataGuardGroup;
        @JsonProperty(value="encryptionKeyLocationDetails")
        private EncryptionKeyLocationDetails encryptionKeyLocationDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder characterSet(String characterSet) {
            this.characterSet = characterSet;
            this.__explicitlySet__.add("characterSet");
            return this;
        }

        public Builder ncharacterSet(String ncharacterSet) {
            this.ncharacterSet = ncharacterSet;
            this.__explicitlySet__.add("ncharacterSet");
            return this;
        }

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            this.__explicitlySet__.add("dbHomeId");
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            this.__explicitlySet__.add("vmClusterId");
            return this;
        }

        public Builder dbName(String dbName) {
            this.dbName = dbName;
            this.__explicitlySet__.add("dbName");
            return this;
        }

        public Builder pdbName(String pdbName) {
            this.pdbName = pdbName;
            this.__explicitlySet__.add("pdbName");
            return this;
        }

        public Builder dbWorkload(String dbWorkload) {
            this.dbWorkload = dbWorkload;
            this.__explicitlySet__.add("dbWorkload");
            return this;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            this.__explicitlySet__.add("dbUniqueName");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lastBackupTimestamp(Date lastBackupTimestamp) {
            this.lastBackupTimestamp = lastBackupTimestamp;
            this.__explicitlySet__.add("lastBackupTimestamp");
            return this;
        }

        public Builder lastBackupDurationInSeconds(Integer lastBackupDurationInSeconds) {
            this.lastBackupDurationInSeconds = lastBackupDurationInSeconds;
            this.__explicitlySet__.add("lastBackupDurationInSeconds");
            return this;
        }

        public Builder lastFailedBackupTimestamp(Date lastFailedBackupTimestamp) {
            this.lastFailedBackupTimestamp = lastFailedBackupTimestamp;
            this.__explicitlySet__.add("lastFailedBackupTimestamp");
            return this;
        }

        public Builder dbBackupConfig(DbBackupConfig dbBackupConfig) {
            this.dbBackupConfig = dbBackupConfig;
            this.__explicitlySet__.add("dbBackupConfig");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder connectionStrings(DatabaseConnectionStrings connectionStrings) {
            this.connectionStrings = connectionStrings;
            this.__explicitlySet__.add("connectionStrings");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder kmsKeyVersionId(String kmsKeyVersionId) {
            this.kmsKeyVersionId = kmsKeyVersionId;
            this.__explicitlySet__.add("kmsKeyVersionId");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder sourceDatabasePointInTimeRecoveryTimestamp(Date sourceDatabasePointInTimeRecoveryTimestamp) {
            this.sourceDatabasePointInTimeRecoveryTimestamp = sourceDatabasePointInTimeRecoveryTimestamp;
            this.__explicitlySet__.add("sourceDatabasePointInTimeRecoveryTimestamp");
            return this;
        }

        public Builder databaseSoftwareImageId(String databaseSoftwareImageId) {
            this.databaseSoftwareImageId = databaseSoftwareImageId;
            this.__explicitlySet__.add("databaseSoftwareImageId");
            return this;
        }

        public Builder isCdb(Boolean isCdb) {
            this.isCdb = isCdb;
            this.__explicitlySet__.add("isCdb");
            return this;
        }

        public Builder databaseManagementConfig(CloudDatabaseManagementConfig databaseManagementConfig) {
            this.databaseManagementConfig = databaseManagementConfig;
            this.__explicitlySet__.add("databaseManagementConfig");
            return this;
        }

        public Builder sidPrefix(String sidPrefix) {
            this.sidPrefix = sidPrefix;
            this.__explicitlySet__.add("sidPrefix");
            return this;
        }

        public Builder keyStoreId(String keyStoreId) {
            this.keyStoreId = keyStoreId;
            this.__explicitlySet__.add("keyStoreId");
            return this;
        }

        public Builder keyStoreWalletName(String keyStoreWalletName) {
            this.keyStoreWalletName = keyStoreWalletName;
            this.__explicitlySet__.add("keyStoreWalletName");
            return this;
        }

        public Builder dataGuardGroup(DataGuardGroup dataGuardGroup) {
            this.dataGuardGroup = dataGuardGroup;
            this.__explicitlySet__.add("dataGuardGroup");
            return this;
        }

        public Builder encryptionKeyLocationDetails(EncryptionKeyLocationDetails encryptionKeyLocationDetails) {
            this.encryptionKeyLocationDetails = encryptionKeyLocationDetails;
            this.__explicitlySet__.add("encryptionKeyLocationDetails");
            return this;
        }

        public DatabaseSummary build() {
            DatabaseSummary model = new DatabaseSummary(this.id, this.compartmentId, this.characterSet, this.ncharacterSet, this.dbHomeId, this.dbSystemId, this.vmClusterId, this.dbName, this.pdbName, this.dbWorkload, this.dbUniqueName, this.lifecycleDetails, this.lifecycleState, this.timeCreated, this.lastBackupTimestamp, this.lastBackupDurationInSeconds, this.lastFailedBackupTimestamp, this.dbBackupConfig, this.freeformTags, this.definedTags, this.connectionStrings, this.kmsKeyId, this.kmsKeyVersionId, this.vaultId, this.sourceDatabasePointInTimeRecoveryTimestamp, this.databaseSoftwareImageId, this.isCdb, this.databaseManagementConfig, this.sidPrefix, this.keyStoreId, this.keyStoreWalletName, this.dataGuardGroup, this.encryptionKeyLocationDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("characterSet")) {
                this.characterSet(model.getCharacterSet());
            }
            if (model.wasPropertyExplicitlySet("ncharacterSet")) {
                this.ncharacterSet(model.getNcharacterSet());
            }
            if (model.wasPropertyExplicitlySet("dbHomeId")) {
                this.dbHomeId(model.getDbHomeId());
            }
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("vmClusterId")) {
                this.vmClusterId(model.getVmClusterId());
            }
            if (model.wasPropertyExplicitlySet("dbName")) {
                this.dbName(model.getDbName());
            }
            if (model.wasPropertyExplicitlySet("pdbName")) {
                this.pdbName(model.getPdbName());
            }
            if (model.wasPropertyExplicitlySet("dbWorkload")) {
                this.dbWorkload(model.getDbWorkload());
            }
            if (model.wasPropertyExplicitlySet("dbUniqueName")) {
                this.dbUniqueName(model.getDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lastBackupTimestamp")) {
                this.lastBackupTimestamp(model.getLastBackupTimestamp());
            }
            if (model.wasPropertyExplicitlySet("lastBackupDurationInSeconds")) {
                this.lastBackupDurationInSeconds(model.getLastBackupDurationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("lastFailedBackupTimestamp")) {
                this.lastFailedBackupTimestamp(model.getLastFailedBackupTimestamp());
            }
            if (model.wasPropertyExplicitlySet("dbBackupConfig")) {
                this.dbBackupConfig(model.getDbBackupConfig());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("connectionStrings")) {
                this.connectionStrings(model.getConnectionStrings());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyVersionId")) {
                this.kmsKeyVersionId(model.getKmsKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("sourceDatabasePointInTimeRecoveryTimestamp")) {
                this.sourceDatabasePointInTimeRecoveryTimestamp(model.getSourceDatabasePointInTimeRecoveryTimestamp());
            }
            if (model.wasPropertyExplicitlySet("databaseSoftwareImageId")) {
                this.databaseSoftwareImageId(model.getDatabaseSoftwareImageId());
            }
            if (model.wasPropertyExplicitlySet("isCdb")) {
                this.isCdb(model.getIsCdb());
            }
            if (model.wasPropertyExplicitlySet("databaseManagementConfig")) {
                this.databaseManagementConfig(model.getDatabaseManagementConfig());
            }
            if (model.wasPropertyExplicitlySet("sidPrefix")) {
                this.sidPrefix(model.getSidPrefix());
            }
            if (model.wasPropertyExplicitlySet("keyStoreId")) {
                this.keyStoreId(model.getKeyStoreId());
            }
            if (model.wasPropertyExplicitlySet("keyStoreWalletName")) {
                this.keyStoreWalletName(model.getKeyStoreWalletName());
            }
            if (model.wasPropertyExplicitlySet("dataGuardGroup")) {
                this.dataGuardGroup(model.getDataGuardGroup());
            }
            if (model.wasPropertyExplicitlySet("encryptionKeyLocationDetails")) {
                this.encryptionKeyLocationDetails(model.getEncryptionKeyLocationDetails());
            }
            return this;
        }
    }
}

