/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.ActionMember;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateScheduledActionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="actionType")
    private final ActionType actionType;
    @JsonProperty(value="actionParams")
    private final Map<String, String> actionParams;
    @JsonProperty(value="actionMembers")
    private final List<ActionMember> actionMembers;
    @JsonProperty(value="schedulingPlanId")
    private final String schedulingPlanId;
    @JsonProperty(value="schedulingWindowId")
    private final String schedulingWindowId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;

    @Deprecated
    @ConstructorProperties(value={"actionType", "actionParams", "actionMembers", "schedulingPlanId", "schedulingWindowId", "freeformTags", "definedTags", "compartmentId"})
    public CreateScheduledActionDetails(ActionType actionType, Map<String, String> actionParams, List<ActionMember> actionMembers, String schedulingPlanId, String schedulingWindowId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String compartmentId) {
        this.actionType = actionType;
        this.actionParams = actionParams;
        this.actionMembers = actionMembers;
        this.schedulingPlanId = schedulingPlanId;
        this.schedulingWindowId = schedulingWindowId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public Map<String, String> getActionParams() {
        return this.actionParams;
    }

    public List<ActionMember> getActionMembers() {
        return this.actionMembers;
    }

    public String getSchedulingPlanId() {
        return this.schedulingPlanId;
    }

    public String getSchedulingWindowId() {
        return this.schedulingWindowId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateScheduledActionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("actionType=").append(String.valueOf((Object)this.actionType));
        sb.append(", actionParams=").append(String.valueOf(this.actionParams));
        sb.append(", actionMembers=").append(String.valueOf(this.actionMembers));
        sb.append(", schedulingPlanId=").append(String.valueOf(this.schedulingPlanId));
        sb.append(", schedulingWindowId=").append(String.valueOf(this.schedulingWindowId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateScheduledActionDetails)) {
            return false;
        }
        CreateScheduledActionDetails other = (CreateScheduledActionDetails)((Object)o);
        return Objects.equals((Object)this.actionType, (Object)other.actionType) && Objects.equals(this.actionParams, other.actionParams) && Objects.equals(this.actionMembers, other.actionMembers) && Objects.equals(this.schedulingPlanId, other.schedulingPlanId) && Objects.equals(this.schedulingWindowId, other.schedulingWindowId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.compartmentId, other.compartmentId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.actionType == null ? 43 : this.actionType.hashCode());
        result = result * 59 + (this.actionParams == null ? 43 : this.actionParams.hashCode());
        result = result * 59 + (this.actionMembers == null ? 43 : this.actionMembers.hashCode());
        result = result * 59 + (this.schedulingPlanId == null ? 43 : this.schedulingPlanId.hashCode());
        result = result * 59 + (this.schedulingWindowId == null ? 43 : this.schedulingWindowId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ActionType implements BmcEnum
    {
        DbServerFullSoftwareUpdate("DB_SERVER_FULL_SOFTWARE_UPDATE"),
        StorageServerFullSoftwareUpdate("STORAGE_SERVER_FULL_SOFTWARE_UPDATE"),
        NetworkSwitchFullSoftwareUpdate("NETWORK_SWITCH_FULL_SOFTWARE_UPDATE");

        private final String value;
        private static Map<String, ActionType> map;

        private ActionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ActionType: " + key);
        }

        static {
            map = new HashMap<String, ActionType>();
            for (ActionType v : ActionType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="actionType")
        private ActionType actionType;
        @JsonProperty(value="actionParams")
        private Map<String, String> actionParams;
        @JsonProperty(value="actionMembers")
        private List<ActionMember> actionMembers;
        @JsonProperty(value="schedulingPlanId")
        private String schedulingPlanId;
        @JsonProperty(value="schedulingWindowId")
        private String schedulingWindowId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder actionType(ActionType actionType) {
            this.actionType = actionType;
            this.__explicitlySet__.add("actionType");
            return this;
        }

        public Builder actionParams(Map<String, String> actionParams) {
            this.actionParams = actionParams;
            this.__explicitlySet__.add("actionParams");
            return this;
        }

        public Builder actionMembers(List<ActionMember> actionMembers) {
            this.actionMembers = actionMembers;
            this.__explicitlySet__.add("actionMembers");
            return this;
        }

        public Builder schedulingPlanId(String schedulingPlanId) {
            this.schedulingPlanId = schedulingPlanId;
            this.__explicitlySet__.add("schedulingPlanId");
            return this;
        }

        public Builder schedulingWindowId(String schedulingWindowId) {
            this.schedulingWindowId = schedulingWindowId;
            this.__explicitlySet__.add("schedulingWindowId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public CreateScheduledActionDetails build() {
            CreateScheduledActionDetails model = new CreateScheduledActionDetails(this.actionType, this.actionParams, this.actionMembers, this.schedulingPlanId, this.schedulingWindowId, this.freeformTags, this.definedTags, this.compartmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateScheduledActionDetails model) {
            if (model.wasPropertyExplicitlySet("actionType")) {
                this.actionType(model.getActionType());
            }
            if (model.wasPropertyExplicitlySet("actionParams")) {
                this.actionParams(model.getActionParams());
            }
            if (model.wasPropertyExplicitlySet("actionMembers")) {
                this.actionMembers(model.getActionMembers());
            }
            if (model.wasPropertyExplicitlySet("schedulingPlanId")) {
                this.schedulingPlanId(model.getSchedulingPlanId());
            }
            if (model.wasPropertyExplicitlySet("schedulingWindowId")) {
                this.schedulingWindowId(model.getSchedulingWindowId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            return this;
        }
    }
}

