/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.MaintenanceWindow;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateAutonomousVmClusterDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="exadataInfrastructureId")
    private final String exadataInfrastructureId;
    @JsonProperty(value="vmClusterNetworkId")
    private final String vmClusterNetworkId;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="isLocalBackupEnabled")
    private final Boolean isLocalBackupEnabled;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="totalContainerDatabases")
    private final Integer totalContainerDatabases;
    @JsonProperty(value="cpuCoreCountPerNode")
    private final Integer cpuCoreCountPerNode;
    @JsonProperty(value="computeModel")
    private final ComputeModel computeModel;
    @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
    private final Integer memoryPerOracleComputeUnitInGBs;
    @JsonProperty(value="autonomousDataStorageSizeInTBs")
    private final Double autonomousDataStorageSizeInTBs;
    @JsonProperty(value="maintenanceWindowDetails")
    private final MaintenanceWindow maintenanceWindowDetails;
    @JsonProperty(value="dbServers")
    private final List<String> dbServers;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="scanListenerPortTls")
    private final Integer scanListenerPortTls;
    @JsonProperty(value="scanListenerPortNonTls")
    private final Integer scanListenerPortNonTls;
    @JsonProperty(value="isMtlsEnabled")
    private final Boolean isMtlsEnabled;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "displayName", "exadataInfrastructureId", "vmClusterNetworkId", "timeZone", "isLocalBackupEnabled", "licenseModel", "totalContainerDatabases", "cpuCoreCountPerNode", "computeModel", "memoryPerOracleComputeUnitInGBs", "autonomousDataStorageSizeInTBs", "maintenanceWindowDetails", "dbServers", "freeformTags", "definedTags", "scanListenerPortTls", "scanListenerPortNonTls", "isMtlsEnabled"})
    public CreateAutonomousVmClusterDetails(String compartmentId, String displayName, String exadataInfrastructureId, String vmClusterNetworkId, String timeZone, Boolean isLocalBackupEnabled, LicenseModel licenseModel, Integer totalContainerDatabases, Integer cpuCoreCountPerNode, ComputeModel computeModel, Integer memoryPerOracleComputeUnitInGBs, Double autonomousDataStorageSizeInTBs, MaintenanceWindow maintenanceWindowDetails, List<String> dbServers, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Integer scanListenerPortTls, Integer scanListenerPortNonTls, Boolean isMtlsEnabled) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.exadataInfrastructureId = exadataInfrastructureId;
        this.vmClusterNetworkId = vmClusterNetworkId;
        this.timeZone = timeZone;
        this.isLocalBackupEnabled = isLocalBackupEnabled;
        this.licenseModel = licenseModel;
        this.totalContainerDatabases = totalContainerDatabases;
        this.cpuCoreCountPerNode = cpuCoreCountPerNode;
        this.computeModel = computeModel;
        this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
        this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
        this.maintenanceWindowDetails = maintenanceWindowDetails;
        this.dbServers = dbServers;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.scanListenerPortTls = scanListenerPortTls;
        this.scanListenerPortNonTls = scanListenerPortNonTls;
        this.isMtlsEnabled = isMtlsEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public String getVmClusterNetworkId() {
        return this.vmClusterNetworkId;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Boolean getIsLocalBackupEnabled() {
        return this.isLocalBackupEnabled;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public Integer getTotalContainerDatabases() {
        return this.totalContainerDatabases;
    }

    public Integer getCpuCoreCountPerNode() {
        return this.cpuCoreCountPerNode;
    }

    public ComputeModel getComputeModel() {
        return this.computeModel;
    }

    public Integer getMemoryPerOracleComputeUnitInGBs() {
        return this.memoryPerOracleComputeUnitInGBs;
    }

    public Double getAutonomousDataStorageSizeInTBs() {
        return this.autonomousDataStorageSizeInTBs;
    }

    public MaintenanceWindow getMaintenanceWindowDetails() {
        return this.maintenanceWindowDetails;
    }

    public List<String> getDbServers() {
        return this.dbServers;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Integer getScanListenerPortTls() {
        return this.scanListenerPortTls;
    }

    public Integer getScanListenerPortNonTls() {
        return this.scanListenerPortNonTls;
    }

    public Boolean getIsMtlsEnabled() {
        return this.isMtlsEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateAutonomousVmClusterDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", exadataInfrastructureId=").append(String.valueOf(this.exadataInfrastructureId));
        sb.append(", vmClusterNetworkId=").append(String.valueOf(this.vmClusterNetworkId));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(", isLocalBackupEnabled=").append(String.valueOf(this.isLocalBackupEnabled));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", totalContainerDatabases=").append(String.valueOf(this.totalContainerDatabases));
        sb.append(", cpuCoreCountPerNode=").append(String.valueOf(this.cpuCoreCountPerNode));
        sb.append(", computeModel=").append(String.valueOf((Object)this.computeModel));
        sb.append(", memoryPerOracleComputeUnitInGBs=").append(String.valueOf(this.memoryPerOracleComputeUnitInGBs));
        sb.append(", autonomousDataStorageSizeInTBs=").append(String.valueOf(this.autonomousDataStorageSizeInTBs));
        sb.append(", maintenanceWindowDetails=").append(String.valueOf((Object)this.maintenanceWindowDetails));
        sb.append(", dbServers=").append(String.valueOf(this.dbServers));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", scanListenerPortTls=").append(String.valueOf(this.scanListenerPortTls));
        sb.append(", scanListenerPortNonTls=").append(String.valueOf(this.scanListenerPortNonTls));
        sb.append(", isMtlsEnabled=").append(String.valueOf(this.isMtlsEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAutonomousVmClusterDetails)) {
            return false;
        }
        CreateAutonomousVmClusterDetails other = (CreateAutonomousVmClusterDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.exadataInfrastructureId, other.exadataInfrastructureId) && Objects.equals(this.vmClusterNetworkId, other.vmClusterNetworkId) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.isLocalBackupEnabled, other.isLocalBackupEnabled) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals(this.totalContainerDatabases, other.totalContainerDatabases) && Objects.equals(this.cpuCoreCountPerNode, other.cpuCoreCountPerNode) && Objects.equals((Object)this.computeModel, (Object)other.computeModel) && Objects.equals(this.memoryPerOracleComputeUnitInGBs, other.memoryPerOracleComputeUnitInGBs) && Objects.equals(this.autonomousDataStorageSizeInTBs, other.autonomousDataStorageSizeInTBs) && Objects.equals((Object)this.maintenanceWindowDetails, (Object)other.maintenanceWindowDetails) && Objects.equals(this.dbServers, other.dbServers) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.scanListenerPortTls, other.scanListenerPortTls) && Objects.equals(this.scanListenerPortNonTls, other.scanListenerPortNonTls) && Objects.equals(this.isMtlsEnabled, other.isMtlsEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.exadataInfrastructureId == null ? 43 : this.exadataInfrastructureId.hashCode());
        result = result * 59 + (this.vmClusterNetworkId == null ? 43 : this.vmClusterNetworkId.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + (this.isLocalBackupEnabled == null ? 43 : this.isLocalBackupEnabled.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.totalContainerDatabases == null ? 43 : this.totalContainerDatabases.hashCode());
        result = result * 59 + (this.cpuCoreCountPerNode == null ? 43 : this.cpuCoreCountPerNode.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + (this.memoryPerOracleComputeUnitInGBs == null ? 43 : this.memoryPerOracleComputeUnitInGBs.hashCode());
        result = result * 59 + (this.autonomousDataStorageSizeInTBs == null ? 43 : this.autonomousDataStorageSizeInTBs.hashCode());
        result = result * 59 + (this.maintenanceWindowDetails == null ? 43 : this.maintenanceWindowDetails.hashCode());
        result = result * 59 + (this.dbServers == null ? 43 : this.dbServers.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.scanListenerPortTls == null ? 43 : this.scanListenerPortTls.hashCode());
        result = result * 59 + (this.scanListenerPortNonTls == null ? 43 : this.scanListenerPortNonTls.hashCode());
        result = result * 59 + (this.isMtlsEnabled == null ? 43 : this.isMtlsEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE");

        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LicenseModel: " + key);
        }

        static {
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ComputeModel implements BmcEnum
    {
        Ecpu("ECPU"),
        Ocpu("OCPU");

        private final String value;
        private static Map<String, ComputeModel> map;

        private ComputeModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ComputeModel: " + key);
        }

        static {
            map = new HashMap<String, ComputeModel>();
            for (ComputeModel v : ComputeModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="exadataInfrastructureId")
        private String exadataInfrastructureId;
        @JsonProperty(value="vmClusterNetworkId")
        private String vmClusterNetworkId;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="isLocalBackupEnabled")
        private Boolean isLocalBackupEnabled;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="totalContainerDatabases")
        private Integer totalContainerDatabases;
        @JsonProperty(value="cpuCoreCountPerNode")
        private Integer cpuCoreCountPerNode;
        @JsonProperty(value="computeModel")
        private ComputeModel computeModel;
        @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
        private Integer memoryPerOracleComputeUnitInGBs;
        @JsonProperty(value="autonomousDataStorageSizeInTBs")
        private Double autonomousDataStorageSizeInTBs;
        @JsonProperty(value="maintenanceWindowDetails")
        private MaintenanceWindow maintenanceWindowDetails;
        @JsonProperty(value="dbServers")
        private List<String> dbServers;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="scanListenerPortTls")
        private Integer scanListenerPortTls;
        @JsonProperty(value="scanListenerPortNonTls")
        private Integer scanListenerPortNonTls;
        @JsonProperty(value="isMtlsEnabled")
        private Boolean isMtlsEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            this.__explicitlySet__.add("exadataInfrastructureId");
            return this;
        }

        public Builder vmClusterNetworkId(String vmClusterNetworkId) {
            this.vmClusterNetworkId = vmClusterNetworkId;
            this.__explicitlySet__.add("vmClusterNetworkId");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder isLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
            this.__explicitlySet__.add("isLocalBackupEnabled");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder totalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            this.__explicitlySet__.add("totalContainerDatabases");
            return this;
        }

        public Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
            this.__explicitlySet__.add("cpuCoreCountPerNode");
            return this;
        }

        public Builder computeModel(ComputeModel computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            this.__explicitlySet__.add("memoryPerOracleComputeUnitInGBs");
            return this;
        }

        public Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            this.__explicitlySet__.add("autonomousDataStorageSizeInTBs");
            return this;
        }

        public Builder maintenanceWindowDetails(MaintenanceWindow maintenanceWindowDetails) {
            this.maintenanceWindowDetails = maintenanceWindowDetails;
            this.__explicitlySet__.add("maintenanceWindowDetails");
            return this;
        }

        public Builder dbServers(List<String> dbServers) {
            this.dbServers = dbServers;
            this.__explicitlySet__.add("dbServers");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder scanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
            this.__explicitlySet__.add("scanListenerPortTls");
            return this;
        }

        public Builder scanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
            this.__explicitlySet__.add("scanListenerPortNonTls");
            return this;
        }

        public Builder isMtlsEnabled(Boolean isMtlsEnabled) {
            this.isMtlsEnabled = isMtlsEnabled;
            this.__explicitlySet__.add("isMtlsEnabled");
            return this;
        }

        public CreateAutonomousVmClusterDetails build() {
            CreateAutonomousVmClusterDetails model = new CreateAutonomousVmClusterDetails(this.compartmentId, this.displayName, this.exadataInfrastructureId, this.vmClusterNetworkId, this.timeZone, this.isLocalBackupEnabled, this.licenseModel, this.totalContainerDatabases, this.cpuCoreCountPerNode, this.computeModel, this.memoryPerOracleComputeUnitInGBs, this.autonomousDataStorageSizeInTBs, this.maintenanceWindowDetails, this.dbServers, this.freeformTags, this.definedTags, this.scanListenerPortTls, this.scanListenerPortNonTls, this.isMtlsEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateAutonomousVmClusterDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("exadataInfrastructureId")) {
                this.exadataInfrastructureId(model.getExadataInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("vmClusterNetworkId")) {
                this.vmClusterNetworkId(model.getVmClusterNetworkId());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            if (model.wasPropertyExplicitlySet("isLocalBackupEnabled")) {
                this.isLocalBackupEnabled(model.getIsLocalBackupEnabled());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("totalContainerDatabases")) {
                this.totalContainerDatabases(model.getTotalContainerDatabases());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCountPerNode")) {
                this.cpuCoreCountPerNode(model.getCpuCoreCountPerNode());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            if (model.wasPropertyExplicitlySet("memoryPerOracleComputeUnitInGBs")) {
                this.memoryPerOracleComputeUnitInGBs(model.getMemoryPerOracleComputeUnitInGBs());
            }
            if (model.wasPropertyExplicitlySet("autonomousDataStorageSizeInTBs")) {
                this.autonomousDataStorageSizeInTBs(model.getAutonomousDataStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("maintenanceWindowDetails")) {
                this.maintenanceWindowDetails(model.getMaintenanceWindowDetails());
            }
            if (model.wasPropertyExplicitlySet("dbServers")) {
                this.dbServers(model.getDbServers());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTls")) {
                this.scanListenerPortTls(model.getScanListenerPortTls());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortNonTls")) {
                this.scanListenerPortNonTls(model.getScanListenerPortNonTls());
            }
            if (model.wasPropertyExplicitlySet("isMtlsEnabled")) {
                this.isMtlsEnabled(model.getIsMtlsEnabled());
            }
            return this;
        }
    }
}

