/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.EncryptionKeyLocationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackupSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="databaseEdition")
    private final DatabaseEdition databaseEdition;
    @JsonProperty(value="databaseSizeInGBs")
    private final Double databaseSizeInGBs;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="kmsKeyVersionId")
    private final String kmsKeyVersionId;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="keyStoreId")
    private final String keyStoreId;
    @JsonProperty(value="keyStoreWalletName")
    private final String keyStoreWalletName;
    @JsonProperty(value="secondaryKmsKeyIds")
    private final List<String> secondaryKmsKeyIds;
    @JsonProperty(value="retentionPeriodInDays")
    private final Integer retentionPeriodInDays;
    @JsonProperty(value="retentionPeriodInYears")
    private final Integer retentionPeriodInYears;
    @JsonProperty(value="timeExpiryScheduled")
    private final Date timeExpiryScheduled;
    @JsonProperty(value="isUsingOracleManagedKeys")
    private final Boolean isUsingOracleManagedKeys;
    @JsonProperty(value="backupDestinationType")
    private final BackupDestinationType backupDestinationType;
    @JsonProperty(value="encryptionKeyLocationDetails")
    private final EncryptionKeyLocationDetails encryptionKeyLocationDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "databaseId", "displayName", "type", "timeStarted", "timeEnded", "lifecycleDetails", "availabilityDomain", "lifecycleState", "databaseEdition", "databaseSizeInGBs", "shape", "version", "kmsKeyId", "kmsKeyVersionId", "vaultId", "keyStoreId", "keyStoreWalletName", "secondaryKmsKeyIds", "retentionPeriodInDays", "retentionPeriodInYears", "timeExpiryScheduled", "isUsingOracleManagedKeys", "backupDestinationType", "encryptionKeyLocationDetails"})
    public BackupSummary(String id, String compartmentId, String databaseId, String displayName, Type type, Date timeStarted, Date timeEnded, String lifecycleDetails, String availabilityDomain, LifecycleState lifecycleState, DatabaseEdition databaseEdition, Double databaseSizeInGBs, String shape, String version, String kmsKeyId, String kmsKeyVersionId, String vaultId, String keyStoreId, String keyStoreWalletName, List<String> secondaryKmsKeyIds, Integer retentionPeriodInDays, Integer retentionPeriodInYears, Date timeExpiryScheduled, Boolean isUsingOracleManagedKeys, BackupDestinationType backupDestinationType, EncryptionKeyLocationDetails encryptionKeyLocationDetails) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.databaseId = databaseId;
        this.displayName = displayName;
        this.type = type;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.lifecycleDetails = lifecycleDetails;
        this.availabilityDomain = availabilityDomain;
        this.lifecycleState = lifecycleState;
        this.databaseEdition = databaseEdition;
        this.databaseSizeInGBs = databaseSizeInGBs;
        this.shape = shape;
        this.version = version;
        this.kmsKeyId = kmsKeyId;
        this.kmsKeyVersionId = kmsKeyVersionId;
        this.vaultId = vaultId;
        this.keyStoreId = keyStoreId;
        this.keyStoreWalletName = keyStoreWalletName;
        this.secondaryKmsKeyIds = secondaryKmsKeyIds;
        this.retentionPeriodInDays = retentionPeriodInDays;
        this.retentionPeriodInYears = retentionPeriodInYears;
        this.timeExpiryScheduled = timeExpiryScheduled;
        this.isUsingOracleManagedKeys = isUsingOracleManagedKeys;
        this.backupDestinationType = backupDestinationType;
        this.encryptionKeyLocationDetails = encryptionKeyLocationDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Type getType() {
        return this.type;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public DatabaseEdition getDatabaseEdition() {
        return this.databaseEdition;
    }

    public Double getDatabaseSizeInGBs() {
        return this.databaseSizeInGBs;
    }

    public String getShape() {
        return this.shape;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getKmsKeyVersionId() {
        return this.kmsKeyVersionId;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getKeyStoreId() {
        return this.keyStoreId;
    }

    public String getKeyStoreWalletName() {
        return this.keyStoreWalletName;
    }

    public List<String> getSecondaryKmsKeyIds() {
        return this.secondaryKmsKeyIds;
    }

    public Integer getRetentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public Integer getRetentionPeriodInYears() {
        return this.retentionPeriodInYears;
    }

    public Date getTimeExpiryScheduled() {
        return this.timeExpiryScheduled;
    }

    public Boolean getIsUsingOracleManagedKeys() {
        return this.isUsingOracleManagedKeys;
    }

    public BackupDestinationType getBackupDestinationType() {
        return this.backupDestinationType;
    }

    public EncryptionKeyLocationDetails getEncryptionKeyLocationDetails() {
        return this.encryptionKeyLocationDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackupSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", databaseEdition=").append(String.valueOf((Object)this.databaseEdition));
        sb.append(", databaseSizeInGBs=").append(String.valueOf(this.databaseSizeInGBs));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", kmsKeyVersionId=").append(String.valueOf(this.kmsKeyVersionId));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(", keyStoreId=").append(String.valueOf(this.keyStoreId));
        sb.append(", keyStoreWalletName=").append(String.valueOf(this.keyStoreWalletName));
        sb.append(", secondaryKmsKeyIds=").append(String.valueOf(this.secondaryKmsKeyIds));
        sb.append(", retentionPeriodInDays=").append(String.valueOf(this.retentionPeriodInDays));
        sb.append(", retentionPeriodInYears=").append(String.valueOf(this.retentionPeriodInYears));
        sb.append(", timeExpiryScheduled=").append(String.valueOf(this.timeExpiryScheduled));
        sb.append(", isUsingOracleManagedKeys=").append(String.valueOf(this.isUsingOracleManagedKeys));
        sb.append(", backupDestinationType=").append(String.valueOf((Object)this.backupDestinationType));
        sb.append(", encryptionKeyLocationDetails=").append(String.valueOf((Object)this.encryptionKeyLocationDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupSummary)) {
            return false;
        }
        BackupSummary other = (BackupSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.databaseEdition, (Object)other.databaseEdition) && Objects.equals(this.databaseSizeInGBs, other.databaseSizeInGBs) && Objects.equals(this.shape, other.shape) && Objects.equals(this.version, other.version) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.kmsKeyVersionId, other.kmsKeyVersionId) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.keyStoreId, other.keyStoreId) && Objects.equals(this.keyStoreWalletName, other.keyStoreWalletName) && Objects.equals(this.secondaryKmsKeyIds, other.secondaryKmsKeyIds) && Objects.equals(this.retentionPeriodInDays, other.retentionPeriodInDays) && Objects.equals(this.retentionPeriodInYears, other.retentionPeriodInYears) && Objects.equals(this.timeExpiryScheduled, other.timeExpiryScheduled) && Objects.equals(this.isUsingOracleManagedKeys, other.isUsingOracleManagedKeys) && Objects.equals((Object)this.backupDestinationType, (Object)other.backupDestinationType) && Objects.equals((Object)this.encryptionKeyLocationDetails, (Object)other.encryptionKeyLocationDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.databaseEdition == null ? 43 : this.databaseEdition.hashCode());
        result = result * 59 + (this.databaseSizeInGBs == null ? 43 : this.databaseSizeInGBs.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.kmsKeyVersionId == null ? 43 : this.kmsKeyVersionId.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.keyStoreId == null ? 43 : this.keyStoreId.hashCode());
        result = result * 59 + (this.keyStoreWalletName == null ? 43 : this.keyStoreWalletName.hashCode());
        result = result * 59 + (this.secondaryKmsKeyIds == null ? 43 : this.secondaryKmsKeyIds.hashCode());
        result = result * 59 + (this.retentionPeriodInDays == null ? 43 : this.retentionPeriodInDays.hashCode());
        result = result * 59 + (this.retentionPeriodInYears == null ? 43 : this.retentionPeriodInYears.hashCode());
        result = result * 59 + (this.timeExpiryScheduled == null ? 43 : this.timeExpiryScheduled.hashCode());
        result = result * 59 + (this.isUsingOracleManagedKeys == null ? 43 : this.isUsingOracleManagedKeys.hashCode());
        result = result * 59 + (this.backupDestinationType == null ? 43 : this.backupDestinationType.hashCode());
        result = result * 59 + (this.encryptionKeyLocationDetails == null ? 43 : this.encryptionKeyLocationDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Incremental("INCREMENTAL"),
        Full("FULL"),
        VirtualFull("VIRTUAL_FULL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        Restoring("RESTORING"),
        Updating("UPDATING"),
        Canceling("CANCELING"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseEdition implements BmcEnum
    {
        StandardEdition("STANDARD_EDITION"),
        EnterpriseEdition("ENTERPRISE_EDITION"),
        EnterpriseEditionHighPerformance("ENTERPRISE_EDITION_HIGH_PERFORMANCE"),
        EnterpriseEditionExtremePerformance("ENTERPRISE_EDITION_EXTREME_PERFORMANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DatabaseEdition> map;

        private DatabaseEdition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseEdition create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DatabaseEdition', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DatabaseEdition.class);
            map = new HashMap<String, DatabaseEdition>();
            for (DatabaseEdition v : DatabaseEdition.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BackupDestinationType implements BmcEnum
    {
        ObjectStore("OBJECT_STORE"),
        Dbrs("DBRS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BackupDestinationType> map;

        private BackupDestinationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BackupDestinationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BackupDestinationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BackupDestinationType.class);
            map = new HashMap<String, BackupDestinationType>();
            for (BackupDestinationType v : BackupDestinationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="databaseEdition")
        private DatabaseEdition databaseEdition;
        @JsonProperty(value="databaseSizeInGBs")
        private Double databaseSizeInGBs;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="kmsKeyVersionId")
        private String kmsKeyVersionId;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="keyStoreId")
        private String keyStoreId;
        @JsonProperty(value="keyStoreWalletName")
        private String keyStoreWalletName;
        @JsonProperty(value="secondaryKmsKeyIds")
        private List<String> secondaryKmsKeyIds;
        @JsonProperty(value="retentionPeriodInDays")
        private Integer retentionPeriodInDays;
        @JsonProperty(value="retentionPeriodInYears")
        private Integer retentionPeriodInYears;
        @JsonProperty(value="timeExpiryScheduled")
        private Date timeExpiryScheduled;
        @JsonProperty(value="isUsingOracleManagedKeys")
        private Boolean isUsingOracleManagedKeys;
        @JsonProperty(value="backupDestinationType")
        private BackupDestinationType backupDestinationType;
        @JsonProperty(value="encryptionKeyLocationDetails")
        private EncryptionKeyLocationDetails encryptionKeyLocationDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder databaseEdition(DatabaseEdition databaseEdition) {
            this.databaseEdition = databaseEdition;
            this.__explicitlySet__.add("databaseEdition");
            return this;
        }

        public Builder databaseSizeInGBs(Double databaseSizeInGBs) {
            this.databaseSizeInGBs = databaseSizeInGBs;
            this.__explicitlySet__.add("databaseSizeInGBs");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder kmsKeyVersionId(String kmsKeyVersionId) {
            this.kmsKeyVersionId = kmsKeyVersionId;
            this.__explicitlySet__.add("kmsKeyVersionId");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder keyStoreId(String keyStoreId) {
            this.keyStoreId = keyStoreId;
            this.__explicitlySet__.add("keyStoreId");
            return this;
        }

        public Builder keyStoreWalletName(String keyStoreWalletName) {
            this.keyStoreWalletName = keyStoreWalletName;
            this.__explicitlySet__.add("keyStoreWalletName");
            return this;
        }

        public Builder secondaryKmsKeyIds(List<String> secondaryKmsKeyIds) {
            this.secondaryKmsKeyIds = secondaryKmsKeyIds;
            this.__explicitlySet__.add("secondaryKmsKeyIds");
            return this;
        }

        public Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            this.__explicitlySet__.add("retentionPeriodInDays");
            return this;
        }

        public Builder retentionPeriodInYears(Integer retentionPeriodInYears) {
            this.retentionPeriodInYears = retentionPeriodInYears;
            this.__explicitlySet__.add("retentionPeriodInYears");
            return this;
        }

        public Builder timeExpiryScheduled(Date timeExpiryScheduled) {
            this.timeExpiryScheduled = timeExpiryScheduled;
            this.__explicitlySet__.add("timeExpiryScheduled");
            return this;
        }

        public Builder isUsingOracleManagedKeys(Boolean isUsingOracleManagedKeys) {
            this.isUsingOracleManagedKeys = isUsingOracleManagedKeys;
            this.__explicitlySet__.add("isUsingOracleManagedKeys");
            return this;
        }

        public Builder backupDestinationType(BackupDestinationType backupDestinationType) {
            this.backupDestinationType = backupDestinationType;
            this.__explicitlySet__.add("backupDestinationType");
            return this;
        }

        public Builder encryptionKeyLocationDetails(EncryptionKeyLocationDetails encryptionKeyLocationDetails) {
            this.encryptionKeyLocationDetails = encryptionKeyLocationDetails;
            this.__explicitlySet__.add("encryptionKeyLocationDetails");
            return this;
        }

        public BackupSummary build() {
            BackupSummary model = new BackupSummary(this.id, this.compartmentId, this.databaseId, this.displayName, this.type, this.timeStarted, this.timeEnded, this.lifecycleDetails, this.availabilityDomain, this.lifecycleState, this.databaseEdition, this.databaseSizeInGBs, this.shape, this.version, this.kmsKeyId, this.kmsKeyVersionId, this.vaultId, this.keyStoreId, this.keyStoreWalletName, this.secondaryKmsKeyIds, this.retentionPeriodInDays, this.retentionPeriodInYears, this.timeExpiryScheduled, this.isUsingOracleManagedKeys, this.backupDestinationType, this.encryptionKeyLocationDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackupSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("databaseEdition")) {
                this.databaseEdition(model.getDatabaseEdition());
            }
            if (model.wasPropertyExplicitlySet("databaseSizeInGBs")) {
                this.databaseSizeInGBs(model.getDatabaseSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyVersionId")) {
                this.kmsKeyVersionId(model.getKmsKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("keyStoreId")) {
                this.keyStoreId(model.getKeyStoreId());
            }
            if (model.wasPropertyExplicitlySet("keyStoreWalletName")) {
                this.keyStoreWalletName(model.getKeyStoreWalletName());
            }
            if (model.wasPropertyExplicitlySet("secondaryKmsKeyIds")) {
                this.secondaryKmsKeyIds(model.getSecondaryKmsKeyIds());
            }
            if (model.wasPropertyExplicitlySet("retentionPeriodInDays")) {
                this.retentionPeriodInDays(model.getRetentionPeriodInDays());
            }
            if (model.wasPropertyExplicitlySet("retentionPeriodInYears")) {
                this.retentionPeriodInYears(model.getRetentionPeriodInYears());
            }
            if (model.wasPropertyExplicitlySet("timeExpiryScheduled")) {
                this.timeExpiryScheduled(model.getTimeExpiryScheduled());
            }
            if (model.wasPropertyExplicitlySet("isUsingOracleManagedKeys")) {
                this.isUsingOracleManagedKeys(model.getIsUsingOracleManagedKeys());
            }
            if (model.wasPropertyExplicitlySet("backupDestinationType")) {
                this.backupDestinationType(model.getBackupDestinationType());
            }
            if (model.wasPropertyExplicitlySet("encryptionKeyLocationDetails")) {
                this.encryptionKeyLocationDetails(model.getEncryptionKeyLocationDetails());
            }
            return this;
        }
    }
}

