/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousContainerDatabaseDataguard
extends ExplicitlySetBmcModel {
    @JsonProperty(value="autonomousContainerDatabaseId")
    private final String autonomousContainerDatabaseId;
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="protectionMode")
    private final ProtectionMode protectionMode;
    @JsonProperty(value="fastStartFailOverLagLimitInSeconds")
    private final Integer fastStartFailOverLagLimitInSeconds;
    @JsonProperty(value="applyLag")
    private final String applyLag;
    @JsonProperty(value="applyRate")
    private final String applyRate;
    @JsonProperty(value="isAutomaticFailoverEnabled")
    private final Boolean isAutomaticFailoverEnabled;
    @JsonProperty(value="transportLag")
    private final String transportLag;
    @JsonProperty(value="timeLastSynced")
    private final Date timeLastSynced;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastRoleChanged")
    private final Date timeLastRoleChanged;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="timeLagRefreshedOn")
    private final Date timeLagRefreshedOn;
    @JsonProperty(value="redoTransportMode")
    private final String redoTransportMode;
    @JsonProperty(value="automaticFailoverTarget")
    private final String automaticFailoverTarget;

    @Deprecated
    @ConstructorProperties(value={"autonomousContainerDatabaseId", "role", "lifecycleState", "lifecycleDetails", "protectionMode", "fastStartFailOverLagLimitInSeconds", "applyLag", "applyRate", "isAutomaticFailoverEnabled", "transportLag", "timeLastSynced", "timeCreated", "timeLastRoleChanged", "availabilityDomain", "timeLagRefreshedOn", "redoTransportMode", "automaticFailoverTarget"})
    public AutonomousContainerDatabaseDataguard(String autonomousContainerDatabaseId, Role role, LifecycleState lifecycleState, String lifecycleDetails, ProtectionMode protectionMode, Integer fastStartFailOverLagLimitInSeconds, String applyLag, String applyRate, Boolean isAutomaticFailoverEnabled, String transportLag, Date timeLastSynced, Date timeCreated, Date timeLastRoleChanged, String availabilityDomain, Date timeLagRefreshedOn, String redoTransportMode, String automaticFailoverTarget) {
        this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
        this.role = role;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.protectionMode = protectionMode;
        this.fastStartFailOverLagLimitInSeconds = fastStartFailOverLagLimitInSeconds;
        this.applyLag = applyLag;
        this.applyRate = applyRate;
        this.isAutomaticFailoverEnabled = isAutomaticFailoverEnabled;
        this.transportLag = transportLag;
        this.timeLastSynced = timeLastSynced;
        this.timeCreated = timeCreated;
        this.timeLastRoleChanged = timeLastRoleChanged;
        this.availabilityDomain = availabilityDomain;
        this.timeLagRefreshedOn = timeLagRefreshedOn;
        this.redoTransportMode = redoTransportMode;
        this.automaticFailoverTarget = automaticFailoverTarget;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAutonomousContainerDatabaseId() {
        return this.autonomousContainerDatabaseId;
    }

    public Role getRole() {
        return this.role;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public Integer getFastStartFailOverLagLimitInSeconds() {
        return this.fastStartFailOverLagLimitInSeconds;
    }

    public String getApplyLag() {
        return this.applyLag;
    }

    public String getApplyRate() {
        return this.applyRate;
    }

    public Boolean getIsAutomaticFailoverEnabled() {
        return this.isAutomaticFailoverEnabled;
    }

    public String getTransportLag() {
        return this.transportLag;
    }

    public Date getTimeLastSynced() {
        return this.timeLastSynced;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastRoleChanged() {
        return this.timeLastRoleChanged;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public Date getTimeLagRefreshedOn() {
        return this.timeLagRefreshedOn;
    }

    public String getRedoTransportMode() {
        return this.redoTransportMode;
    }

    public String getAutomaticFailoverTarget() {
        return this.automaticFailoverTarget;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousContainerDatabaseDataguard(");
        sb.append("super=").append(super.toString());
        sb.append("autonomousContainerDatabaseId=").append(String.valueOf(this.autonomousContainerDatabaseId));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", protectionMode=").append(String.valueOf((Object)this.protectionMode));
        sb.append(", fastStartFailOverLagLimitInSeconds=").append(String.valueOf(this.fastStartFailOverLagLimitInSeconds));
        sb.append(", applyLag=").append(String.valueOf(this.applyLag));
        sb.append(", applyRate=").append(String.valueOf(this.applyRate));
        sb.append(", isAutomaticFailoverEnabled=").append(String.valueOf(this.isAutomaticFailoverEnabled));
        sb.append(", transportLag=").append(String.valueOf(this.transportLag));
        sb.append(", timeLastSynced=").append(String.valueOf(this.timeLastSynced));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLastRoleChanged=").append(String.valueOf(this.timeLastRoleChanged));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", timeLagRefreshedOn=").append(String.valueOf(this.timeLagRefreshedOn));
        sb.append(", redoTransportMode=").append(String.valueOf(this.redoTransportMode));
        sb.append(", automaticFailoverTarget=").append(String.valueOf(this.automaticFailoverTarget));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousContainerDatabaseDataguard)) {
            return false;
        }
        AutonomousContainerDatabaseDataguard other = (AutonomousContainerDatabaseDataguard)((Object)o);
        return Objects.equals(this.autonomousContainerDatabaseId, other.autonomousContainerDatabaseId) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.protectionMode, (Object)other.protectionMode) && Objects.equals(this.fastStartFailOverLagLimitInSeconds, other.fastStartFailOverLagLimitInSeconds) && Objects.equals(this.applyLag, other.applyLag) && Objects.equals(this.applyRate, other.applyRate) && Objects.equals(this.isAutomaticFailoverEnabled, other.isAutomaticFailoverEnabled) && Objects.equals(this.transportLag, other.transportLag) && Objects.equals(this.timeLastSynced, other.timeLastSynced) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLastRoleChanged, other.timeLastRoleChanged) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.timeLagRefreshedOn, other.timeLagRefreshedOn) && Objects.equals(this.redoTransportMode, other.redoTransportMode) && Objects.equals(this.automaticFailoverTarget, other.automaticFailoverTarget) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.autonomousContainerDatabaseId == null ? 43 : this.autonomousContainerDatabaseId.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.protectionMode == null ? 43 : this.protectionMode.hashCode());
        result = result * 59 + (this.fastStartFailOverLagLimitInSeconds == null ? 43 : this.fastStartFailOverLagLimitInSeconds.hashCode());
        result = result * 59 + (this.applyLag == null ? 43 : this.applyLag.hashCode());
        result = result * 59 + (this.applyRate == null ? 43 : this.applyRate.hashCode());
        result = result * 59 + (this.isAutomaticFailoverEnabled == null ? 43 : this.isAutomaticFailoverEnabled.hashCode());
        result = result * 59 + (this.transportLag == null ? 43 : this.transportLag.hashCode());
        result = result * 59 + (this.timeLastSynced == null ? 43 : this.timeLastSynced.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLastRoleChanged == null ? 43 : this.timeLastRoleChanged.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.timeLagRefreshedOn == null ? 43 : this.timeLagRefreshedOn.hashCode());
        result = result * 59 + (this.redoTransportMode == null ? 43 : this.redoTransportMode.hashCode());
        result = result * 59 + (this.automaticFailoverTarget == null ? 43 : this.automaticFailoverTarget.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Role implements BmcEnum
    {
        Primary("PRIMARY"),
        Standby("STANDBY"),
        DisabledStandby("DISABLED_STANDBY"),
        BackupCopy("BACKUP_COPY"),
        SnapshotStandby("SNAPSHOT_STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        RoleChangeInProgress("ROLE_CHANGE_IN_PROGRESS"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        Unavailable("UNAVAILABLE"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProtectionMode implements BmcEnum
    {
        MaximumAvailability("MAXIMUM_AVAILABILITY"),
        MaximumPerformance("MAXIMUM_PERFORMANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ProtectionMode> map;

        private ProtectionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProtectionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ProtectionMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ProtectionMode.class);
            map = new HashMap<String, ProtectionMode>();
            for (ProtectionMode v : ProtectionMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="autonomousContainerDatabaseId")
        private String autonomousContainerDatabaseId;
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="protectionMode")
        private ProtectionMode protectionMode;
        @JsonProperty(value="fastStartFailOverLagLimitInSeconds")
        private Integer fastStartFailOverLagLimitInSeconds;
        @JsonProperty(value="applyLag")
        private String applyLag;
        @JsonProperty(value="applyRate")
        private String applyRate;
        @JsonProperty(value="isAutomaticFailoverEnabled")
        private Boolean isAutomaticFailoverEnabled;
        @JsonProperty(value="transportLag")
        private String transportLag;
        @JsonProperty(value="timeLastSynced")
        private Date timeLastSynced;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastRoleChanged")
        private Date timeLastRoleChanged;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="timeLagRefreshedOn")
        private Date timeLagRefreshedOn;
        @JsonProperty(value="redoTransportMode")
        private String redoTransportMode;
        @JsonProperty(value="automaticFailoverTarget")
        private String automaticFailoverTarget;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder autonomousContainerDatabaseId(String autonomousContainerDatabaseId) {
            this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
            this.__explicitlySet__.add("autonomousContainerDatabaseId");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder protectionMode(ProtectionMode protectionMode) {
            this.protectionMode = protectionMode;
            this.__explicitlySet__.add("protectionMode");
            return this;
        }

        public Builder fastStartFailOverLagLimitInSeconds(Integer fastStartFailOverLagLimitInSeconds) {
            this.fastStartFailOverLagLimitInSeconds = fastStartFailOverLagLimitInSeconds;
            this.__explicitlySet__.add("fastStartFailOverLagLimitInSeconds");
            return this;
        }

        public Builder applyLag(String applyLag) {
            this.applyLag = applyLag;
            this.__explicitlySet__.add("applyLag");
            return this;
        }

        public Builder applyRate(String applyRate) {
            this.applyRate = applyRate;
            this.__explicitlySet__.add("applyRate");
            return this;
        }

        public Builder isAutomaticFailoverEnabled(Boolean isAutomaticFailoverEnabled) {
            this.isAutomaticFailoverEnabled = isAutomaticFailoverEnabled;
            this.__explicitlySet__.add("isAutomaticFailoverEnabled");
            return this;
        }

        public Builder transportLag(String transportLag) {
            this.transportLag = transportLag;
            this.__explicitlySet__.add("transportLag");
            return this;
        }

        public Builder timeLastSynced(Date timeLastSynced) {
            this.timeLastSynced = timeLastSynced;
            this.__explicitlySet__.add("timeLastSynced");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastRoleChanged(Date timeLastRoleChanged) {
            this.timeLastRoleChanged = timeLastRoleChanged;
            this.__explicitlySet__.add("timeLastRoleChanged");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder timeLagRefreshedOn(Date timeLagRefreshedOn) {
            this.timeLagRefreshedOn = timeLagRefreshedOn;
            this.__explicitlySet__.add("timeLagRefreshedOn");
            return this;
        }

        public Builder redoTransportMode(String redoTransportMode) {
            this.redoTransportMode = redoTransportMode;
            this.__explicitlySet__.add("redoTransportMode");
            return this;
        }

        public Builder automaticFailoverTarget(String automaticFailoverTarget) {
            this.automaticFailoverTarget = automaticFailoverTarget;
            this.__explicitlySet__.add("automaticFailoverTarget");
            return this;
        }

        public AutonomousContainerDatabaseDataguard build() {
            AutonomousContainerDatabaseDataguard model = new AutonomousContainerDatabaseDataguard(this.autonomousContainerDatabaseId, this.role, this.lifecycleState, this.lifecycleDetails, this.protectionMode, this.fastStartFailOverLagLimitInSeconds, this.applyLag, this.applyRate, this.isAutomaticFailoverEnabled, this.transportLag, this.timeLastSynced, this.timeCreated, this.timeLastRoleChanged, this.availabilityDomain, this.timeLagRefreshedOn, this.redoTransportMode, this.automaticFailoverTarget);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousContainerDatabaseDataguard model) {
            if (model.wasPropertyExplicitlySet("autonomousContainerDatabaseId")) {
                this.autonomousContainerDatabaseId(model.getAutonomousContainerDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("protectionMode")) {
                this.protectionMode(model.getProtectionMode());
            }
            if (model.wasPropertyExplicitlySet("fastStartFailOverLagLimitInSeconds")) {
                this.fastStartFailOverLagLimitInSeconds(model.getFastStartFailOverLagLimitInSeconds());
            }
            if (model.wasPropertyExplicitlySet("applyLag")) {
                this.applyLag(model.getApplyLag());
            }
            if (model.wasPropertyExplicitlySet("applyRate")) {
                this.applyRate(model.getApplyRate());
            }
            if (model.wasPropertyExplicitlySet("isAutomaticFailoverEnabled")) {
                this.isAutomaticFailoverEnabled(model.getIsAutomaticFailoverEnabled());
            }
            if (model.wasPropertyExplicitlySet("transportLag")) {
                this.transportLag(model.getTransportLag());
            }
            if (model.wasPropertyExplicitlySet("timeLastSynced")) {
                this.timeLastSynced(model.getTimeLastSynced());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLastRoleChanged")) {
                this.timeLastRoleChanged(model.getTimeLastRoleChanged());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("timeLagRefreshedOn")) {
                this.timeLagRefreshedOn(model.getTimeLagRefreshedOn());
            }
            if (model.wasPropertyExplicitlySet("redoTransportMode")) {
                this.redoTransportMode(model.getRedoTransportMode());
            }
            if (model.wasPropertyExplicitlySet("automaticFailoverTarget")) {
                this.automaticFailoverTarget(model.getAutomaticFailoverTarget());
            }
            return this;
        }
    }
}

