/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ActionMember
extends ExplicitlySetBmcModel {
    @JsonProperty(value="memberOrder")
    private final Integer memberOrder;
    @JsonProperty(value="memberId")
    private final String memberId;
    @JsonProperty(value="estimatedTimeInMins")
    private final Integer estimatedTimeInMins;

    @Deprecated
    @ConstructorProperties(value={"memberOrder", "memberId", "estimatedTimeInMins"})
    public ActionMember(Integer memberOrder, String memberId, Integer estimatedTimeInMins) {
        this.memberOrder = memberOrder;
        this.memberId = memberId;
        this.estimatedTimeInMins = estimatedTimeInMins;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getMemberOrder() {
        return this.memberOrder;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public Integer getEstimatedTimeInMins() {
        return this.estimatedTimeInMins;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ActionMember(");
        sb.append("super=").append(super.toString());
        sb.append("memberOrder=").append(String.valueOf(this.memberOrder));
        sb.append(", memberId=").append(String.valueOf(this.memberId));
        sb.append(", estimatedTimeInMins=").append(String.valueOf(this.estimatedTimeInMins));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionMember)) {
            return false;
        }
        ActionMember other = (ActionMember)((Object)o);
        return Objects.equals(this.memberOrder, other.memberOrder) && Objects.equals(this.memberId, other.memberId) && Objects.equals(this.estimatedTimeInMins, other.estimatedTimeInMins) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.memberOrder == null ? 43 : this.memberOrder.hashCode());
        result = result * 59 + (this.memberId == null ? 43 : this.memberId.hashCode());
        result = result * 59 + (this.estimatedTimeInMins == null ? 43 : this.estimatedTimeInMins.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="memberOrder")
        private Integer memberOrder;
        @JsonProperty(value="memberId")
        private String memberId;
        @JsonProperty(value="estimatedTimeInMins")
        private Integer estimatedTimeInMins;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder memberOrder(Integer memberOrder) {
            this.memberOrder = memberOrder;
            this.__explicitlySet__.add("memberOrder");
            return this;
        }

        public Builder memberId(String memberId) {
            this.memberId = memberId;
            this.__explicitlySet__.add("memberId");
            return this;
        }

        public Builder estimatedTimeInMins(Integer estimatedTimeInMins) {
            this.estimatedTimeInMins = estimatedTimeInMins;
            this.__explicitlySet__.add("estimatedTimeInMins");
            return this;
        }

        public ActionMember build() {
            ActionMember model = new ActionMember(this.memberOrder, this.memberId, this.estimatedTimeInMins);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ActionMember model) {
            if (model.wasPropertyExplicitlySet("memberOrder")) {
                this.memberOrder(model.getMemberOrder());
            }
            if (model.wasPropertyExplicitlySet("memberId")) {
                this.memberId(model.getMemberId());
            }
            if (model.wasPropertyExplicitlySet("estimatedTimeInMins")) {
                this.estimatedTimeInMins(model.getEstimatedTimeInMins());
            }
            return this;
        }
    }
}

