/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.responses;

import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FetchProtectedDatabaseConfigurationResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private String opcFilename;
    private String opcChecksum;
    private InputStream inputStream;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcFilename() {
        return this.opcFilename;
    }

    public String getOpcChecksum() {
        return this.opcChecksum;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "opcFilename", "opcChecksum", "inputStream"})
    private FetchProtectedDatabaseConfigurationResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, String opcFilename, String opcChecksum, InputStream inputStream) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcFilename = opcFilename;
        this.opcChecksum = opcChecksum;
        this.inputStream = inputStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcFilename=").append(String.valueOf(this.opcFilename));
        sb.append(",opcChecksum=").append(String.valueOf(this.opcChecksum));
        sb.append(",inputStream=").append(String.valueOf(this.inputStream));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FetchProtectedDatabaseConfigurationResponse)) {
            return false;
        }
        FetchProtectedDatabaseConfigurationResponse other = (FetchProtectedDatabaseConfigurationResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcFilename, other.opcFilename) && Objects.equals(this.opcChecksum, other.opcChecksum) && Objects.equals(this.inputStream, other.inputStream);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcFilename == null ? 43 : this.opcFilename.hashCode());
        result = result * 59 + (this.opcChecksum == null ? 43 : this.opcChecksum.hashCode());
        result = result * 59 + (this.inputStream == null ? 43 : this.inputStream.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<FetchProtectedDatabaseConfigurationResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private String opcFilename;
        private String opcChecksum;
        private InputStream inputStream;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcFilename(String opcFilename) {
            this.opcFilename = opcFilename;
            return this;
        }

        public Builder opcChecksum(String opcChecksum) {
            this.opcChecksum = opcChecksum;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder copy(FetchProtectedDatabaseConfigurationResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcFilename(o.getOpcFilename());
            this.opcChecksum(o.getOpcChecksum());
            this.inputStream(o.getInputStream());
            return this;
        }

        public FetchProtectedDatabaseConfigurationResponse build() {
            return new FetchProtectedDatabaseConfigurationResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.opcFilename, this.opcChecksum, this.inputStream);
        }
    }
}

