/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.recovery.DatabaseRecoveryAsync;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.recovery.model.ProtectedDatabaseCollection;
import com.oracle.bmc.recovery.model.ProtectionPolicy;
import com.oracle.bmc.recovery.model.ProtectionPolicyCollection;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnet;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetCollection;
import com.oracle.bmc.recovery.model.WorkRequest;
import com.oracle.bmc.recovery.model.WorkRequestErrorCollection;
import com.oracle.bmc.recovery.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.recovery.model.WorkRequestSummaryCollection;
import com.oracle.bmc.recovery.requests.CancelProtectedDatabaseDeletionRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectedDatabaseCompartmentRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectedDatabaseSubscriptionRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectionPolicyCompartmentRequest;
import com.oracle.bmc.recovery.requests.ChangeRecoveryServiceSubnetCompartmentRequest;
import com.oracle.bmc.recovery.requests.CreateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.CreateProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.CreateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.DeleteProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.DeleteProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.DeleteRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.FetchProtectedDatabaseConfigurationRequest;
import com.oracle.bmc.recovery.requests.GetProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.GetProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.GetRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.GetWorkRequestRequest;
import com.oracle.bmc.recovery.requests.ListProtectedDatabasesRequest;
import com.oracle.bmc.recovery.requests.ListProtectionPoliciesRequest;
import com.oracle.bmc.recovery.requests.ListRecoveryServiceSubnetsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestsRequest;
import com.oracle.bmc.recovery.requests.ScheduleProtectedDatabaseDeletionRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.UpdateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.responses.CancelProtectedDatabaseDeletionResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectedDatabaseCompartmentResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectedDatabaseSubscriptionResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectionPolicyCompartmentResponse;
import com.oracle.bmc.recovery.responses.ChangeRecoveryServiceSubnetCompartmentResponse;
import com.oracle.bmc.recovery.responses.CreateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.CreateProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.CreateRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.DeleteProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.DeleteProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.DeleteRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.FetchProtectedDatabaseConfigurationResponse;
import com.oracle.bmc.recovery.responses.GetProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.GetProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.GetRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.GetWorkRequestResponse;
import com.oracle.bmc.recovery.responses.ListProtectedDatabasesResponse;
import com.oracle.bmc.recovery.responses.ListProtectionPoliciesResponse;
import com.oracle.bmc.recovery.responses.ListRecoveryServiceSubnetsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestsResponse;
import com.oracle.bmc.recovery.responses.ScheduleProtectedDatabaseDeletionResponse;
import com.oracle.bmc.recovery.responses.UpdateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.UpdateProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.UpdateRecoveryServiceSubnetResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRecoveryAsyncClient
extends BaseAsyncClient
implements DatabaseRecoveryAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATABASERECOVERY").serviceEndpointPrefix("").serviceEndpointTemplate("https://recovery.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseRecoveryAsyncClient.class);

    DatabaseRecoveryAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    DatabaseRecoveryAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"DatabaseRecoveryAsyncClient", (String)"fetchProtectedDatabaseConfiguration"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelProtectedDatabaseDeletionResponse> cancelProtectedDatabaseDeletion(CancelProtectedDatabaseDeletionRequest request, AsyncHandler<CancelProtectedDatabaseDeletionRequest, CancelProtectedDatabaseDeletionResponse> handler) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelProtectedDatabaseDeletionResponse::builder).logger(LOG, "cancelProtectedDatabaseDeletion").serviceDetails("DatabaseRecovery", "CancelProtectedDatabaseDeletion", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/CancelProtectedDatabaseDeletion").method(Method.POST).requestBuilder(CancelProtectedDatabaseDeletionRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelProtectedDatabaseDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeProtectedDatabaseCompartmentResponse> changeProtectedDatabaseCompartment(ChangeProtectedDatabaseCompartmentRequest request, AsyncHandler<ChangeProtectedDatabaseCompartmentRequest, ChangeProtectedDatabaseCompartmentResponse> handler) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProtectedDatabaseCompartmentDetails(), "changeProtectedDatabaseCompartmentDetails is required");
        return this.clientCall(request, ChangeProtectedDatabaseCompartmentResponse::builder).logger(LOG, "changeProtectedDatabaseCompartment").serviceDetails("DatabaseRecovery", "ChangeProtectedDatabaseCompartment", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/ChangeProtectedDatabaseCompartment").method(Method.POST).requestBuilder(ChangeProtectedDatabaseCompartmentRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeProtectedDatabaseCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeProtectedDatabaseCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeProtectedDatabaseSubscriptionResponse> changeProtectedDatabaseSubscription(ChangeProtectedDatabaseSubscriptionRequest request, AsyncHandler<ChangeProtectedDatabaseSubscriptionRequest, ChangeProtectedDatabaseSubscriptionResponse> handler) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProtectedDatabaseSubscriptionDetails(), "changeProtectedDatabaseSubscriptionDetails is required");
        return this.clientCall(request, ChangeProtectedDatabaseSubscriptionResponse::builder).logger(LOG, "changeProtectedDatabaseSubscription").serviceDetails("DatabaseRecovery", "ChangeProtectedDatabaseSubscription", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/ChangeProtectedDatabaseSubscription").method(Method.POST).requestBuilder(ChangeProtectedDatabaseSubscriptionRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("changeSubscription").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeProtectedDatabaseSubscriptionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeProtectedDatabaseSubscriptionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeProtectionPolicyCompartmentResponse> changeProtectionPolicyCompartment(ChangeProtectionPolicyCompartmentRequest request, AsyncHandler<ChangeProtectionPolicyCompartmentRequest, ChangeProtectionPolicyCompartmentResponse> handler) {
        Validate.notBlank((String)request.getProtectionPolicyId(), (String)"protectionPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProtectionPolicyCompartmentDetails(), "changeProtectionPolicyCompartmentDetails is required");
        return this.clientCall(request, ChangeProtectionPolicyCompartmentResponse::builder).logger(LOG, "changeProtectionPolicyCompartment").serviceDetails("DatabaseRecovery", "ChangeProtectionPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/ChangeProtectionPolicyCompartment").method(Method.POST).requestBuilder(ChangeProtectionPolicyCompartmentRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendPathParam(request.getProtectionPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeProtectionPolicyCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeProtectionPolicyCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeRecoveryServiceSubnetCompartmentResponse> changeRecoveryServiceSubnetCompartment(ChangeRecoveryServiceSubnetCompartmentRequest request, AsyncHandler<ChangeRecoveryServiceSubnetCompartmentRequest, ChangeRecoveryServiceSubnetCompartmentResponse> handler) {
        Validate.notBlank((String)request.getRecoveryServiceSubnetId(), (String)"recoveryServiceSubnetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRecoveryServiceSubnetCompartmentDetails(), "changeRecoveryServiceSubnetCompartmentDetails is required");
        return this.clientCall(request, ChangeRecoveryServiceSubnetCompartmentResponse::builder).logger(LOG, "changeRecoveryServiceSubnetCompartment").serviceDetails("DatabaseRecovery", "ChangeRecoveryServiceSubnetCompartment", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/ChangeRecoveryServiceSubnetCompartment").method(Method.POST).requestBuilder(ChangeRecoveryServiceSubnetCompartmentRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendPathParam(request.getRecoveryServiceSubnetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeRecoveryServiceSubnetCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeRecoveryServiceSubnetCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateProtectedDatabaseResponse> createProtectedDatabase(CreateProtectedDatabaseRequest request, AsyncHandler<CreateProtectedDatabaseRequest, CreateProtectedDatabaseResponse> handler) {
        Objects.requireNonNull(request.getCreateProtectedDatabaseDetails(), "createProtectedDatabaseDetails is required");
        return this.clientCall(request, CreateProtectedDatabaseResponse::builder).logger(LOG, "createProtectedDatabase").serviceDetails("DatabaseRecovery", "CreateProtectedDatabase", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/CreateProtectedDatabase").method(Method.POST).requestBuilder(CreateProtectedDatabaseRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-dry-run", request.getOpcDryRun()).hasBody().handleBody(ProtectedDatabase.class, CreateProtectedDatabaseResponse.Builder::protectedDatabase).handleResponseHeaderString("location", CreateProtectedDatabaseResponse.Builder::location).handleResponseHeaderString("etag", CreateProtectedDatabaseResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProtectedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProtectedDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateProtectionPolicyResponse> createProtectionPolicy(CreateProtectionPolicyRequest request, AsyncHandler<CreateProtectionPolicyRequest, CreateProtectionPolicyResponse> handler) {
        Objects.requireNonNull(request.getCreateProtectionPolicyDetails(), "createProtectionPolicyDetails is required");
        return this.clientCall(request, CreateProtectionPolicyResponse::builder).logger(LOG, "createProtectionPolicy").serviceDetails("DatabaseRecovery", "CreateProtectionPolicy", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/CreateProtectionPolicy").method(Method.POST).requestBuilder(CreateProtectionPolicyRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ProtectionPolicy.class, CreateProtectionPolicyResponse.Builder::protectionPolicy).handleResponseHeaderString("location", CreateProtectionPolicyResponse.Builder::location).handleResponseHeaderString("etag", CreateProtectionPolicyResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProtectionPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProtectionPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRecoveryServiceSubnetResponse> createRecoveryServiceSubnet(CreateRecoveryServiceSubnetRequest request, AsyncHandler<CreateRecoveryServiceSubnetRequest, CreateRecoveryServiceSubnetResponse> handler) {
        Objects.requireNonNull(request.getCreateRecoveryServiceSubnetDetails(), "createRecoveryServiceSubnetDetails is required");
        return this.clientCall(request, CreateRecoveryServiceSubnetResponse::builder).logger(LOG, "createRecoveryServiceSubnet").serviceDetails("DatabaseRecovery", "CreateRecoveryServiceSubnet", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/CreateRecoveryServiceSubnet").method(Method.POST).requestBuilder(CreateRecoveryServiceSubnetRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RecoveryServiceSubnet.class, CreateRecoveryServiceSubnetResponse.Builder::recoveryServiceSubnet).handleResponseHeaderString("location", CreateRecoveryServiceSubnetResponse.Builder::location).handleResponseHeaderString("etag", CreateRecoveryServiceSubnetResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateRecoveryServiceSubnetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRecoveryServiceSubnetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteProtectedDatabaseResponse> deleteProtectedDatabase(DeleteProtectedDatabaseRequest request, AsyncHandler<DeleteProtectedDatabaseRequest, DeleteProtectedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteProtectedDatabaseResponse::builder).logger(LOG, "deleteProtectedDatabase").serviceDetails("DatabaseRecovery", "DeleteProtectedDatabase", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/DeleteProtectedDatabase").method(Method.DELETE).requestBuilder(DeleteProtectedDatabaseRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendEnumQueryParam("deletionSchedule", (BmcEnum)request.getDeletionSchedule()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProtectedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProtectedDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteProtectionPolicyResponse> deleteProtectionPolicy(DeleteProtectionPolicyRequest request, AsyncHandler<DeleteProtectionPolicyRequest, DeleteProtectionPolicyResponse> handler) {
        Validate.notBlank((String)request.getProtectionPolicyId(), (String)"protectionPolicyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteProtectionPolicyResponse::builder).logger(LOG, "deleteProtectionPolicy").serviceDetails("DatabaseRecovery", "DeleteProtectionPolicy", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/DeleteProtectionPolicy").method(Method.DELETE).requestBuilder(DeleteProtectionPolicyRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendPathParam(request.getProtectionPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProtectionPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProtectionPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRecoveryServiceSubnetResponse> deleteRecoveryServiceSubnet(DeleteRecoveryServiceSubnetRequest request, AsyncHandler<DeleteRecoveryServiceSubnetRequest, DeleteRecoveryServiceSubnetResponse> handler) {
        Validate.notBlank((String)request.getRecoveryServiceSubnetId(), (String)"recoveryServiceSubnetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRecoveryServiceSubnetResponse::builder).logger(LOG, "deleteRecoveryServiceSubnet").serviceDetails("DatabaseRecovery", "DeleteRecoveryServiceSubnet", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/DeleteRecoveryServiceSubnet").method(Method.DELETE).requestBuilder(DeleteRecoveryServiceSubnetRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendPathParam(request.getRecoveryServiceSubnetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteRecoveryServiceSubnetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRecoveryServiceSubnetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<FetchProtectedDatabaseConfigurationResponse> fetchProtectedDatabaseConfiguration(FetchProtectedDatabaseConfigurationRequest request, AsyncHandler<FetchProtectedDatabaseConfigurationRequest, FetchProtectedDatabaseConfigurationResponse> handler) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, FetchProtectedDatabaseConfigurationResponse::builder).logger(LOG, "fetchProtectedDatabaseConfiguration").serviceDetails("DatabaseRecovery", "FetchProtectedDatabaseConfiguration", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/FetchProtectedDatabaseConfiguration").method(Method.POST).requestBuilder(FetchProtectedDatabaseConfigurationRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("getConfiguration").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(InputStream.class, FetchProtectedDatabaseConfigurationResponse.Builder::inputStream).handleResponseHeaderString("etag", FetchProtectedDatabaseConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", FetchProtectedDatabaseConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-filename", FetchProtectedDatabaseConfigurationResponse.Builder::opcFilename).handleResponseHeaderString("opc-checksum", FetchProtectedDatabaseConfigurationResponse.Builder::opcChecksum).callAsync(handler);
    }

    @Override
    public Future<GetProtectedDatabaseResponse> getProtectedDatabase(GetProtectedDatabaseRequest request, AsyncHandler<GetProtectedDatabaseRequest, GetProtectedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProtectedDatabaseResponse::builder).logger(LOG, "getProtectedDatabase").serviceDetails("DatabaseRecovery", "GetProtectedDatabase", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/GetProtectedDatabase").method(Method.GET).requestBuilder(GetProtectedDatabaseRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProtectedDatabase.class, GetProtectedDatabaseResponse.Builder::protectedDatabase).handleResponseHeaderString("etag", GetProtectedDatabaseResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProtectedDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetProtectionPolicyResponse> getProtectionPolicy(GetProtectionPolicyRequest request, AsyncHandler<GetProtectionPolicyRequest, GetProtectionPolicyResponse> handler) {
        Validate.notBlank((String)request.getProtectionPolicyId(), (String)"protectionPolicyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProtectionPolicyResponse::builder).logger(LOG, "getProtectionPolicy").serviceDetails("DatabaseRecovery", "GetProtectionPolicy", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/GetProtectionPolicy").method(Method.GET).requestBuilder(GetProtectionPolicyRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendPathParam(request.getProtectionPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProtectionPolicy.class, GetProtectionPolicyResponse.Builder::protectionPolicy).handleResponseHeaderString("etag", GetProtectionPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProtectionPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRecoveryServiceSubnetResponse> getRecoveryServiceSubnet(GetRecoveryServiceSubnetRequest request, AsyncHandler<GetRecoveryServiceSubnetRequest, GetRecoveryServiceSubnetResponse> handler) {
        Validate.notBlank((String)request.getRecoveryServiceSubnetId(), (String)"recoveryServiceSubnetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRecoveryServiceSubnetResponse::builder).logger(LOG, "getRecoveryServiceSubnet").serviceDetails("DatabaseRecovery", "GetRecoveryServiceSubnet", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/GetRecoveryServiceSubnet").method(Method.GET).requestBuilder(GetRecoveryServiceSubnetRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendPathParam(request.getRecoveryServiceSubnetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecoveryServiceSubnet.class, GetRecoveryServiceSubnetResponse.Builder::recoveryServiceSubnet).handleResponseHeaderString("etag", GetRecoveryServiceSubnetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRecoveryServiceSubnetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DatabaseRecovery", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210216").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListProtectedDatabasesResponse> listProtectedDatabases(ListProtectedDatabasesRequest request, AsyncHandler<ListProtectedDatabasesRequest, ListProtectedDatabasesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListProtectedDatabasesResponse::builder).logger(LOG, "listProtectedDatabases").serviceDetails("DatabaseRecovery", "ListProtectedDatabases", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabaseCollection/ListProtectedDatabases").method(Method.GET).requestBuilder(ListProtectedDatabasesRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("protectionPolicyId", (Object)request.getProtectionPolicyId()).appendQueryParam("recoveryServiceSubnetId", (Object)request.getRecoveryServiceSubnetId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProtectedDatabaseCollection.class, ListProtectedDatabasesResponse.Builder::protectedDatabaseCollection).handleResponseHeaderString("opc-request-id", ListProtectedDatabasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProtectedDatabasesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProtectionPoliciesResponse> listProtectionPolicies(ListProtectionPoliciesRequest request, AsyncHandler<ListProtectionPoliciesRequest, ListProtectionPoliciesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListProtectionPoliciesResponse::builder).logger(LOG, "listProtectionPolicies").serviceDetails("DatabaseRecovery", "ListProtectionPolicies", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicyCollection/ListProtectionPolicies").method(Method.GET).requestBuilder(ListProtectionPoliciesRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("protectionPolicyId", (Object)request.getProtectionPolicyId()).appendEnumQueryParam("owner", (BmcEnum)request.getOwner()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProtectionPolicyCollection.class, ListProtectionPoliciesResponse.Builder::protectionPolicyCollection).handleResponseHeaderString("opc-request-id", ListProtectionPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProtectionPoliciesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRecoveryServiceSubnetsResponse> listRecoveryServiceSubnets(ListRecoveryServiceSubnetsRequest request, AsyncHandler<ListRecoveryServiceSubnetsRequest, ListRecoveryServiceSubnetsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListRecoveryServiceSubnetsResponse::builder).logger(LOG, "listRecoveryServiceSubnets").serviceDetails("DatabaseRecovery", "ListRecoveryServiceSubnets", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnetCollection/ListRecoveryServiceSubnets").method(Method.GET).requestBuilder(ListRecoveryServiceSubnetsRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecoveryServiceSubnetCollection.class, ListRecoveryServiceSubnetsResponse.Builder::recoveryServiceSubnetCollection).handleResponseHeaderString("opc-request-id", ListRecoveryServiceSubnetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRecoveryServiceSubnetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DatabaseRecovery", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210216").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DatabaseRecovery", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210216").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DatabaseRecovery", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/WorkRequestSummaryCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210216").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ScheduleProtectedDatabaseDeletionResponse> scheduleProtectedDatabaseDeletion(ScheduleProtectedDatabaseDeletionRequest request, AsyncHandler<ScheduleProtectedDatabaseDeletionRequest, ScheduleProtectedDatabaseDeletionResponse> handler) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ScheduleProtectedDatabaseDeletionResponse::builder).logger(LOG, "scheduleProtectedDatabaseDeletion").serviceDetails("DatabaseRecovery", "ScheduleProtectedDatabaseDeletion", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/ScheduleProtectedDatabaseDeletion").method(Method.POST).requestBuilder(ScheduleProtectedDatabaseDeletionRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ScheduleProtectedDatabaseDeletionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ScheduleProtectedDatabaseDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateProtectedDatabaseResponse> updateProtectedDatabase(UpdateProtectedDatabaseRequest request, AsyncHandler<UpdateProtectedDatabaseRequest, UpdateProtectedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProtectedDatabaseDetails(), "updateProtectedDatabaseDetails is required");
        return this.clientCall(request, UpdateProtectedDatabaseResponse::builder).logger(LOG, "updateProtectedDatabase").serviceDetails("DatabaseRecovery", "UpdateProtectedDatabase", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/UpdateProtectedDatabase").method(Method.PUT).requestBuilder(UpdateProtectedDatabaseRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateProtectedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProtectedDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateProtectionPolicyResponse> updateProtectionPolicy(UpdateProtectionPolicyRequest request, AsyncHandler<UpdateProtectionPolicyRequest, UpdateProtectionPolicyResponse> handler) {
        Validate.notBlank((String)request.getProtectionPolicyId(), (String)"protectionPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProtectionPolicyDetails(), "updateProtectionPolicyDetails is required");
        return this.clientCall(request, UpdateProtectionPolicyResponse::builder).logger(LOG, "updateProtectionPolicy").serviceDetails("DatabaseRecovery", "UpdateProtectionPolicy", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/UpdateProtectionPolicy").method(Method.PUT).requestBuilder(UpdateProtectionPolicyRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendPathParam(request.getProtectionPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateProtectionPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProtectionPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRecoveryServiceSubnetResponse> updateRecoveryServiceSubnet(UpdateRecoveryServiceSubnetRequest request, AsyncHandler<UpdateRecoveryServiceSubnetRequest, UpdateRecoveryServiceSubnetResponse> handler) {
        Validate.notBlank((String)request.getRecoveryServiceSubnetId(), (String)"recoveryServiceSubnetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRecoveryServiceSubnetDetails(), "updateRecoveryServiceSubnetDetails is required");
        return this.clientCall(request, UpdateRecoveryServiceSubnetResponse::builder).logger(LOG, "updateRecoveryServiceSubnet").serviceDetails("DatabaseRecovery", "UpdateRecoveryServiceSubnet", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/UpdateRecoveryServiceSubnet").method(Method.PUT).requestBuilder(UpdateRecoveryServiceSubnetRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendPathParam(request.getRecoveryServiceSubnetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateRecoveryServiceSubnetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRecoveryServiceSubnetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DatabaseRecoveryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DatabaseRecoveryAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseRecoveryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DatabaseRecoveryAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseRecoveryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DatabaseRecoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseRecoveryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DatabaseRecoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseRecoveryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DatabaseRecoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseRecoveryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DatabaseRecoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseRecoveryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DatabaseRecoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DatabaseRecoveryAsyncClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "recovery";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"recovery");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public DatabaseRecoveryAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DatabaseRecoveryAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

