/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.modeler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.LogicalDataTypesReader;
import oracle.dbtools.crest.swingui.ddl.DDLConfig;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.modeler.Messages;

public abstract class AbstractModelerGenerator {
    public static final String ARG_DESIGN = "-DESIGN";
    public static final String ARG_DESIGN_SHORT = "-D";
    public static final String ARG_REL_MODEL = "-RELMODEL";
    public static final String ARG_REL_MODEL_SHORT = "-RM";
    public static final String ARG_OUTPUT_FILE = "-OUTPUTFILE";
    public static final String ARG_OUTPUT_FILE_SHORT = "-O";
    public static final String ARG_TYPE = "-TYPE";
    public static final String ARG_TYPE_SHORT = "-TP";
    public static final String ARG_TITLE = "-TITLE";
    public static final String ARG_TITLE_SHORT = "-TT";
    public static final String ARG_FILE_NAME = "-FILENAME";
    public static final String ARG_FILE_NAME_SHORT = "-F";
    public static final String ARG_OUTPUT_PATH = "-OUTPUTPATH";
    public static final String ARG_OUTPUT_PATH_SHORT = "-O";
    public static final String ARG_STANDARD_TEMPLATE = "-STANDARDTEMPLATE";
    public static final String ARG_STANDARD_TEMPLATE_SHORT = "-ST";
    public static final String ARG_CUSTOM_TEMPLATE = "-CUSTOMTEMPLATE";
    public static final String ARG_CUSTOM_TEMPLATE_SHORT = "-CT";
    public static final String ARG_REPORT_CONF_TEMPLATE = "-REPORTCONFTEMPLATE";
    public static final String ARG_REPORT_CONF_TEMPLATE_SHORT = "-C";
    public static final String ARG_COMPANY_NAME = "-COMPANYNAME";
    public static final String ARG_COMPANY_NAME_SHORT = "-CN";
    public static final String ARG_SYSTEM_TYPES_DIR = "-SYSTEMTYPESDIR";
    public static final String ARG_SYSTEM_TYPES_DIR_SHORT = "-TD";
    public static final String ARG_SETTINGS_FILE = "-SETTINGSFILE";
    public static final String ARG_SETTINGS_FILE_SHORT = "-S";
    public static final String ARG_DDL_CONFIG_FILE = "-DDLCONFIGFILE";
    public static final String ARG_DDL_CONFIG_FILE_SHORT = "-C";
    public static final String ARG_DDL_DATABASE_SITE = "-DBSITE";
    public static final String AARG_DDL_DATABASE_SITE_SHORT = "-DS";
    public static final String REPORT_TYPE_TABLES = "Tables";
    public static final String REPORT_TYPE_TABLE_VIEWS = "TableViews";
    public static final String REPORT_TYPE_TABLES_AND_VIEWS = "TablesAndViews";
    public static final String REPORT_TYPE_ENTITIES = "Entities";
    public static final String REPORT_TYPE_ENTITY_VIEWS = "EntityViews";
    public static final String REPORT_TYPE_ENTITIES_AND_VIEWS = "EntitiesAndViews";
    public static final String REPORT_TYPE_DOMAINS = "Domains";
    protected ScriptRunnerContext ctx;
    protected String designFileName;
    protected String relModelName;
    protected String systemTypesDir;
    protected String settingsFileName;

    public AbstractModelerGenerator(ScriptRunnerContext ctx, Map<String, String> arguments) {
        this.ctx = ctx;
        this.designFileName = arguments.get(ARG_DESIGN);
        this.relModelName = arguments.get(ARG_REL_MODEL);
        this.systemTypesDir = arguments.get(ARG_SYSTEM_TYPES_DIR);
        this.settingsFileName = arguments.get(ARG_SETTINGS_FILE);
    }

    protected Design openDesign(String designFileName, String relModelName, boolean loadRelModels) throws IOException {
        return this.openDesign(designFileName, relModelName, loadRelModels, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Design openDesign(String designFileName, String relModelName, boolean loadRelModels, String siteName) throws IOException {
        Iterator it;
        Design design = null;
        File designFile = new File(designFileName);
        if (designFile != null && designFile.exists()) {
            String designPath = designFile.getParent();
            String fileName = designFile.getName();
            int pos = fileName.lastIndexOf(".");
            if (pos <= -1) {
                this.ctx.write(Messages.getString("DESIGN_NOT_EXISTS"));
                return null;
            }
            String designName = fileName.substring(0, pos);
            String ext = fileName.substring(pos);
            if (this.systemTypesDir != null) {
                Design.systemTypesDir = this.systemTypesDir;
            }
            if (this.settingsFileName != null) {
                Design.settingsFileName = this.settingsFileName;
            }
            design = new Design();
            design.setDmDesktopDesign(true);
            design.setLoading(true);
            design.setTempVar(true);
            design.getDomainSet().setDesignPart((DesignPart)design.getLogicalDesign());
            LogicalDataTypesReader lr = new LogicalDataTypesReader();
            lr.recreateLogicalTypes(design);
            design.setFileName(designName);
            design.setDesignPath(designPath);
            design.setCompressedDesign(".dmdz".equalsIgnoreCase(ext));
            XMLTransformationManager.getInstance().openDesign(design, new File(design.getDesignPath(), designName + ext));
            design.loadDefaultDomains();
            XMLTransformationManager.getInstance().loadDomains(design);
            XMLTransformationManager.getInstance().openDesignPart((DesignPart)design.getDataTypesDesign());
            DDLConfig.restoreDDLSelection((DesignPart)design.getDataTypesDesign());
            XMLTransformationManager.getInstance().openDesignPart((DesignPart)design.getLogicalDesign());
            it = design.getRelationalDesigns().iterator();
        } else {
            this.ctx.write(Messages.getString("DESIGN_NOT_EXISTS"));
            return null;
        }
        while (it.hasNext()) {
            RelationalDesign relModel = (RelationalDesign)it.next();
            if (relModelName != null && loadRelModels && relModel.getName().equalsIgnoreCase(relModelName)) {
                XMLTransformationManager.getInstance().openDesignPart((DesignPart)relModel);
                DDLConfig.restoreDDLSelection((DesignPart)relModel);
                RDBMSSite site = null;
                String sName = siteName;
                if (siteName != null && !siteName.isEmpty()) {
                    try {
                        site = design.getRDBMSSiteSet().getByName(siteName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (site == null) {
                    site = relModel.getSelectedRDBMSSite();
                } else {
                    relModel.setSelectedRDBMSSite(site);
                }
                StorageDesign storageDesign = relModel.getStorageDesign(site);
                File file = new File(storageDesign.getStorageName());
                if (file.exists()) {
                    XMLTransformationManager.getInstance().openPhysicalModel(storageDesign);
                    storageDesign.setOpen(true);
                }
                this.setColumnsNativeType(relModel, storageDesign);
                break;
            }
            if (!loadRelModels) continue;
            XMLTransformationManager.getInstance().openDesignPart((DesignPart)relModel);
        }
        design.setLoading(false);
        return design;
    }

    protected RelationalDesign loadRelationalModel(String designFileName, String relModelName) throws IOException {
        return this.loadRelationalModel(designFileName, relModelName, null);
    }

    protected RelationalDesign loadRelationalModel(String designFileName, String relModelName, String siteName) throws IOException {
        RelationalDesign relModel = null;
        Design design = this.openDesign(designFileName, relModelName, true, siteName);
        if (design != null) {
            for (RelationalDesign rd : design.getRelationalDesigns()) {
                if (!rd.getName().equalsIgnoreCase(relModelName)) continue;
                relModel = rd;
                break;
            }
        }
        return relModel;
    }

    protected boolean saveLocalCopy(String fileName, String content) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        } else {
            file.delete();
            file.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        osw.write(content);
        osw.close();
        return true;
    }

    private void setColumnsNativeType(RelationalDesign relModel, StorageDesign storageDesign) {
        for (Table table : relModel.getTableSet()) {
            for (Column column : table.getColumnSet()) {
                if (column.getUse() != 1) continue;
                String nativeType = column.getDatatypeString(storageDesign.getRDBMSType().getName());
                column.setNativeDataType(nativeType);
            }
        }
    }
}

