/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.versions;

import java.time.LocalDateTime;
import java.util.function.Supplier;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.versions.FallbackVersion;
import oracle.dbtools.versions.Versions;

public final class SQLclVersion {
    private static final FallbackVersion FALLBACK_VERSION = FallbackVersion.of(LocalDateTime.now());
    private static final String PLACEHOLDER_PREFIX = "${";

    private static boolean hasPlaceHolder(String value) {
        return value.startsWith(PLACEHOLDER_PREFIX);
    }

    private static String get(String key, Supplier<String> fallback) {
        String text = Versions.getString(key);
        if (SQLclVersion.hasPlaceHolder(text)) {
            return fallback.get();
        }
        return text;
    }

    public static String getSQLclVersion() {
        return SQLclVersion.get("SQLclVersion.VERSION", FALLBACK_VERSION::version);
    }

    public static Version getSQLclOracleVersion() {
        return new Version(SQLclVersion.getSQLclVersion());
    }

    public static String getSQLclShortVersion() {
        return SQLclVersion.get("SQLclVersion.SHORT_VERSION", FALLBACK_VERSION::shortVersion);
    }

    public static String getSQLclState() {
        return Versions.getString("SQLclVersion.STATE");
    }

    public static Version getFullVersion() {
        return new Version(SQLclVersion.getSQLclVersion());
    }

    public static String getSQLclBuildVersion() {
        return SQLclVersion.get("SQLclVersion.BUILD_VERSION", FALLBACK_VERSION::buildVersion);
    }
}

