/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.editor;

import java.io.StringReader;
import java.sql.Connection;
import java.util.function.Function;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.console.HighlighterService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.SqlParserProvider;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.scriptrunner.commands.editor.Messages;

public class ListCommand
extends CommandListener
implements IHelp {
    private static final String LIST = "LIST";
    private static final String CMD = "list|lis|li|l";
    private static final String STAR = "*";
    private static final String LAST = "last";

    private boolean isAnInteger(String listOption) {
        try {
            Integer.parseInt(listOption);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return LIST;
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString(LIST);
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
            HighlighterService highlighterService = consoleService.getHighlighterService();
            Function<String, String> highlighter = text -> highlighterService.highlightText((String)text);
            String sqlpcmd = cmd.getSql().trim().toLowerCase();
            String[] cmds = sqlpcmd.split("\\s+");
            if (cmds.length >= 1 && cmds[0].matches(CMD)) {
                boolean trim = false;
                if (ctx.getSQLPlusBuffer() != null) {
                    IBuffer buffer = ctx.getSQLPlusBuffer().getBufferSafe();
                    if (SqlParserProvider.getScriptParserIterator(ctx, new StringReader(buffer.getBufferString())).hasNext() && SqlParserProvider.getScriptParserIterator(ctx, new StringReader(buffer.getBufferString())).next().getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL)) {
                        trim = true;
                    }
                    if (cmds.length == 1) {
                        if (this.isSqlPlus()) {
                            ctx.write(buffer.list(highlighter));
                        } else {
                            ctx.write(buffer.list(trim, highlighter));
                        }
                    } else if (cmds.length == 2) {
                        String listOption = cmds[1];
                        int x = 0;
                        if (listOption.equals(STAR)) {
                            ctx.write(buffer.listStar(trim, highlighter));
                        } else if (listOption.equals(LAST)) {
                            ctx.write(buffer.listLast(trim, highlighter));
                        } else {
                            try {
                                x = Integer.parseInt(listOption);
                                ctx.write(buffer.list(x, trim, highlighter));
                            }
                            catch (NumberFormatException e) {
                                ctx.write(this.getHelp());
                            }
                        }
                    } else if (cmds.length >= 3) {
                        String listOption1 = cmds[1];
                        String listOption2 = cmds[2];
                        if (listOption1.equals(LAST) || listOption2.equals(LAST)) {
                            int last = buffer.getCurrentLine();
                            if (this.isAnInteger(listOption2) && last > Integer.parseInt(listOption2)) {
                                ctx.write(Messages.getString("ListCommand.0"));
                            } else if (this.isAnInteger(listOption1) && listOption2.equals(LAST)) {
                                ctx.write(buffer.list(Integer.parseInt(listOption1), last, trim, highlighter));
                            } else if (listOption1.equals(STAR) && listOption2.equals(LAST)) {
                                ctx.write(buffer.listStarN(buffer.linesInBuffer(), trim, highlighter));
                            } else {
                                ctx.write(buffer.listLast(trim, highlighter));
                            }
                        } else if (listOption1.equals(STAR) || listOption2.equals(STAR)) {
                            if (listOption1.equals(STAR)) {
                                if (this.isAnInteger(listOption2)) {
                                    int b = Integer.parseInt(listOption2);
                                    if (b < buffer.getCurrentLine()) {
                                        ctx.write(Messages.getString("ListCommand.0"));
                                    } else {
                                        ctx.write(buffer.listStarN(Integer.parseInt(listOption2), trim, highlighter));
                                    }
                                } else if (listOption2.equals(STAR)) {
                                    ctx.write(buffer.listLast(trim, highlighter));
                                } else if (listOption2.toLowerCase().startsWith("l")) {
                                    ctx.write(buffer.listStarN(buffer.linesInBuffer(), trim, highlighter));
                                }
                            } else if (listOption2.equals(STAR)) {
                                if (this.isAnInteger(listOption1)) {
                                    ctx.write(buffer.listNStar(Integer.parseInt(listOption1), trim, highlighter));
                                } else if (listOption1.equals(STAR)) {
                                    ctx.write(buffer.listLast(trim, highlighter));
                                }
                            }
                        } else if (this.isAnInteger(listOption1)) {
                            if (this.isAnInteger(listOption2)) {
                                ctx.write(buffer.list(Integer.parseInt(listOption1), Integer.parseInt(listOption2), trim, highlighter));
                            } else if (listOption2.toLowerCase().startsWith("l")) {
                                ctx.write(buffer.list(Integer.parseInt(listOption1), buffer.size(), trim, highlighter));
                            } else {
                                ctx.write(Messages.getString("ListCommand.1"));
                            }
                        }
                    } else {
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Lists one or more lines of the most recently executed SQL command or PL/SQL block which is stored in the SQL buffer";
    }
}

