/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.dbtools.raptor.scriptrunner.commands.Startup;
import oracle.dbtools.util.Logger;
import oracle.jdbc.OracleConnection;

public class Shutdown
extends CommandListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() != null && ctx.getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            ctx.write("Not supported for nucleo connection\n");
            return true;
        }
        boolean nonPlugSuccess = false;
        boolean pluggableAltered = false;
        try {
            String errorString;
            boolean tryNonPluggable;
            block50: {
                boolean wasAlterDatabase = false;
                tryNonPluggable = true;
                errorString = null;
                if (conn instanceof OracleConnection) {
                    OracleConnection ocon = (OracleConnection)conn;
                    boolean sysdba = false;
                    if (ocon != null) {
                        boolean amILocked = LockManager.lock((Connection)ocon);
                        try {
                            if (!amILocked) break block50;
                            Object querySql = null;
                            String sysOperConName = Startup.returnConNameIfPublic((Connection)ocon);
                            DBUtil dbUtil = DBUtil.getInstance((Connection)ocon);
                            String s = ocon.getProperties().getProperty("internal_logon");
                            if (sysOperConName != null || s != null && (s.toLowerCase().equals("sysdba") || s.toLowerCase().equals("sysoper") || s.toLowerCase().equals("sysasm"))) {
                                sysdba = true;
                            } else {
                                errorString = Messages.getString("Shutdown.NOTSYSDBA");
                                tryNonPluggable = false;
                            }
                            if (sysOperConName == null && (!sysdba || VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier((Connection)ocon)).compareTo(new Version("12.1")) < 0)) break block50;
                            boolean immediate = false;
                            boolean abort = false;
                            if (sysOperConName == null && dbUtil.executeOracleReturnOneCol("select NVL(SYS_CONTEXT('USERENV','CDB_NAME'),'1') from dual", null).equals("1")) {
                                errorString = Messages.getString("Shutdown.NOTCONSOLIDATED");
                                break block50;
                            }
                            if (sysOperConName == null && dbUtil.executeOracleReturnOneCol("select to_char(SYS_CONTEXT('USERENV','CON_ID')) from dual", null).equals("1")) {
                                errorString = Messages.getString("Shutdown.CONID1");
                                break block50;
                            }
                            String con_name = null;
                            con_name = sysOperConName == null ? dbUtil.executeOracleReturnOneCol("select to_char(SYS_CONTEXT ('USERENV', 'CON_NAME')) CON_NAME from dual", null) : sysOperConName;
                            Statement st = null;
                            try {
                                tryNonPluggable = false;
                                String invalid = null;
                                ValidFlags flag = Shutdown.getType(cmd.getSQLOrig());
                                String toExecute = null;
                                if (flag == null) {
                                    ctx.write(Messages.getString("Shutdown.ILLEGAL"));
                                } else {
                                    switch (flag.ordinal()) {
                                        case 0: {
                                            toExecute = "alter pluggable database \"" + con_name + "\" close abort";
                                            break;
                                        }
                                        case 1: {
                                            toExecute = "alter pluggable database \"" + con_name + "\" close immediate";
                                            break;
                                        }
                                        case 2: {
                                            toExecute = "alter pluggable database \"" + con_name + "\" close ";
                                            break;
                                        }
                                        case 3: 
                                        case 4: {
                                            invalid = flag.toString().toLowerCase(Locale.US) + Messages.getString("Shutdown.NOTAVAILABLE");
                                        }
                                    }
                                    if (invalid == null) {
                                        st = ocon.createStatement();
                                        st.execute(toExecute);
                                        pluggableAltered = true;
                                        ctx.write(Messages.getString("Shutdown.PLUGGABLE"));
                                    } else {
                                        ctx.write(invalid + "\n");
                                    }
                                    wasAlterDatabase = true;
                                }
                            }
                            finally {
                                try {
                                    if (st != null) {
                                        st.close();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        finally {
                            if (amILocked) {
                                LockManager.unlock((Connection)ocon);
                            }
                        }
                    }
                }
            }
            if (tryNonPluggable) {
                if (conn instanceof OracleConnection) {
                    Boolean isPrelim = (Boolean)ctx.getProperty("script.runner.PRELIM_AUTH");
                    OracleConnection ocon = (OracleConnection)conn;
                    String s = ocon.getProperties().getProperty("internal_logon");
                    if (isPrelim == null || isPrelim.equals(Boolean.FALSE)) {
                        if (this.isPublicNoDualUsed((Connection)ocon) || s != null && (s.toLowerCase().equals("sysdba") || s.toLowerCase().equals("sysoper") || s.toLowerCase().equals("sysasm"))) {
                            ValidFlags flag = Shutdown.getType(cmd.getSQLOrig());
                            if (flag == null) {
                                ctx.write(Messages.getString("Shutdown.ILLEGAL"));
                            } else {
                                switch (flag.ordinal()) {
                                    case 0: {
                                        ocon.shutdown(OracleConnection.DatabaseShutdownMode.ABORT);
                                        ctx.write(Messages.getString("Shutdown.DATABASEABORTED"));
                                        nonPlugSuccess = this.switchConnection(ctx, ocon);
                                        break;
                                    }
                                    case 1: {
                                        ocon.shutdown(OracleConnection.DatabaseShutdownMode.IMMEDIATE);
                                        nonPlugSuccess = this.cleanShutdown(ctx, ocon);
                                        break;
                                    }
                                    case 2: {
                                        ocon.shutdown(OracleConnection.DatabaseShutdownMode.CONNECT);
                                        nonPlugSuccess = this.cleanShutdown(ctx, ocon);
                                        break;
                                    }
                                    case 3: {
                                        ocon.shutdown(OracleConnection.DatabaseShutdownMode.TRANSACTIONAL);
                                        nonPlugSuccess = this.cleanShutdown(ctx, ocon);
                                        break;
                                    }
                                    case 4: {
                                        ocon.shutdown(OracleConnection.DatabaseShutdownMode.TRANSACTIONAL_LOCAL);
                                        nonPlugSuccess = this.cleanShutdown(ctx, ocon);
                                    }
                                }
                            }
                        } else {
                            ctx.write(Messages.getString("Shutdown.INSUFFPRIV"));
                        }
                    } else {
                        ctx.write(Messages.getString("Shutdown.IDLE_CONNECTION"));
                    }
                } else {
                    ctx.write(Messages.getString("Shutdown.NOTSUPPORTEDONCON"));
                }
            } else if (errorString != null) {
                ctx.write(errorString + "\n");
            }
        }
        catch (SQLException e) {
            ctx.write(e.getLocalizedMessage() + "\n");
        }
        if (!nonPlugSuccess && !pluggableAltered) {
            ScriptUtils.doWhenever(ctx, cmd, conn, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchConnection(ScriptRunnerContext ctx, OracleConnection ocon) throws SQLException {
        block15: {
            boolean isLocked = LockManager.lock((Connection)ocon);
            try {
                String password;
                if (!isLocked) break block15;
                boolean switchBase = false;
                if (ocon.equals((Object)ctx.getBaseConnection())) {
                    switchBase = true;
                }
                try {
                    if (!ocon.isClosed()) {
                        ocon.close();
                    }
                }
                catch (Exception e) {
                    Logger.warn(this.getClass(), e.getLocalizedMessage());
                }
                Properties props = (Properties)ctx.getProperty("cli.conn.props");
                Properties duplicateProperties = new Properties();
                String userName = props.getProperty("user");
                if (userName != null) {
                    duplicateProperties.setProperty("user", userName);
                }
                if ((password = props.getProperty("password")) != null) {
                    duplicateProperties.setProperty("password", password);
                }
                duplicateProperties.setProperty("prelim_auth", "true");
                duplicateProperties.setProperty("internal_logon", props.getProperty("internal_logon"));
                OracleConnection conn = (OracleConnection)DriverManager.getConnection((String)ctx.getProperty("cli.conn.url"), duplicateProperties);
                ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.TRUE);
                Boolean getCommit = (Boolean)ctx.getProperty("script.runner.autocommit.checkbox");
                try {
                    if (getCommit == null || getCommit.equals(Boolean.FALSE)) {
                        conn.setAutoCommit(false);
                    } else {
                        conn.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    Logger.warn(this.getClass(), e.getStackTrace()[0].toString(), e);
                }
                if (switchBase) {
                    ctx.setBaseConnection((Connection)conn);
                }
                ctx.setCurrentConnection((Connection)conn);
                boolean bl = true;
                return bl;
            }
            finally {
                if (isLocked) {
                    LockManager.unlock((Connection)ocon);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanShutdown(ScriptRunnerContext ctx, OracleConnection ocon) throws SQLException {
        block27: {
            Statement stmt = null;
            try {
                block26: {
                    try {
                        stmt = ocon.createStatement();
                        stmt.execute("alter database close normal");
                        ctx.write(Messages.getString("Shutdown.13"));
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() == 1109) {
                            ctx.write(ex.getLocalizedMessage() + "\n");
                            break block26;
                        }
                        throw ex;
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException x) {
                                Logger.ignore(this.getClass(), x);
                            }
                        }
                    }
                }
                stmt = ocon.createStatement();
                stmt.execute("alter database dismount");
                ctx.write(Messages.getString("Shutdown.15"));
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1507) {
                    ctx.write(ex.getLocalizedMessage() + "\n");
                    break block27;
                }
                throw ex;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException x) {
                        Logger.ignore(this.getClass(), x);
                    }
                }
            }
        }
        ocon.shutdown(OracleConnection.DatabaseShutdownMode.FINAL);
        ctx.write(Messages.getString("Shutdown.16"));
        return this.switchConnection(ctx, ocon);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPublicNoDualUsed(Connection conn) {
        String retVal = null;
        Statement stmt = null;
        if (conn != null && conn instanceof OracleConnection) {
            boolean amILocked = LockManager.lock(conn);
            try {
                if (amILocked) {
                    stmt = conn.prepareCall(new StringBuffer("DECLARE \n").append("CHECKONE VARCHAR2(1000):=NULL; \n").append("BEGIN \n").append(" BEGIN \n").append("   CHECKONE:=USER; \n").append(" EXCEPTION \n").append(" WHEN OTHERS THEN \n").append("  CHECKONE :=NULL; \n").append(" END; \n").append(" :CHECKFORONE:=CHECKONE; \n").append("END;").toString());
                    stmt.registerOutParameter(1, 12);
                    stmt.executeUpdate();
                    retVal = stmt.getString(1);
                    if (stmt.wasNull()) {
                        retVal = null;
                    }
                }
            }
            catch (Exception e) {
                retVal = null;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        Logger.ignore(this.getClass(), e);
                    }
                }
                if (amILocked) {
                    LockManager.unlock(conn);
                }
            }
        }
        return retVal != null && retVal.equals("PUBLIC");
    }

    private static ValidFlags getType(String cmdText) {
        String[] commandParts = cmdText.trim().split("\\s+");
        if (commandParts.length == 1) {
            return ValidFlags.NORMAL;
        }
        if (commandParts.length == 2) {
            if (commandParts[1].toLowerCase(Locale.US).equals(ValidFlags.IMMEDIATE.toString().toLowerCase(Locale.US))) {
                return ValidFlags.IMMEDIATE;
            }
            if (commandParts[1].toLowerCase(Locale.US).equals(ValidFlags.NORMAL.toString().toLowerCase(Locale.US))) {
                return ValidFlags.NORMAL;
            }
            if (commandParts[1].toLowerCase(Locale.US).equals(ValidFlags.ABORT.toString().toLowerCase(Locale.US))) {
                return ValidFlags.ABORT;
            }
            if (commandParts[1].toLowerCase(Locale.US).equals(ValidFlags.TRANSACTIONAL.toString().toLowerCase(Locale.US))) {
                return ValidFlags.TRANSACTIONAL;
            }
            return null;
        }
        if (commandParts.length == 3 && (commandParts[1].toLowerCase(Locale.US) + " " + commandParts[2].toLowerCase(Locale.US)).equals(ValidFlags.TRANSACTIONAL_LOCAL.toString().toLowerCase(Locale.US))) {
            return ValidFlags.TRANSACTIONAL_LOCAL;
        }
        return null;
    }

    public static enum ValidFlags {
        ABORT,
        IMMEDIATE,
        NORMAL,
        TRANSACTIONAL,
        TRANSACTIONAL_LOCAL{

            public String toString() {
                return "transactional local";
            }
        };

    }
}

