/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.plusplus.FileSystem;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.IndexBuilder;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Messages;
import oracle.dbtools.util.BOMSkipper;

public class Buffer
implements IBuffer {
    private static final String SLASH = "/";
    private final ArrayList<String> buffer = new ArrayList();
    private int currentLine = -1;
    private boolean editing = false;
    private IBuffer bufferSafe;
    private int termLine;
    private static final Function<String, String> defaultLineTransformer = line -> line;

    public static void main(String[] args) {
        Buffer.testBufferList();
        Buffer.testBufferEdit();
        Buffer.testBufferFile();
    }

    private static void testBufferFile() {
        Buffer abuffer = new Buffer();
        abuffer.add("This is first String");
        abuffer.add("This is second String");
        abuffer.add("This is third String");
        abuffer.addAtIndex(2, "This is four string");
        abuffer.setCurrentLine(2);
        System.out.println(abuffer.list(false));
        System.out.println("Saving buffer");
        abuffer.save("/tmp/test.sql", FileSystem.State.REPLACE, "sql");
        System.out.println("buffer saved");
        System.out.println("Try empty buffer");
        abuffer.clear();
        System.out.println("printing buffer");
        System.out.println(abuffer.list(false));
        System.out.println("finish printing buffer");
        System.out.println("GEt test.sql");
        abuffer.get("/tmp/test.sql", true);
        System.out.println("buffer loaded");
        System.out.println("printing buffer");
        System.out.println(abuffer.list(false));
        System.out.println("finish printing buffer");
        System.out.println("getBufferString");
        System.out.println(abuffer.getBuffer());
    }

    private static void testBufferEdit() {
        Buffer abuffer = new Buffer();
        abuffer.add("This is first String");
        abuffer.add("This is second String");
        abuffer.add("This is third String");
        abuffer.addAtIndex(2, "This is four string");
        abuffer.setCurrentLine(2);
        System.out.println(abuffer.list(false));
        abuffer.append("Appending this");
        System.out.println("");
        System.out.println(abuffer.list(false));
        System.out.println("Try deleting 'Appending this' again");
        abuffer.change("Appending this");
        System.out.println(abuffer.list(false));
        System.out.println("Try changing second to 2 ");
        abuffer.change("second", "2");
        System.out.println(abuffer.list(false));
        System.out.println("Try insert newline");
        abuffer.input("select * from dual");
        System.out.println(abuffer.list(false));
        abuffer.change("from", "select abc");
        System.out.println(abuffer.list(false));
        System.out.println("Try empty buffer");
        abuffer.clear();
        System.out.println("printing buffer");
        System.out.println(abuffer.list(false));
        System.out.println("finish printing buffer");
    }

    private static void testBufferList() {
        Buffer buffer = new Buffer();
        buffer.add("This is first String");
        buffer.add("This is second String");
        buffer.add("This is third String");
        System.out.println(buffer.list(false));
        System.out.println("buffer.getBuffer():");
        System.out.println(">>>" + buffer.getBuffer() + "<<<");
        System.out.println("");
        buffer.addAtIndex(2, "This is four string");
        buffer.setCurrentLine(2);
        System.out.println(buffer.list(false));
        System.out.println("list last");
        System.out.println(buffer.listLast(false));
        System.out.println("list 1 3");
        System.out.println(buffer.list(1, 3, false));
        System.out.println("list * 4");
        System.out.println(buffer.deleteStarN(4));
        System.out.println("list 2 *");
        System.out.println(buffer.deleteNStar(2));
        System.out.println("list *");
        System.out.println(buffer.listStar(false));
        System.out.println("list 4");
        System.out.println(buffer.list(4, false));
    }

    @Override
    public void add(String string) {
        this.buffer.add(string);
        this.currentLine = this.buffer.size();
    }

    @Override
    public void addAtIndex(int index, String string) {
        if (this.buffer.size() == 0) {
            this.buffer.add(string);
            return;
        }
        int newIndex = index;
        if (index < 0) {
            newIndex = 0;
        }
        if (index > this.buffer.size()) {
            this.buffer.add(string);
        } else {
            this.buffer.add(newIndex, string);
        }
    }

    @Override
    public int getCurrentLine() {
        if (this.currentLine < 0) {
            return 0;
        }
        return this.currentLine;
    }

    @Override
    public String list(boolean trim) {
        return this.list(trim, defaultLineTransformer);
    }

    @Override
    public String list(boolean trim, Function<String, String> lineTransformer) {
        if (this.buffer.size() > 0 && this.buffer.get(this.buffer.size() - 1).trim().equals(SLASH)) {
            this.setCurrentLine(this.buffer.size() - 1);
            return this.list(1, this.buffer.size() - 1, trim);
        }
        this.setCurrentLine(this.buffer.size());
        Iterator<String> bufferIterator = this.buffer.iterator();
        int lineNumber = 1;
        if (bufferIterator.hasNext()) {
            StringBuilder sb = new StringBuilder();
            while (bufferIterator.hasNext()) {
                String line = bufferIterator.next();
                if (!bufferIterator.hasNext() && line.trim().endsWith(";") && trim) {
                    line = line.substring(0, line.length() - 1);
                }
                line = lineTransformer.apply(line);
                sb.append(IndexBuilder.getIndex(lineNumber, this.getCurrentLine()) + line + "\n");
                ++lineNumber;
            }
            return sb.toString();
        }
        return Messages.getString("Buffer.51");
    }

    @Override
    public String list() {
        return this.list(defaultLineTransformer);
    }

    @Override
    public String list(Function<String, String> lineTransformer) {
        if (this.buffer.size() > 0 && (this.buffer.get(this.buffer.size() - 1).trim().equals(SLASH) || this.buffer.get(this.buffer.size() - 1).trim().equals(".") || this.buffer.get(this.buffer.size() - 1).trim().equals(";"))) {
            this.setCurrentLine(this.buffer.size() - 1);
            return this.list(1, this.buffer.size() - 1, false);
        }
        this.setCurrentLine(this.buffer.size());
        Iterator<String> bufferIterator = this.buffer.iterator();
        int lineNumber = 1;
        if (bufferIterator.hasNext()) {
            StringBuilder sb = new StringBuilder();
            while (bufferIterator.hasNext()) {
                String line = lineTransformer.apply(bufferIterator.next());
                sb.append(IndexBuilder.getIndex(lineNumber, this.getCurrentLine()) + line + "\n");
                ++lineNumber;
            }
            Object listString = sb.toString();
            if (sb.toString().trim().endsWith(";") || sb.toString().trim().endsWith(SLASH)) {
                listString = StringUtils.rtrim(sb.toString()).substring(0, StringUtils.rtrim(sb.toString()).length() - 1) + "\n";
            }
            return listString;
        }
        return Messages.getString("Buffer.51");
    }

    @Override
    public void cleanSlashFromBuffer() {
        if (this.buffer.size() > 0 && this.buffer.get(this.buffer.size() - 1).trim().equals(SLASH)) {
            this.buffer.remove(this.buffer.size() - 1);
        }
    }

    @Override
    public String list(int n, boolean trim) {
        return this.list(n, trim, defaultLineTransformer);
    }

    @Override
    public String list(int n, boolean trim, Function<String, String> lineTransformer) {
        if (n > 0 && n <= this.buffer.size()) {
            this.currentLine = n;
            return IndexBuilder.getIndex(n, this.getCurrentLine()) + lineTransformer.apply(this.buffer.get(n - 1)) + "\n";
        }
        return Messages.getString("Buffer.53");
    }

    @Override
    public String listStar(boolean trim) {
        return this.listStar(trim, defaultLineTransformer);
    }

    @Override
    public String listStar(boolean trim, Function<String, String> lineTransformer) {
        if (this.buffer.size() > 0) {
            return IndexBuilder.getIndex(this.getCurrentLine(), this.getCurrentLine()) + lineTransformer.apply(this.buffer.get(this.currentLine - 1)) + "\n";
        }
        return "";
    }

    @Override
    public String listLast(boolean trim) {
        return this.listLast(trim, defaultLineTransformer);
    }

    @Override
    public String listLast(boolean trim, Function<String, String> lineTransformer) {
        if (this.buffer.size() > 0) {
            this.setCurrentLine(this.buffer.size());
            return IndexBuilder.getIndex(this.buffer.size(), this.getCurrentLine()) + lineTransformer.apply(this.buffer.get(this.buffer.size() - 1)) + "\n";
        }
        return "";
    }

    @Override
    public String list(int m, int n, boolean trim) {
        return this.list(m, n, trim, defaultLineTransformer);
    }

    @Override
    public String list(int m, int n, boolean trim, Function<String, String> lineTransformer) {
        if (m <= n && n <= this.buffer.size() && m > 0) {
            this.setCurrentLine(n);
            Iterator<String> bufferIterator = this.buffer.iterator();
            int lineNumber = 1;
            int index = this.getCurrentLine();
            StringBuilder sb = new StringBuilder();
            while (bufferIterator.hasNext()) {
                if (lineNumber >= m && lineNumber <= n) {
                    if (trim) {
                        String toPrint = lineTransformer.apply(bufferIterator.next());
                        if (bufferIterator.hasNext() || !this.buffer.get(this.buffer.size() - 1).trim().equals(";") && !this.buffer.get(this.buffer.size() - 1).trim().equals(SLASH)) {
                            index = lineNumber + 1 == this.getCurrentLine() && lineNumber + 1 == this.buffer.size() && this.getBuffer().trim().endsWith(";") ? lineNumber : this.getCurrentLine();
                            sb.append(IndexBuilder.getIndex(lineNumber, index) + toPrint + "\n");
                        }
                    } else {
                        sb.append(IndexBuilder.getIndex(lineNumber, this.getCurrentLine()) + lineTransformer.apply(bufferIterator.next()) + "\n");
                    }
                } else {
                    bufferIterator.next();
                }
                ++lineNumber;
            }
            return sb.toString();
        }
        if (n > m && m > 0 && n <= this.buffer.size()) {
            return Messages.getString("Buffer.59");
        }
        return Messages.getString("Buffer.61");
    }

    @Override
    public String delete() {
        return this.delete(false);
    }

    @Override
    public String delete(boolean trim) {
        if (this.buffer.size() == 0) {
            return Messages.getString("Buffer.65");
        }
        if (this.buffer.size() >= 1) {
            this.buffer.remove(this.getCurrentLine() - 1);
            this.updateCurrentLineAfterDeletion();
        }
        return "";
    }

    @Override
    public String delete(int lineNumber) {
        return this.delete(lineNumber, false);
    }

    @Override
    public String delete(int lineNumber, boolean trim) {
        if (lineNumber > 0 && lineNumber <= this.buffer.size()) {
            int n = 1;
            if (trim && this.buffer.size() > 1 && this.buffer.get(this.buffer.size()).trim().equals(SLASH)) {
                n = 2;
            }
            this.buffer.remove(lineNumber - n);
            return "";
        }
        return Messages.getString("Buffer.63");
    }

    @Override
    public String deleteStar(boolean trim) {
        return this.delete(trim);
    }

    @Override
    public String deleteStar() {
        return this.delete(false);
    }

    @Override
    public String deleteNStar(int n, boolean trim) {
        if (this.buffer.size() == 0) {
            return Messages.getString("Buffer.59");
        }
        if (this.getCurrentLine() >= n) {
            return this.delete(n, this.getCurrentLine(), trim);
        }
        return Messages.getString("Buffer.64");
    }

    @Override
    public String deleteNStar(int n) {
        return this.deleteNStar(n, false);
    }

    @Override
    public String deleteLast(boolean trim) {
        if (this.buffer.size() > 0) {
            if (trim && this.buffer.get(this.buffer.size() - 1).trim().equals(SLASH) && this.buffer.size() > 1) {
                this.buffer.remove(this.buffer.size() - 1);
            }
            this.buffer.remove(this.buffer.size() - 1);
            return "";
        }
        return Messages.getString("Buffer.65");
    }

    @Override
    public String deleteLast() {
        return this.deleteLast(false);
    }

    @Override
    public String delete(int m, int n) {
        return this.delete(m, n, false);
    }

    @Override
    public String delete(int m, int n, boolean trim) {
        if (this.buffer.size() > 0) {
            if (m <= n && n <= this.buffer.size() && m > 0) {
                int num2Delete = n - m + 1;
                for (int i = 0; i < num2Delete; ++i) {
                    this.buffer.remove(m - 1);
                }
                return "";
            }
            if (m > n) {
                return Messages.getString("Buffer.67");
            }
            return Messages.getString("Buffer.68");
        }
        return Messages.getString("Buffer.69");
    }

    @Override
    public String deleteStarN(int n, boolean trim) {
        if (this.getCurrentLine() <= n) {
            return this.delete(this.getCurrentLine(), n);
        }
        return Messages.getString("Buffer.67");
    }

    @Override
    public String deleteStarN(int n) {
        return this.deleteStarN(n, false);
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.currentLine = -1;
    }

    @Override
    public void append(String string) {
        if (this.getCurrentLine() <= 0) {
            this.buffer.add(string);
            this.setCurrentLine(1);
        } else {
            Object newline = this.buffer.get(this.currentLine - 1);
            if (((String)newline).trim().endsWith(";")) {
                newline = ((String)newline).trim().replaceAll(";$", "");
            }
            newline = (String)newline + string;
            this.buffer.set(this.currentLine - 1, (String)newline);
        }
    }

    @Override
    public String change(String oldString, String newString) {
        if (this.currentLine < 1) {
            this.currentLine = 1;
        }
        if (!this.buffer.isEmpty()) {
            String newline = this.buffer.get(this.currentLine - 1);
            int index = newline.indexOf(oldString);
            if (index < 0) {
                return Messages.getString("Buffer.70");
            }
            StringBuilder buff = new StringBuilder();
            buff.append(newline.substring(0, index)).append(newString).append(newline.substring(index + oldString.length()));
            newline = buff.toString();
            this.buffer.set(this.currentLine - 1, newline);
            return this.list(false);
        }
        return Messages.getString("Buffer.80");
    }

    @Override
    public String change(String string) {
        return this.change(string, "");
    }

    @Override
    public String input(String string) {
        if (this.currentLine < 0) {
            this.currentLine = 0;
        }
        this.addAtIndex(this.currentLine, string);
        this.setCurrentLine(this.currentLine + 1);
        return "";
    }

    @Override
    public FileSystem.Results get(String filename, boolean list, String suffix) {
        if (filename.lastIndexOf(".") == -1) {
            FileSystem.Results results = this.get(filename, list);
            if (!results.equals((Object)FileSystem.Results.OK)) {
                String newFileNameWithSuffix = filename + "." + suffix;
                return this.get(newFileNameWithSuffix, list);
            }
            return results;
        }
        return this.get(filename, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem.Results get(String filename, boolean list) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(filename));
            BOMSkipper.skip(reader);
            FileSystem.Results results = this.get(reader, list);
            return results;
        }
        catch (FileNotFoundException e) {
            FileSystem.Results results = FileSystem.Results.FILE_NOT_FOUND;
            return results;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem.Results get(File file, boolean list) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            BOMSkipper.skip(reader);
            FileSystem.Results results = this.get(reader, list);
            return results;
        }
        catch (FileNotFoundException e) {
            FileSystem.Results results = FileSystem.Results.FILE_NOT_FOUND;
            return results;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private FileSystem.Results get(BufferedReader reader, boolean list) {
        try {
            String text = null;
            this.buffer.clear();
            while ((text = reader.readLine()) != null) {
                this.buffer.add(text);
            }
            if (this.buffer.size() > 0) {
                this.setCurrentLine(this.buffer.size());
                if (this.buffer.get(this.getCurrentLine() - 1).trim().equals(SLASH)) {
                    this.delete(this.getCurrentLine());
                }
            }
            this.setBufferSafe(this.buffer);
            return FileSystem.Results.OK;
        }
        catch (IOException e) {
            return FileSystem.Results.FILE_NOT_ACCESSIBLE;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String save(String filename, FileSystem.State state, String suffix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getBuffer() {
        Iterator<String> bufferIterator = this.buffer.iterator();
        StringBuilder sb = new StringBuilder();
        while (bufferIterator.hasNext()) {
            sb.append(bufferIterator.next() + "\n");
        }
        return sb.toString();
    }

    @Override
    public String setCurrentLine(int lineNumber) {
        if (lineNumber > 0 && lineNumber <= this.buffer.size()) {
            this.currentLine = lineNumber;
        }
        return this.list(lineNumber, false);
    }

    @Override
    public String replace(int lineNumber, String string) {
        if (this.buffer.size() == 0) {
            this.buffer.add(string);
        }
        if (lineNumber < 1) {
            this.buffer.set(0, string);
        } else if (lineNumber - 1 < this.buffer.size()) {
            this.buffer.set(lineNumber - 1, string);
        }
        return this.list(lineNumber, false);
    }

    @Override
    public int linesInBuffer() {
        return this.buffer.size();
    }

    @Override
    public String getPrompt() {
        String prompt = IndexBuilder.getIndex(this.linesInBuffer() + 1, -1);
        return prompt;
    }

    @Override
    public String getPrompt(int line) {
        String prompt = IndexBuilder.getIndex(line, -1);
        return prompt;
    }

    @Override
    public boolean isEditing() {
        return this.editing;
    }

    @Override
    public void startEditing(boolean clear) {
        if (!this.editing && clear) {
            this.clear();
        }
        this.editing = true;
    }

    @Override
    public void startEditingAfterHistory() {
        this.editing = true;
    }

    @Override
    public void stopEditing() {
        this.editing = false;
    }

    @Override
    public String listNStar(int n, boolean trim) {
        return this.listNStar(n, trim, defaultLineTransformer);
    }

    @Override
    public String listNStar(int n, boolean trim, Function<String, String> lineTransformer) {
        if (this.buffer.size() == 0 || n > this.getCurrentLine()) {
            return Messages.getString("Buffer.59");
        }
        if (this.getCurrentLine() >= n) {
            return lineTransformer.apply(this.list(n, this.getCurrentLine(), trim));
        }
        return Messages.getString("Buffer.108");
    }

    @Override
    public String listStarN(int n, boolean trim) {
        return this.listStarN(n, trim, defaultLineTransformer);
    }

    @Override
    public String listStarN(int n, boolean trim, Function<String, String> lineTransformer) {
        if (this.getCurrentLine() <= n) {
            return lineTransformer.apply(this.list(this.getCurrentLine(), n, trim));
        }
        return "";
    }

    @Override
    public void resetBuffer(String bufferString) {
        String[] lines = bufferString.split("\n");
        this.resetBuffer(Arrays.asList(lines));
    }

    @Override
    public void resetBuffer(List<String> historyItem) {
        this.buffer.clear();
        this.buffer.addAll(historyItem);
        this.setCurrentLine(this.buffer.size());
    }

    @Override
    public String getLine(int n) {
        if (n - 1 >= 0 && this.buffer.size() > 0 && this.buffer.get(n - 1) != null) {
            return this.buffer.get(n - 1);
        }
        return "";
    }

    @Override
    public boolean previous() {
        if (this.getCurrentLine() <= 1) {
            return false;
        }
        this.setCurrentLine(this.getCurrentLine() - 1);
        return true;
    }

    @Override
    public boolean next() {
        if (this.getCurrentLine() >= this.buffer.size()) {
            return false;
        }
        this.setCurrentLine(this.getCurrentLine() + 1);
        return true;
    }

    @Override
    public int size() {
        return this.buffer.size();
    }

    @Override
    public ArrayList<String> getBufferList() {
        return this.buffer;
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.size() <= 0;
    }

    @Override
    public void setBufferSafe(ArrayList<String> bufferList) {
        if (bufferList.size() > 0 && bufferList.get(bufferList.size() - 1).trim().equals(SLASH)) {
            bufferList.remove(bufferList.size() - 1);
        }
        this.getBufferSafe().resetBuffer(bufferList);
    }

    @Override
    public IBuffer getBufferSafe() {
        if (this.bufferSafe == null) {
            this.bufferSafe = new Buffer();
        }
        return this.bufferSafe;
    }

    @Override
    @Deprecated
    public String getCurrentBufferState(String line) {
        this.replace(this.getCurrentLine(), line);
        return this.getBuffer().replace("\n", " ").replace("\r", " ");
    }

    @Override
    @Deprecated
    public int getCursorLocation(int cursor) {
        int count = 0;
        for (int i = 0; i < this.getCurrentLine() - 1; ++i) {
            count += this.buffer.get(i).length();
        }
        count += cursor;
        return 0;
    }

    @Override
    public String getBufferString() {
        Iterator<String> bufferIterator = this.buffer.iterator();
        StringBuilder sb = new StringBuilder();
        while (bufferIterator.hasNext()) {
            sb.append(bufferIterator.next());
            if (!bufferIterator.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int getBufferCursor(int currentLine, int cursor) {
        int bufPos = 0;
        int line = 0;
        Iterator<String> bufferIterator = this.buffer.iterator();
        while (bufferIterator.hasNext()) {
            if (++line != this.getCurrentLine()) {
                bufPos += bufferIterator.next().length();
                continue;
            }
            return (bufPos += cursor) + currentLine - 1;
        }
        return 0;
    }

    @Override
    public void setTermLine(int line, int termHeight) {
        this.termLine = line <= 1 ? 1 : line;
        if (this.termLine > termHeight) {
            this.termLine = termHeight;
        }
        if (termHeight - this.termLine > this.buffer.size() - this.currentLine) {
            this.termLine = termHeight;
        }
    }

    @Override
    public int getTermLine() {
        return this.termLine;
    }

    private void updateCurrentLineAfterDeletion() {
        if (this.currentLine > this.buffer.size()) {
            this.currentLine = this.buffer.size();
        }
    }
}

