/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline;

import java.text.MessageFormat;

public class NLSLANGParser {
    private static boolean debug = false;
    private static String lang = "";
    private static String country = "";
    private static String encoding = "";
    private static String nls_lang;

    public static void main(String[] args) {
        debug = true;
        NLSLANGParser.getNLSLang();
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("french_germany.utf8");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("_france.utf8");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("french:utf8");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang(".utf8");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("en");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("ENGLISH");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("BARRY");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("ENGLISH_BARRY");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("ENGLISH_FRANCE");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("ENGLISH_FRANCE.BARRY");
        NLSLANGParser.resetNLSLang();
        NLSLANGParser.getNLSLang("ENGLISH_FRANCE.ZHS16GBK");
    }

    public static String getNLSTerritory() {
        return country;
    }

    public static String getNLSLanguage() {
        return lang;
    }

    public static String getNLSEncoding() {
        return encoding;
    }

    private static void getNLSLang(String string) {
        nls_lang = string;
        if (nls_lang == null) {
            NLSLANGParser.resetNLSLang();
        } else if (nls_lang != null && nls_lang.length() != 0) {
            String[] minibits;
            String[] bits = nls_lang.split("\\.");
            if (bits.length > 1) {
                encoding = bits[1];
            }
            if ((minibits = bits[0].split("_")).length > 1) {
                country = minibits[1];
            }
            lang = minibits[0];
        }
        if (debug) {
            System.out.println(MessageFormat.format("NLS_LANG={0},lang {1},territory {2}, encoding {3}, isValid {4}", nls_lang, lang, country, encoding, NLSLANGParser.isNLSLangValid()));
        }
    }

    private static void getNLSLang() {
        String nlslang = System.getenv("NLS_LANG");
        NLSLANGParser.getNLSLang(nlslang);
    }

    public static void resetNLSLang() {
        lang = "";
        country = "";
        encoding = "";
    }

    public static boolean isNLSLangSet() {
        if (System.getenv("NLS_LANG") != null) {
            NLSLANGParser.getNLSLang();
            return true;
        }
        return false;
    }

    public static boolean isValidLanguage(String lang) {
        Languages realLang = NLSLANGParser.getEnumFromString(Languages.class, lang);
        return realLang != null;
    }

    public static boolean isValidTerritory(String territory) {
        Territories realTerritory = NLSLANGParser.getEnumFromString(Territories.class, territory);
        return realTerritory != null;
    }

    public static boolean isValidCharacterSet(String charSet) {
        CharacterSet realTerritory = NLSLANGParser.getEnumFromString(CharacterSet.class, charSet);
        return realTerritory != null;
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        if (c != null && string != null) {
            try {
                return Enum.valueOf(c, string.trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isNLSLangValid() {
        if (!lang.equals("") && !NLSLANGParser.isValidLanguage(lang)) {
            return false;
        }
        if (!country.equals("") && !NLSLANGParser.isValidTerritory(country)) {
            return false;
        }
        if (!encoding.equals("") && !NLSLANGParser.isValidCharacterSet(encoding)) {
            return false;
        }
        return (encoding + country + lang).length() != 0;
    }

    public static String getNLSLANG() {
        return nls_lang;
    }

    public static enum Languages {
        AMERICAN,
        ARABIC,
        BENGALI,
        BRAZILIAN_PORTUGUESE,
        BULGARIAN,
        CANADIAN_FRENCH,
        CATALAN,
        CROATIAN,
        CZECH,
        DANISH,
        DUTCH,
        EGYPTIAN,
        ENGLISH,
        ESTONIAN,
        FINNISH,
        FRENCH,
        GERMAN,
        GERMAN_DIN,
        GREEK,
        HEBREW,
        HINDI,
        HUNGARIAN,
        ICELANDIC,
        INDONESIAN,
        ITALIAN,
        JAPANESE,
        KOREAN,
        LATIN_AMERICAN_SPANISH,
        LATVIAN,
        LITHUANIAN,
        MALAY,
        MEXICAN_SPANISH,
        NORWEGIAN,
        POLISH,
        PORTUGUESE,
        ROMANIAN,
        RUSSIAN,
        SIMPLIFIED_CHINESE,
        SLOVAK,
        SLOVENIAN,
        SPANISH,
        SWEDISH,
        TAMIL,
        THAI,
        TRADITIONAL_CHINESE,
        TURKISH,
        UKRAINIAN,
        VIETNAMESE;

    }

    public static enum Territories {
        ALGERIA,
        ICELAND,
        QATAR,
        AMERICA,
        INDIA,
        ROMANIA,
        AUSTRALIA,
        INDONESIA,
        SAUDI_ARABIA,
        AUSTRIA,
        IRAQ,
        SINGAPORE,
        BAHRAIN,
        IRELAND,
        SLOVAKIA,
        BANGLADESH,
        ISRAEL,
        SLOVENIA,
        BELGIUM,
        ITALY,
        SOMALIA,
        BRAZIL,
        JAPAN,
        SOUTH_AFRICA,
        BULGARIA,
        JORDAN,
        SPAIN,
        CANADA,
        KAZAKHSTAN,
        SUDAN,
        CATALONIA,
        KOREA,
        SWEDEN,
        CHINA,
        KUWAIT,
        SWITZERLAND,
        CIS,
        LATVIA,
        SYRIA,
        CROATIA,
        LEBANON,
        TAIWAN,
        CYPRUS,
        LIBYA,
        THAILAND,
        CZECH_REPUBLIC,
        LITHUANIA,
        THE_NETHERLANDS,
        DENMARK,
        LUXEMBOURG,
        TUNISIA,
        DJIBOUTI,
        MALAYSIA,
        TURKEY,
        EGYPT,
        MAURITANIA,
        UKRAINE,
        ESTONIA,
        MEXICO,
        UNITED_ARAB_EMIRATES,
        FINLAND,
        MOROCCO,
        UNITED_KINGDOM,
        FRANCE,
        NEW_ZEALAND,
        UZBEKISTAN,
        GERMANY,
        NORWAY,
        VIETNAM,
        GREECE,
        OMAN,
        YEMEN,
        HONG_KONG,
        POLAND,
        HUNGARY,
        PORTUGAL;

    }

    public static enum CharacterSet {
        AL24UTFFSS,
        AR8ADOS710,
        AR8ADOS710T,
        AR8ADOS720,
        AR8ADOS720T,
        AR8APTEC715,
        AR8APTEC715T,
        AR8ARABICMAC,
        AR8ARABICMACS,
        AR8ARABICMACT,
        AR8ASMO708PLUS,
        AR8ASMO8X,
        AR8EBCDIC420S,
        AR8EBCDICX,
        AR8HPARABIC8T,
        AR8ISO8859P6,
        AR8MSWIN1256,
        AR8MUSSAD768,
        AR8MUSSAD768T,
        AR8NAFITHA711,
        AR8NAFITHA711T,
        AR8NAFITHA721,
        AR8NAFITHA721T,
        AR8SAKHR706,
        AR8SAKHR707,
        AR8SAKHR707T,
        AR8XBASIC,
        BG8MSWIN,
        BG8PC437S,
        BLT8CP921,
        BLT8EBCDIC1112,
        BLT8EBCDIC1112S,
        BLT8MSWIN1257,
        BLT8PC775,
        BN8BSCII,
        CDN8PC863,
        CH7DEC,
        CL8BS2000,
        CL8EBCDIC1025,
        CL8EBCDIC1025C,
        CL8EBCDIC1025S,
        CL8EBCDIC1025X,
        CL8ISO8859P5,
        CL8KOI8R,
        CL8MACCYRILLIC,
        CL8MACCYRILLICS,
        CL8MSWIN1251,
        D7DEC,
        D7SIEMENS9780X,
        D8BS2000,
        D8EBCDIC1141,
        D8EBCDIC273,
        DK7SIEMENS9780X,
        DK8BS2000,
        DK8EBCDIC1142,
        DK8EBCDIC277,
        E7DEC,
        E7SIEMENS9780X,
        E8BS2000,
        EE8EBCDIC870,
        EE8EBCDIC870C,
        EE8EBCDIC870S,
        EE8ISO8859P2,
        EE8MACCE,
        EE8MACCES,
        EE8MACCROATIAN,
        EE8MACCROATIANS,
        EE8MSWIN1250,
        EE8PC852,
        EEC8EUROASCI,
        EEC8EUROPA3,
        EL8DEC,
        EL8EBCDIC875,
        EL8EBCDIC875S,
        EL8GCOS7,
        EL8ISO8859P7,
        EL8MACGREEK,
        EL8MACGREEKS,
        EL8MSWIN1253,
        EL8PC437S,
        EL8PC737,
        EL8PC851,
        EL8PC869,
        ET8MSWIN923,
        F7DEC,
        F7SIEMENS9780X,
        F8BS2000,
        F8EBCDIC1147,
        F8EBCDIC297,
        HU8ABMOD,
        HU8CWI2,
        I7DEC,
        I7SIEMENS9780X,
        I8EBCDIC1144,
        I8EBCDIC280,
        IN8ISCII,
        IS8MACICELANDIC,
        IS8MACICELANDICS,
        IS8PC861,
        IW7IS960,
        IW8EBCDIC1086,
        IW8EBCDIC424,
        IW8EBCDIC424S,
        IW8ISO8859P8,
        IW8MACHEBREW,
        IW8MACHEBREWS,
        IW8MSWIN1255,
        IW8PC1507,
        JA16DBCS,
        JA16DBCSFIXED,
        JA16EBCDIC930,
        JA16EUC,
        JA16EUCFIXED,
        JA16EUCYEN,
        JA16MACSJIS,
        JA16SJIS,
        JA16SJISFIXED,
        JA16SJISYEN,
        JA16VMS,
        KO16DBCS,
        KO16DBCSFIXED,
        KO16KSC5601,
        KO16KSC5601FIXED,
        KO16KSCCS,
        KO16MSWIN949,
        LA8ISO6937,
        LA8PASSPORT,
        LT8MSWIN921,
        LT8PC772,
        LT8PC774,
        LV8PC1117,
        LV8PC8LR,
        LV8RST104090,
        N7SIEMENS9780X,
        N8PC865,
        NDK7DEC,
        NE8ISO8859P10,
        NEE8ISO8859P4,
        NL7DEC,
        RU8BESTA,
        RU8PC855,
        RU8PC866,
        S7DEC,
        S7SIEMENS9780X,
        S8BS2000,
        S8EBCDIC1143,
        S8EBCDIC278,
        SE8ISO8859P3,
        SF7ASCII,
        SF7DEC,
        TH8MACTHAI,
        TH8MACTHAIS,
        TH8TISASCII,
        TH8TISEBCDIC,
        TH8TISEBCDICS,
        TR7DEC,
        TR8DEC,
        TR8EBCDIC1026,
        TR8EBCDIC1026S,
        TR8MACTURKISH,
        TR8MACTURKISHS,
        TR8MSWIN1254,
        TR8PC857,
        US7ASCII,
        US8BS2000,
        US8ICL,
        US8PC437,
        UTF8,
        UTFE,
        VN8MSWIN1258,
        VN8VN3,
        WE8BS2000,
        WE8BS2000L5,
        WE8DEC,
        WE8DG,
        WE8EBCDIC1047,
        WE8EBCDIC1140,
        WE8EBCDIC1140C,
        WE8EBCDIC1145,
        WE8EBCDIC1146,
        WE8EBCDIC1148,
        WE8EBCDIC1148C,
        WE8EBCDIC284,
        WE8EBCDIC285,
        WE8EBCDIC37,
        WE8EBCDIC37C,
        WE8EBCDIC500,
        WE8EBCDIC500C,
        WE8EBCDIC871,
        WE8GCOS7,
        WE8HP,
        WE8ICL,
        WE8ISO8859P1,
        WE8ISO8859P15,
        WE8ISO8859P9,
        WE8ISOICLUK,
        WE8MACROMAN8,
        WE8MACROMAN8S,
        WE8MSWIN1252,
        WE8NCR4970,
        WE8NEXTSTEP,
        WE8PC850,
        WE8PC858,
        WE8PC860,
        WE8ROMAN8,
        YUG7ASCII,
        ZHS16CGB231280,
        ZHS16CGB231280FIXED,
        ZHS16DBCS,
        ZHS16DBCSFIXED,
        ZHS16GBK,
        ZHS16GBKFIXED,
        ZHS16MACCGB231280,
        ZHT16BIG5,
        ZHT16BIG5FIXED,
        ZHT16CCDC,
        ZHT16DBCS,
        ZHT16DBCSFIXED,
        ZHT16DBT,
        ZHT16MSWIN950,
        ZHT32EUC,
        ZHT32EUCFIXED,
        ZHT32SOPS,
        ZHT32TRIS,
        ZHT32TRISFIXED;

    }

    public static enum MiddleEasternCharSets {
        AR8APTEC715,
        AR8APTEC715T,
        AR8ASMO708PLUS,
        AR8ASMO8X,
        AR8ADOS710,
        AR8ADOS710T,
        AR8ADOS720,
        AR8ADOS720T,
        TR7DEC,
        TR8DEC,
        WE8EBCDIC37C,
        IW8EBCDIC424,
        IW8EBCDIC424S,
        WE8EBCDIC500C,
        IW8EBCDIC1086,
        AR8EBCDIC420S,
        AR8EBCDICX,
        TR8EBCDIC1026,
        TR8EBCDIC1026S,
        AR8HPARABIC8T,
        TR8PC857,
        IW8PC1507,
        AR8ISO8859P6,
        IW8ISO8859P8,
        WE8ISO8859P9,
        LA8ISO6937,
        IW7IS960,
        IW8MACHEBREW,
        AR8ARABICMAC,
        AR8ARABICMACT,
        TR8MACTURKISH,
        IW8MACHEBREWS,
        AR8ARABICMACS,
        TR8MACTURKISHS,
        TR8MSWIN1254,
        IW8MSWIN1255,
        AR8MSWIN1256,
        IN8ISCII,
        AR8MUSSAD768,
        AR8MUSSAD768T,
        AR8NAFITHA711,
        AR8NAFITHA711T,
        AR8NAFITHA721,
        AR8NAFITHA721T,
        AR8SAKHR706,
        AR8SAKHR707,
        AR8SAKHR707T,
        AR8XBASIC,
        WE8BS2000L5,
        AL24UTFFSS,
        UTF8,
        UTFE;

    }

    public static enum ASIAN_CHARSET {
        BN8BSCII,
        ZHT16BIG5,
        ZHS16CGB231280,
        JA16EUC,
        JA16EUCYEN,
        JA16EUCFIXED,
        ZHT32EUC,
        ZHT32EUCFIXED,
        ZHS16GBK,
        ZHS16GBKFIXED,
        ZHT16CCDC,
        JA16DBCS,
        JA16EBCDIC930,
        JA16DBCSFIXED,
        KO16DBCS,
        KO16DBCSFIXED,
        ZHS16DBCS,
        ZHS16CGB231280FIXED,
        ZHS16DBCSFIXED,
        ZHT16DBCS,
        ZHT16DBCSFIXED,
        KO16KSC5601,
        KO16KSCCS,
        KO16KSC5601FIXED,
        JA16VMS,
        ZHS16MACCGB231280,
        JA16MACSJIS,
        TH8MACTHAI,
        TH8MACTHAIS,
        TH8TISEBCDICS,
        ZHT16MSWIN950,
        KO16MSWIN949,
        VN8MSWIN1258,
        IN8ISCII,
        JA16SJIS,
        JA16SJISFIXED,
        JA16SJISYEN,
        ZHT32SOPS,
        ZHT16DBT,
        ZHT16BIG5FIXED,
        TH8TISASCII,
        TH8TISEBCDIC,
        ZHT32TRIS,
        ZHT32TRISFIXED,
        AL24UTFFSS,
        UTF8,
        UTFE,
        VN8VN3;

    }

    public static enum EURO_CHARSET {
        US7ASCII,
        SF7ASCII,
        YUG7ASCII,
        RU8BESTA,
        EL8GCOS7,
        WE8GCOS7,
        EL8DEC,
        TR7DEC,
        TR8DEC,
        TR8EBCDIC1026,
        TR8EBCDIC1026S,
        TR8PC857,
        TR8MACTURKISH,
        TR8MACTURKISHS,
        TR8MSWIN1254,
        WE8BS2000L5,
        WE8DEC,
        D7DEC,
        F7DEC,
        S7DEC,
        E7DEC,
        NDK7DEC,
        I7DEC,
        NL7DEC,
        CH7DEC,
        SF7DEC,
        WE8DG,
        WE8EBCDIC37C,
        WE8EBCDIC37,
        D8EBCDIC273,
        DK8EBCDIC277,
        S8EBCDIC278,
        I8EBCDIC280,
        WE8EBCDIC284,
        WE8EBCDIC285,
        WE8EBCDIC1047,
        WE8EBCDIC1140,
        WE8EBCDIC1140C,
        WE8EBCDIC1145,
        WE8EBCDIC1146,
        WE8EBCDIC1148,
        WE8EBCDIC1148C,
        F8EBCDIC297,
        WE8EBCDIC500C,
        WE8EBCDIC500,
        EE8EBCDIC870,
        EE8EBCDIC870C,
        EE8EBCDIC870S,
        WE8EBCDIC871,
        EL8EBCDIC875,
        EL8EBCDIC875S,
        CL8EBCDIC1025,
        CL8EBCDIC1025C,
        CL8EBCDIC1025S,
        CL8EBCDIC1025X,
        BLT8EBCDIC1112,
        BLT8EBCDIC1112S,
        D8EBCDIC1141,
        DK8EBCDIC1142,
        S8EBCDIC1143,
        I8EBCDIC1144,
        F8EBCDIC1147,
        EEC8EUROASCI,
        EEC8EUROPA3,
        LA8PASSPORT,
        WE8HP,
        WE8ROMAN8,
        HU8CWI2,
        HU8ABMOD,
        LV8RST104090,
        US8PC437,
        BG8PC437S,
        EL8PC437S,
        EL8PC737,
        LT8PC772,
        LT8PC774,
        BLT8PC775,
        WE8PC850,
        EL8PC851,
        EE8PC852,
        RU8PC855,
        WE8PC858,
        WE8PC860,
        IS8PC861,
        CDN8PC863,
        N8PC865,
        RU8PC866,
        EL8PC869,
        LV8PC1117,
        US8ICL,
        WE8ICL,
        WE8ISOICLUK,
        WE8ISO8859P1,
        EE8ISO8859P2,
        SE8ISO8859P3,
        NEE8ISO8859P4,
        CL8ISO8859P5,
        AR8ISO8859P6,
        EL8ISO8859P7,
        IW8ISO8859P8,
        NE8ISO8859P10,
        WE8ISO8859P15,
        LA8ISO6937,
        IW7IS960,
        AR8ARABICMAC,
        EE8MACCE,
        EE8MACCROATIAN,
        WE8MACROMAN8,
        EL8MACGREEK,
        IS8MACICELANDIC,
        CL8MACCYRILLIC,
        AR8ARABICMACS,
        EE8MACCES,
        EE8MACCROATIANS,
        WE8MACROMAN8S,
        CL8MACCYRILLICS,
        EL8MACGREEKS,
        IS8MACICELANDICS,
        BG8MSWIN,
        LT8MSWIN921,
        ET8MSWIN923,
        EE8MSWIN1250,
        CL8MSWIN1251,
        WE8MSWIN1252,
        EL8MSWIN1253,
        BLT8MSWIN1257,
        BLT8CP921,
        LV8PC8LR,
        WE8NCR4970,
        WE8NEXTSTEP,
        CL8KOI8R,
        US8BS2000,
        DK8BS2000,
        F8BS2000,
        D8BS2000,
        E8BS2000,
        S8BS2000,
        DK7SIEMENS9780X,
        F7SIEMENS9780X,
        D7SIEMENS9780X,
        I7SIEMENS9780X,
        N7SIEMENS9780X,
        E7SIEMENS9780X,
        S7SIEMENS9780X,
        WE8BS2000,
        CL8BS2000,
        AL24UTFFSS,
        UTF8,
        UTFE;

    }

    public static enum LangAbbreviation {
        AR,
        BG,
        BN,
        CA,
        CS,
        D,
        DIN,
        DK,
        E,
        EG,
        EL,
        ESA,
        ESM,
        ET,
        F,
        FRC,
        GB,
        HI,
        HR,
        HU,
        I,
        IN,
        IS,
        IW,
        JA,
        KO,
        LT,
        LV,
        MS,
        N,
        NL,
        PL,
        PT,
        PTB,
        RO,
        RU,
        S,
        SF,
        SK,
        SL,
        TA,
        TH,
        TR,
        uk,
        UK,
        us,
        US,
        vm,
        VN,
        ZHS,
        ZHT;

    }
}

