/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scheduler.reporting;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class ReportLine {
    private final String timestamp;
    private final Status status;
    private final List<Token> tokens;

    private ReportLine(String timestamp, Status status, Token ... tokens) {
        this.timestamp = timestamp;
        this.status = status;
        this.tokens = List.of(tokens);
    }

    public static ReportLine of(String timestamp, Status status, Token ... tokens) {
        return new ReportLine(timestamp, status, tokens);
    }

    public static ReportLine ofNow(Status status, Token ... tokens) {
        return new ReportLine(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), status, tokens);
    }

    public String format() {
        StringBuilder format = new StringBuilder();
        String firstSection = String.format("[%s] - [%s]", this.timestamp, this.status.getName());
        format.append(firstSection);
        for (Token token : this.tokens) {
            String tokenFormat = token.format();
            if (tokenFormat.contains("\\")) {
                tokenFormat = tokenFormat.replace("\\", "\\\\");
            }
            if (tokenFormat.contains("]")) {
                tokenFormat = tokenFormat.replace("]", "\\]");
            }
            format.append(String.format(" - [%s]", tokenFormat));
        }
        format.append('\n');
        return format.toString();
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public static interface Status {
        default public String getName() {
            return this.toString();
        }
    }

    public static class Token {
        private final String keyword;
        private final String parameter;

        private Token(String keyword, String parameter) {
            this.keyword = keyword;
            this.parameter = parameter;
        }

        public static Token of(String keyword, String data) {
            return new Token(keyword, data);
        }

        public static Token message(String data) {
            return new Token("MESSAGE", data);
        }

        public static Token error(String data) {
            return new Token("ERROR", data);
        }

        public String format() {
            return this.keyword.toUpperCase() + (String)(this.parameter != null ? ": " + this.parameter.trim() : "");
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String getParameter() {
            return this.parameter;
        }
    }

    public static class ResultToken
    extends Token {
        private ResultToken(String keyword, String parameter) {
            super(keyword, parameter);
        }

        public static ResultToken of(String parameter) {
            return new ResultToken("RESULT", parameter);
        }

        @Override
        public String format() {
            String lineSeparator;
            Object parameter = this.getParameter().trim();
            if (((String)parameter).contains(lineSeparator = System.lineSeparator())) {
                parameter = lineSeparator + (String)parameter + lineSeparator;
            }
            return this.getKeyword().toUpperCase() + ": " + (String)parameter;
        }
    }
}

