/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scheduler;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scheduler.SchedulerFile;
import oracle.dbtools.raptor.scheduler.SqlclScheduler;
import oracle.dbtools.raptor.scheduler.reporting.ReportLine;

public class SchedulerFileWatcher {
    private final SqlclScheduler scheduler;
    private final SchedulerFile schedulerFile;

    public SchedulerFileWatcher(SchedulerFile schedulerFile, SqlclScheduler scheduler) {
        this.scheduler = scheduler;
        this.schedulerFile = schedulerFile;
    }

    public void startWatching(ScriptRunnerContext context) {
        new Thread(() -> {
            try {
                WatchService watchService = FileSystems.getDefault().newWatchService();
                Path schedulerFilePath = this.schedulerFile.getFilePath();
                Path parentDir = schedulerFilePath.getParent();
                parentDir.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
                while (true) {
                    WatchKey key = watchService.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path changed = (Path)event.context();
                        if (!changed.equals(schedulerFilePath.getFileName())) continue;
                        context.runWithStoredContext(() -> this.scheduler.scheduleJobs(ScriptRunnerContext.getCurrentContext()));
                    }
                    key.reset();
                }
            }
            catch (IOException | InterruptedException e) {
                this.scheduler.getReporter().reportForAllJobs(ReportLine.ofNow(SchedulerFile.FileStatus.SCHEDULE_FILE_ERROR, ReportLine.Token.error(e.getMessage())));
                return;
            }
        }, "SchedulerFileWatcher").start();
    }
}

