/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.statusbar;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.console.StatusBarComponent;
import oracle.dbtools.raptor.console.statusbar.StatusBarHelp;
import org.jline.utils.AttributedString;

public class GitComponent
implements StatusBarComponent {
    @Override
    public String getName() {
        return "git";
    }

    @Override
    public String getDescription() {
        return StatusBarHelp.getString("git");
    }

    @Override
    public void update(StatusBarComponent.Context context) {
        String dir = FileUtils.getCWD(context.getScriptRunnerContext());
        String branch = this.getCurrentGitBranch(dir);
        context.append(new AttributedString((CharSequence)branch));
    }

    private String getCurrentGitBranch(String dir) {
        try {
            Process process = Runtime.getRuntime().exec("git rev-parse --abbrev-ref HEAD", null, new File(dir));
            process.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String branch = reader.readLine();
            if (branch != null) {
                return branch;
            }
            return "None";
        }
        catch (IOException | InterruptedException | NullPointerException e) {
            return "None";
        }
    }
}

