/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.secret;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.secret.SecretCache;
import oracle.dbtools.plusplus.secret.SecretCacheException;
import oracle.dbtools.plusplus.secret.SecretOptions;
import oracle.dbtools.plusplus.secret.SecretResources;
import oracle.dbtools.plusplus.util.DefaultLoggerWrapper;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

@Restricted(level=Restricted.Level.R4)
public class SecretCommand
extends CommandListener
implements IHelp {
    private final Map<Type, SubCommand> subcommands = new HashMap<Type, SubCommand>();

    public SecretCommand() {
        this.subcommands.put(SecretOptions.SET_COMMAND, SecretCommand::handleSet);
        this.subcommands.put(SecretOptions.LIST_COMMAND, SecretCommand::handleList);
        this.subcommands.put(SecretOptions.UNSET_COMMAND, SecretCommand::handleUnset);
        this.subcommands.put(SecretOptions.COMMAND, this::displayHelp);
    }

    private SubCommand lookupSubCommand(Type type) {
        return this.subcommands.get(type);
    }

    @Override
    public Type getParserType() {
        return SecretOptions.COMMAND;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!this.startsWithAlias(cmd.getSql(), new String[]{SecretOptions.Symbol.SECRET.name()})) {
            return false;
        }
        DefaultLoggerWrapper wrapper = DefaultLoggerWrapper.logger(SecretCommand.class);
        MessageLogger logger = MessageLogger.builder().interactiveLogger(ctx::writeln).errorLogger((MessageLogger.ErrorLogger)wrapper).traceLogger((MessageLogger.TraceLogger)wrapper).build();
        ArrayList errorMessages = new ArrayList();
        Parser parser = new Parser(SecretOptions.COMMAND, ctx.getEnvironment());
        Optional<ParsedCommand> parseResult = parser.parse(SQLPLUSUtil.cleanCommand(cmd).getSql(), errorMessages::add);
        if (parseResult.isPresent()) {
            ParsedCommand parsedCommand = parseResult.get();
            Type type = parsedCommand.getType();
            SubCommand subCommand = this.lookupSubCommand(type);
            subCommand.handleSubcommand(ctx, parsedCommand, logger);
        } else {
            this.displayHelp(ctx, logger, SecretOptions.COMMAND.getName());
            for (String errorMessage : errorMessages) {
                logger.logUserMessage(errorMessage + "\n");
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return SecretOptions.Symbol.SECRET.name();
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        HelpPagesBuilder builder = new HelpPagesBuilder(ctx.getEnvironment()).enableColorCode(ctx.isCommandLine()).addHelpContainerFor(this).addPages(new CommandPageAssemblers(SecretOptions.COMMAND, new Type[0]));
        return builder.build().get(pagePath);
    }

    private void displayHelp(ScriptRunnerContext ctx, MessageLogger logger, String pagePath) {
        Optional<String> optionalHelp = this.getHelp(ctx, pagePath);
        optionalHelp.ifPresent(arg_0 -> ((MessageLogger)logger).logUserMessage(arg_0));
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public String getDescription() {
        return "The Secret command is used to store secret values securely";
    }

    private static void handleSet(ScriptRunnerContext ctx, ParsedCommand parsedCommand, MessageLogger logger) {
        String name = (String)parsedCommand.getParameterValue(SecretOptions.Symbol.SECRET_NAME);
        String secret = (String)parsedCommand.getParameterValue(SecretOptions.Symbol.SECRET_VALUE);
        try {
            SecretCache.getInstance().addSecret(name, secret.toCharArray());
            logger.logUserMessage(SecretResources.format("MSG_SECRET_STORED", name));
        }
        catch (SecretCacheException e) {
            logger.logUserMessage(e.getLocalizedMessage());
        }
    }

    private static void handleList(ScriptRunnerContext ctx, ParsedCommand parsedCommand, MessageLogger logger) {
        SecretCache.getInstance().listSecrets().forEach(arg_0 -> ((MessageLogger)logger).logUserMessage(arg_0));
    }

    private static void handleUnset(ScriptRunnerContext ctx, ParsedCommand parsedCommand, MessageLogger logger) {
        String name = (String)parsedCommand.getParameterValue(SecretOptions.Symbol.SECRET_NAME);
        try {
            SecretCache.getInstance().removeSecret(name);
            logger.logUserMessage(SecretResources.format("MSG_SECRET_REMOVED", name));
        }
        catch (SecretCacheException e) {
            logger.logUserMessage(e.getLocalizedMessage());
        }
    }

    private void displayHelp(ScriptRunnerContext ctx, ParsedCommand parsedCommand, MessageLogger logger) {
        this.displayHelp(ctx, logger, SecretOptions.COMMAND.getName());
    }

    private static interface SubCommand {
        public void handleSubcommand(ScriptRunnerContext var1, ParsedCommand var2, MessageLogger var3);
    }
}

