/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.StorageManager;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DatabaseProviderStorageFactory;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreOptions;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.imp.DatabaseProviderImporter;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.connections.db.imp.PathImporter;
import oracle.dbtools.plusplus.connections.db.imp.PathImporterFactory;
import oracle.dbtools.plusplus.util.CommandContext;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class LegacyPathImporterFactory
implements PathImporterFactory {
    @Override
    public boolean canHandle(Path path) {
        Path file;
        String fileName;
        int dot;
        if (Files.isRegularFile(path, new LinkOption[0]) && (dot = (fileName = (file = path.getFileName()).toString()).lastIndexOf(46)) > 0) {
            String ext = fileName.substring(dot + 1);
            return "json".equalsIgnoreCase(ext);
        }
        return false;
    }

    @Override
    public PathImporter<DatabaseProvider> create(Path path, ConnectionStoreOptions.DuplicatesPolicy duplicatesPolicy, Collection<String> existingConnections, CommandContext ctx, TextSecret key) {
        return new LegacyImporter(path, duplicatesPolicy, existingConnections, ctx, key);
    }

    static final class LegacyImporter
    extends PathImporter<DatabaseProvider> {
        public static final String KEY = "Key";
        public static final String EXPORT_PASSWORD_MODE = "ExportPasswordMode";
        private static final String EXPORT_CHECKSUM = "ExportKeyChecksum";
        private final DatabaseProviderImporter importer;

        private LegacyImporter(Path path, ConnectionStoreOptions.DuplicatesPolicy duplicatesPolicy, Collection<String> existingConnections, CommandContext ctx, TextSecret key) {
            super(path, duplicatesPolicy, existingConnections, ctx, key);
            this.importer = DatabaseProviderImporter.createImporter(ctx);
        }

        @Override
        protected Map<String, DatabaseProvider> loadConnections() {
            HashMap<String, DatabaseProvider> namesAndConnections = new HashMap();
            try {
                Collection<DatabaseProvider> conns = this.loadDatabaseProviders();
                namesAndConnections = conns.stream().collect(HashMap::new, (m, p) -> m.put(this.getConnectionName((DatabaseProvider)p), p), HashMap::putAll);
            }
            catch (StorageException e) {
                this.cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("FAILURE_LOADING_FILE", this.importPath.toString(), e.getLocalizedMessage()));
                this.cmdCtx.getMessageLogger().logError("LegacyImporter.loadConnections", (Throwable)e);
            }
            return namesAndConnections;
        }

        private Collection<DatabaseProvider> loadDatabaseProviders() throws StorageException {
            Collection<DatabaseProvider> conns;
            if (this.key != null) {
                if (this.key.isPresent()) {
                    conns = this.connections(LegacyImporter.createDefaultWorker(this.key));
                    if (this.checksumFailedValidation(conns)) {
                        this.cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.get("FAILURE_INVALID_KEY"));
                        conns = this.connections(ReferenceWorker.createNullWorker());
                    }
                } else {
                    conns = this.connections(ReferenceWorker.createNullWorker());
                    this.cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.get("PASSWORDS_STRIPPED"));
                }
            } else {
                conns = this.connections(LegacyImporter.createDefaultWorker(TextSecret.none()));
                if (this.checkForPasswords(conns) && this.checksumFailedValidation(conns = this.connections(this.promptForKey()))) {
                    this.cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.get("FAILURE_INVALID_KEY"));
                    conns = this.connections(ReferenceWorker.createNullWorker());
                }
            }
            return conns;
        }

        @Override
        protected String getConnectionName(DatabaseProvider prov) {
            return DatabaseProviderImporter.getConnectionName(prov);
        }

        @Override
        protected ImportedConnectionResult importConnection(DatabaseProvider connectionDefinition, String name) {
            return this.importer.importConnection(connectionDefinition, name);
        }

        private boolean checkForPasswords(Collection<DatabaseProvider> conns) {
            return conns.stream().anyMatch(this::hasPassword);
        }

        private boolean checksumFailedValidation(Collection<DatabaseProvider> conns) {
            return conns.stream().anyMatch(this::invalidChecksum);
        }

        private boolean hasPassword(DatabaseProvider prov) {
            return KEY.equals(prov.getProperty(EXPORT_PASSWORD_MODE));
        }

        private boolean invalidChecksum(DatabaseProvider prov) {
            return this.hasPassword(prov) && !"ValidKey".equals(prov.getProperty(EXPORT_CHECKSUM));
        }

        private Collection<DatabaseProvider> connections(ReferenceWorker<char[]> refWorker) throws StorageException {
            Location jsonFile = Location.createFileLocation(this.importPath);
            StorageManager storageManager = StorageManager.builder().location(jsonFile).autosave(false).addEnvValue(ReferenceWorker.KEY, refWorker).build();
            Storage storage = storageManager.getStorage("jdbc");
            String[] connNames = storage.listConnections();
            DatabaseProviderStorageFactory factory = new DatabaseProviderStorageFactory();
            return Arrays.stream(connNames).collect(ArrayList::new, (l, s) -> {
                DatabaseProvider prov;
                try {
                    prov = (DatabaseProvider)storage.getConnection((String)s, factory);
                }
                catch (StorageException ex) {
                    prov = DatabaseProvider.builder("s").property("subtype", "Unknown").build();
                }
                l.add(prov);
            }, ArrayList::addAll);
        }

        private ReferenceWorker<char[]> promptForKey() {
            this.cmdCtx.getMessageLogger().traceMessage("prompting user for encryption key");
            String key = null;
            ScriptRunnerContext ctx = this.cmdCtx.getScriptRunnerContext();
            ConsoleService reader = (ConsoleService)ctx.getProperty("script.runner.jline");
            if (reader != null) {
                String haveASpace = ctx.getProperty("script.runner.sqlplus.silent") == null ? ConnectionStoreResources.getString("IMPORT_PROMPT_ENCRYPTION_KEY") + " " : "";
                try {
                    key = ctx.getProperty("script.runner.sqlplus.silent") == null ? (ctx.isSQLPlusClassic() ? reader.readInput(haveASpace, Character.valueOf(' ')) : reader.readInput(haveASpace, Character.valueOf('*'))) : reader.readInput(haveASpace, Character.valueOf(' '));
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
            }
            return LegacyImporter.createDefaultWorker(key != null ? Secrets.instance().of(key.toCharArray(), true) : TextSecret.none());
        }

        private static ReferenceWorker<char[]> createDefaultWorker(TextSecret key) {
            ReferenceWorker<char[]> retval = key != null && key.isPresent() ? ReferenceWorker.createDefaultWorker(key) : ReferenceWorker.createNullWorker();
            return retval;
        }
    }
}

