/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionResolverImplementation;
import oracle.dbtools.plusplus.connections.db.DatabaseConnection;
import oracle.dbtools.plusplus.connections.db.NamedConnections;

public final class NamedConnectionResolver
implements ConnectionResolverImplementation {
    private final NamedConnections conns;
    static final DatabaseConnection UNKNOWN_CONNECTION = new DatabaseConnection(){

        @Override
        public Connection getConnection(boolean force) {
            return null;
        }

        @Override
        public boolean matchConnection(Connection conn) {
            return false;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public boolean isOracle() {
            return false;
        }

        @Override
        public boolean isTimesTen() {
            return false;
        }

        @Override
        public Properties getConnectionInfo() {
            return new Properties();
        }

        @Override
        public Connection getUniqueConnection() throws SQLException {
            throw new SQLException("Unknown connection");
        }

        @Override
        public String getURL() throws SQLException {
            throw new SQLException("Unknown connection");
        }
    };

    NamedConnectionResolver(NamedConnections conns) {
        this.conns = conns;
    }

    @Override
    public Connection getConnectionImpl(String name, boolean force) throws Exception {
        DatabaseConnection db = this.lookupNamedConnection(name);
        return db.getConnection(force);
    }

    @Override
    public String getConnectionNameImpl(Connection conn) {
        DatabaseConnection db = this.lookupNamedConnection(conn);
        return db.getName();
    }

    @Override
    public String[] getConnNamesImpl() {
        return this.conns.listConnections().toArray(new String[0]);
    }

    @Override
    public Properties getConnectionInfoImpl(String name) {
        DatabaseConnection db = this.lookupNamedConnection(name);
        return db.getConnectionInfo();
    }

    @Override
    public boolean isOracleImpl(Connection conn) {
        DatabaseConnection db = this.lookupNamedConnection(conn);
        return db.isOracle();
    }

    @Override
    public boolean isTimesTenImpl(Connection conn) {
        DatabaseConnection db = this.lookupNamedConnection(conn);
        return db.isTimesTen();
    }

    @Override
    public String getConnectionTypeImpl(Connection conn) {
        DatabaseConnection db = this.lookupNamedConnection(conn);
        return db.getType();
    }

    @Override
    public String getQualifiedName(String name) {
        return name;
    }

    @Override
    public Connection getUniqueConnectionImpl(String name) throws Exception {
        DatabaseConnection db = this.lookupNamedConnection(name);
        return db.getUniqueConnection();
    }

    private DatabaseConnection lookupNamedConnection(String name) {
        DatabaseConnection result = NamedConnections.instance().findOpenConnection(name);
        if (result == null && name != null && name.startsWith("\"")) {
            String url = this.strip(name, '\"');
            ConnectionDetails cd = new ConnectionDetails(url);
            result = NamedConnections.instance().addImplicitConnection(cd);
        }
        return result != null ? result : UNKNOWN_CONNECTION;
    }

    private DatabaseConnection lookupNamedConnection(Connection conn) {
        DatabaseConnection result = NamedConnections.instance().findOpenConnection(conn);
        return result != null ? result : UNKNOWN_CONNECTION;
    }
}

