/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.util.Collection;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreCommand;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.util.CommandContext;

public class ConnectionDetailDisplay {
    public static ConnectionDetailDisplay instance() {
        return Holder.INSTANCE;
    }

    public void displayConnectionDetails(CommandContext cmdCtx, String cName) {
        ConnectionDefinition definition = ConnectionStoreCommand.getConnectionDefinition(cName, cmdCtx);
        if (definition != null) {
            ConnectionHelper helper = ConnectionHelperFactory.findHelper((ConnectionHelperContext)ConnectionHelperContext.of((ConnectionDefinition)definition, (MessageLogger)cmdCtx.getMessageLogger()));
            Collection props = helper.getDisplayProperties();
            if (props == null) {
                cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.getString("ERROR_PROCESSING_CONNECTION_SHOW"));
                return;
            }
            for (ConnectionHelper.DisplayEntry entry : props) {
                cmdCtx.getMessageLogger().logUserMessage(entry.getDisplayOutput());
            }
        }
    }

    private static class Holder {
        private static final ConnectionDetailDisplay INSTANCE = new ConnectionDetailDisplay();

        private Holder() {
        }
    }
}

