/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.script.Bindings;
import javax.script.ScriptException;
import oracle.arbori.scripting.GlobalMap;
import oracle.arbori.scripting.Scripting;
import oracle.arbori.util.CharOffsets;
import oracle.arbori.util.Service;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.js.Variables;
import oracle.dbtools.parser.plsql.SyntaxError;

public abstract class Base
extends Scripting {
    public Integer singleTest = null;
    private int maxTestNo = 0;
    public static Set<Integer> failedTests = new TreeSet<Integer>();
    public boolean printOKTests = false;
    public boolean setEquality = false;
    Set<RuleTuple> rules;
    Earley earley;
    protected int assertion;
    protected int comment;
    protected int code;
    protected int dotted_name;
    protected int digits;
    protected int element;
    protected int output;
    protected int inputSql;
    protected int result;
    protected int identifier;
    protected int parameters;
    protected int program;
    protected int quoted_string;
    protected int StringLiteral;
    private String input;

    public static String commonRoot() {
        String currentDir = System.getProperty("user.dir");
        currentDir = currentDir.replace("/dbtools-libraries/dbtools-common", "");
        currentDir = currentDir.replace("/dbtools-libraries/dbtools-arbori", "");
        return currentDir;
    }

    public Base(String testFile) throws FileNotFoundException, IOException {
        this(testFile, Base.commonRoot() + "/dbtools-libraries/dbtools-arbori/src/test/resources/oracle/dbtools/test/base.grammar", "js.grammar");
    }

    public Base(String testFile, String basePath, String jsPath) throws FileNotFoundException, IOException {
        this.input = Service.readFile(testFile);
        Object testGrammar = Service.readFile(basePath);
        testGrammar = (String)testGrammar + Service.readFile(Variables.class, jsPath);
        testGrammar = (String)testGrammar + Service.readFile(Program.class, "arbori.grammar");
        this.rules = Base.rules((String)testGrammar);
        this.earley = new Earley(this.rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == Base.this.code && token.type == Token.DQUOTED_STRING || symbol == Base.this.code && token.type == Token.BQUOTED_STRING || symbol == Base.this.StringLiteral && token.type == Token.DQUOTED_STRING || symbol == Base.this.quoted_string && token.type == Token.QUOTED_STRING;
            }
        };
        this.output = (Integer)this.earley.symbolIndexes.get("output");
        this.assertion = (Integer)this.earley.symbolIndexes.get("assertion");
        this.inputSql = (Integer)this.earley.symbolIndexes.get("inputSql");
        this.code = (Integer)this.earley.symbolIndexes.get("code");
        this.comment = (Integer)this.earley.symbolIndexes.get("comment");
        this.result = (Integer)this.earley.symbolIndexes.get("result");
        this.element = (Integer)this.earley.symbolIndexes.get("element");
        this.dotted_name = (Integer)this.earley.symbolIndexes.get("dotted_name");
        this.identifier = (Integer)this.earley.symbolIndexes.get("identifier");
        this.parameters = (Integer)this.earley.symbolIndexes.get("parameters");
        this.program = (Integer)this.earley.symbolIndexes.get("program");
        this.quoted_string = (Integer)this.earley.symbolIndexes.get("quoted_string");
        this.digits = (Integer)this.earley.symbolIndexes.get("digits");
        this.StringLiteral = (Integer)this.earley.symbolIndexes.get("StringLiteral");
    }

    public boolean test() throws Exception {
        this.maxTestNo = 0;
        List<LexerToken> src = LexerToken.parse(this.input, "`#", 57);
        Matrix matrix = new Matrix(this.earley);
        Visual visual = null;
        if (src.size() < 100) {
            visual = new Visual(src, this.earley);
        }
        this.earley.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(this.input, new String[]{"atest"}, src, this.earley, matrix);
        if (s != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.err.println("Syntax Error");
            System.err.println("at line#" + s.line);
            System.err.println(s.code);
            System.err.println(s.marker);
            System.err.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.err.print(tmp + ",");
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode root = this.earley.forest(src, matrix);
        long t1 = System.currentTimeMillis();
        this.atest(root, src, this.input);
        long t2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (t2 - t1));
        if (failedTests.size() != 0) {
            System.err.println("*** TEST FAILED! *** ---> " + failedTests.toString());
            return false;
        }
        System.out.println("*** ALL " + this.maxTestNo + " TESTS are OK *** ---> ");
        return true;
    }

    private static Set<RuleTuple> rules(String input) {
        try {
            List<LexerToken> src = Lexer.parse(input, false, 49);
            ParseNode root = Grammar.parseGrammarFile(src, input);
            TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
            Grammar.grammar(root, src, ret);
            RuleTransforms.eliminateEmptyProductions(ret);
            return ret;
        }
        catch (Exception e) {
            throw new AssertionError((Object)"VT: failed to init grammar for regression test");
        }
    }

    private void atest(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (root.contains("jsBlock")) {
            String code = input.substring(src.get((int)root.from).end, src.get((int)(root.to - 1)).begin);
            try {
                GlobalMap _globals = this.getGlobals();
                if (_globals == null) {
                    return;
                }
                _globals.put("testInstance", (Object)this);
                this.getEngine().eval(code, (Bindings)this.getGlobals());
            }
            catch (ScriptException e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        if (root.contains(this.assertion)) {
            if (this.singleTest != null && this.singleTest != this.maxTestNo) {
                return;
            }
            if (this.printOKTests) {
                System.out.print("TEST#" + this.maxTestNo + " -> ");
            }
            if (this.assertion(root, src, input, this.maxTestNo)) {
                if (this.printOKTests) {
                    System.out.println("OK \n");
                }
            } else if (this.printOKTests) {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (root.contains(this.output)) {
            if (this.singleTest != null && this.singleTest != this.maxTestNo) {
                return;
            }
            if (this.printOKTests) {
                System.out.print("TEST#" + this.maxTestNo + " -> ");
            }
            this.output(root, src, input, this.maxTestNo);
            return;
        }
        if (root.contains(this.comment)) {
            this.comment(root, src, input);
            return;
        }
        for (ParseNode child : root.children()) {
            this.atest(child, src, input);
        }
    }

    protected void output(ParseNode root, List<LexerToken> src, String input, int testNum) throws SQLException {
        for (ParseNode child : root.children()) {
            if (child.contains(this.parameters)) {
                this.parameters(child, src, input);
                continue;
            }
            if (!child.contains(this.inputSql)) continue;
            System.out.println("TEST#" + this.maxTestNo + " ->\n" + String.valueOf(this.query(child, src, input)));
        }
    }

    protected boolean cmp(String output, String cmp) {
        return cmp.equals(output);
    }

    private String showHiddenCharacters(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String output = input;
        Hashtable<String, String> hiddenCharacters = new Hashtable<String, String>(4);
        hiddenCharacters.put(" ", "\u00b7");
        hiddenCharacters.put("\t", "\u00af");
        hiddenCharacters.put("\r", "\u00b6");
        hiddenCharacters.put("\n", "\u21b5");
        for (Map.Entry entry : hiddenCharacters.entrySet()) {
            output = output.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean assertion(ParseNode root, List<LexerToken> src, String input, int testNum) throws Exception {
        String p;
        List<String> output = null;
        Map<Object, Object> cmp = new HashMap();
        int lineCounter = 0;
        boolean hasResult = false;
        for (ParseNode child : root.children()) {
            if (child.contains(this.parameters)) {
                this.parameters(child, src, input);
                continue;
            }
            if (child.contains(this.inputSql)) {
                output = this.query(child, src, input);
                continue;
            }
            if (child.contains(this.result)) {
                cmp = this.result(child, src, input);
                hasResult = true;
                continue;
            }
            if (!child.contains(this.program)) continue;
            this.program(child, src, input, output.get(0));
            hasResult = true;
        }
        if (!hasResult && !this.setEquality) {
            System.out.println("TEST#" + this.maxTestNo + " ->\n" + String.valueOf(output));
        }
        for (String c : cmp.keySet()) {
            void var16_23;
            boolean isPositive = (Boolean)cmp.get(c);
            String cC = c.replace("\r", "");
            boolean isCaseSensitive = false;
            if (cC.charAt(0) == '\"') {
                isCaseSensitive = true;
            }
            if (cC.charAt(0) == '`') {
                cC = cC.substring(1, cC.length() - 1);
            }
            if (!isCaseSensitive) {
                cC = cC.toLowerCase();
            }
            boolean matched = false;
            String prefix = this.longestCommonPrefix(cC, "");
            String string = "";
            String str2 = "";
            block2: for (String o : output) {
                String oO = o.replace("\r", "");
                if (isCaseSensitive && oO.charAt(0) != '\"') {
                    oO = this.quoteOutput(oO);
                }
                if (!isCaseSensitive) {
                    oO = oO.toLowerCase();
                }
                if (this.cmp(oO, cC)) {
                    matched = true;
                    break;
                }
                p = this.longestCommonPrefix(cC, oO);
                lineCounter = 1 + p.length() - p.replace("\n", "").length();
                if (prefix.length() >= p.length() || 1 >= lineCounter) continue;
                int[] mapCC = CharOffsets.lineMap(cC);
                int[] mapOO = CharOffsets.lineMap(oO);
                int lastPos = 0;
                for (int i = 0; i < mapCC.length && i < mapOO.length; ++i) {
                    int posCC = CharOffsets.lineNo2CharPos0(mapCC, i);
                    int posOO = CharOffsets.lineNo2CharPos0(mapOO, i);
                    String string2 = oO.substring(lastPos, posOO);
                    str2 = cC.substring(lastPos, posCC);
                    if (posCC != posOO || !string2.equals(str2)) continue block2;
                }
            }
            if ((matched || !isPositive) && (!matched || isPositive)) continue;
            System.out.println((isPositive ? "no" : "unexpected") + " match for " + c);
            failedTests.add(testNum);
            System.out.println(prefix);
            System.out.println("Failed test number " + testNum);
            if (0 < var16_23.length()) {
                System.out.println("Diff found in line " + lineCounter);
                System.out.println(">>>\n\"" + this.showHiddenCharacters((String)var16_23) + "\"!=\"" + this.showHiddenCharacters(str2) + "\"");
                System.out.println("Character key for normally hidden characters:");
                System.out.println("\" \" > \"\u00b7\"");
                System.out.println("\"\\t\" > \"\u00af\"");
                System.out.println("\"\\r\" > \"\u2014\"");
                System.out.println("\"\\n\" > \"\u21b5\"");
                System.out.println("Origin token length " + var16_23.length());
                System.out.println("Target token length " + str2.length());
            }
            return false;
        }
        if (this.setEquality) {
            for (String o : output) {
                String oO = o.replace("\r", "");
                boolean matched = false;
                String str1 = "";
                String str2 = "";
                for (String string : cmp.keySet()) {
                    boolean isPositive = (Boolean)cmp.get(string);
                    String cC = string.replace("\r", "");
                    boolean isCaseSensitive = false;
                    if (cC.charAt(0) == '\"') {
                        isCaseSensitive = true;
                    }
                    if (cC.charAt(0) == '`') {
                        cC = cC.substring(1, cC.length() - 1);
                    }
                    if (!isCaseSensitive) {
                        cC = cC.toLowerCase();
                    }
                    String prefix = this.longestCommonPrefix(cC, "");
                    if (isCaseSensitive && oO.charAt(0) != '\"') {
                        oO = this.quoteOutput(oO);
                    }
                    if (!isCaseSensitive) {
                        oO = oO.toLowerCase();
                    }
                    if (cC.equals(oO)) {
                        matched = true;
                        break;
                    }
                    p = this.longestCommonPrefix(cC, oO);
                    if (prefix.length() >= p.length()) continue;
                    prefix = p;
                    int index1 = prefix.length() + 3;
                    if (oO.length() < index1) {
                        index1 = oO.length();
                    }
                    str1 = oO.substring(prefix.length(), index1);
                    int index2 = prefix.length() + 3;
                    if (cC.length() < index2) {
                        index2 = cC.length();
                    }
                    str2 = cC.substring(prefix.length(), index2);
                }
                if (matched) continue;
                System.out.println("no match for " + oO);
                failedTests.add(testNum);
                return false;
            }
        }
        return true;
    }

    protected String quoteOutput(String output) {
        return "\"" + output + "\"";
    }

    protected void parameters(ParseNode node, List<LexerToken> src, String input) {
    }

    protected Map<String, Boolean> result(ParseNode node, List<LexerToken> src, String input) {
        if (node.contains(this.element)) {
            return this.element(node, src, input);
        }
        HashMap<String, Boolean> output = new HashMap<String, Boolean>();
        for (ParseNode child : node.children()) {
            output.putAll(this.result(child, src, input));
        }
        return output;
    }

    private Map<String, Boolean> element(ParseNode node, List<LexerToken> src, String input) {
        HashMap<String, Boolean> output = new HashMap<String, Boolean>();
        if (node.contains(this.dotted_name) || node.contains(this.code)) {
            String current = node.content(src);
            output.put(current, true);
            return output;
        }
        for (ParseNode child : node.children()) {
            if (!child.contains(this.dotted_name)) continue;
            String current = child.content(src);
            output.put(current, false);
            return output;
        }
        return output;
    }

    protected List<String> query(ParseNode root, List<LexerToken> src, String input) throws SQLException {
        if (root.contains(this.code)) {
            return this.output(Base.sql_fragment(root, src, input), -1);
        }
        String lhs = "";
        String rhs = "";
        for (ParseNode child : root.children()) {
            if (!child.contains(this.code)) continue;
            if (lhs == "") {
                lhs = Base.sql_fragment(child, src, input);
                continue;
            }
            rhs = Base.sql_fragment(child, src, input);
        }
        return this.output(lhs + rhs, lhs.length());
    }

    protected void program(ParseNode node, List<LexerToken> src, String input, String sql) throws Exception {
        String arbori = input.substring(src.get((int)node.from).begin, src.get((int)(node.to - 1)).end);
        SqlProgram r = new SqlProgram(arbori, "JS", this.getEngine(), this.getGlobals(), true){};
        Map<String, MaterializedPredicate> output = r.run(sql, null, "JS action");
        if (this.getGlobals().get("debug") != null) {
            for (String p : output.keySet()) {
                System.out.println(p + "=" + output.get(p).toString(p.length() + 1));
            }
        }
    }

    public abstract List<String> output(String var1, int var2);

    private static String sql_fragment(ParseNode root, List<LexerToken> src, String input) {
        return input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end).replace("`", "");
    }

    private ParseNode comment(ParseNode root, List<LexerToken> src, String input) throws Exception {
        int testNo;
        String txt = input.substring(src.get((int)(root.from + 1)).begin, src.get((int)(root.to - 1)).end - 1);
        if (txt.charAt(0) == '+') {
            txt = txt.substring(1);
        }
        if (this.maxTestNo < (testNo = Integer.parseInt(txt))) {
            this.maxTestNo = testNo;
        }
        if (this.singleTest != null && this.singleTest != testNo) {
            return null;
        }
        return null;
    }

    private String longestCommonPrefix(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.substring(0, minLength);
    }
}

