/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import oracle.arbori.scripting.GlobalMap;
import oracle.arbori.util.ParseInt;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.Position;
import oracle.dbtools.parser.ParseNode;

class BindVar
extends Position {
    BindVar(String name) {
        super(name);
    }

    @Override
    public int eval(Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) {
        GlobalMap globals = this.master.prog.getGlobals();
        if (globals != null) {
            String text2;
            Optional<Integer> value;
            Object object = globals.get(this.name);
            if (object instanceof String && (value = ParseInt.parseInt(text2 = (String)object)).isPresent()) {
                return value.get();
            }
            if (object instanceof Integer) {
                try {
                    return (Integer)object;
                }
                catch (NumberFormatException text2) {
                    // empty catch block
                }
            }
        }
        try {
            Field f = this.master.prog.getClass().getField(this.name);
            f.setAccessible(true);
            return f.getInt(this.master.prog);
        }
        catch (NoSuchFieldException e) {
            try {
                Field f = this.master.prog.struct.getClass().getField(this.name);
                f.setAccessible(true);
                return f.getInt(this.master.prog.struct);
            }
            catch (Exception e1) {
                throw new AssertionError((Object)("Bind var '" + this.name + "' not found: " + e1.getMessage()));
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Bind var '" + this.name + "' not found: " + e.getMessage()));
        }
    }

    public String toString() {
        return ":" + this.name;
    }
}

