/*
 * Decompiled with CFR 0.152.
 */
package oracle.arbori.util;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanServer;

public class Profile {
    static boolean isRunning = false;

    public static void dumpHeap(String filePath, boolean live) throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        mxBean.dumpHeap(filePath, live);
    }

    public static void profile(int duration, int granularity) {
        Profile.profile(duration, granularity, 5);
    }

    public static void profile(final int duration, final int granularity, final int stackDepth) {
        if (isRunning) {
            System.out.println("********fired more than once********");
            return;
        }
        isRunning = true;
        String threadName = Thread.currentThread().getName();
        System.out.println("threadName=" + threadName);
        new Thread(){

            @Override
            public void run() {
                String threadName1 = Thread.currentThread().getName();
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() < start + (long)duration) {
                    try {
                        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                        ThreadInfo[] infos = bean.dumpAllThreads(true, true);
                        boolean divide = false;
                        boolean divide2 = false;
                        for (ThreadInfo info : infos) {
                            StackTraceElement elem;
                            if (threadName1.equals(info.getThreadName())) continue;
                            if (divide) {
                                System.out.println("----------------");
                            }
                            divide = false;
                            StackTraceElement[] elems = info.getStackTrace();
                            int i = 0;
                            StackTraceElement[] stackTraceElementArray = elems;
                            int n = stackTraceElementArray.length;
                            for (int j = 0; !(j >= n || (elem = stackTraceElementArray[j]).toString().startsWith("org") || elem.toString().startsWith("oracle.dbtools.raptor.plsql.BackgroundParser") || elem.toString().startsWith("oracle.ide.model.FacadeBufferReference$PollingThread") || elem.toString().startsWith("oracle.ide.util.WeakDataReference$Cleaner") || elem.toString().startsWith("oracle.ide.status.StatusExecutor") || elem.toString().startsWith("oracle.ide.log.QueuedLoggingHandler")); ++j) {
                                if (elem.toString().startsWith("java") || elem.toString().startsWith("sun") || elem.toString().startsWith("oracle.net.ns") || elem.toString().startsWith("oracle.jdbc") || elem.toString().startsWith("oracle.dbtools.raptor.backgroundTask") || elem.toString().startsWith("oracle.javatools.db.execute.QueryWrapper") || elem.toString().startsWith("oracle.javatools.db.execute.ConnectionWrapper") || i >= stackDepth) continue;
                                System.out.println(elem.toString());
                                divide = true;
                                divide2 = true;
                                ++i;
                            }
                        }
                        if (divide2) {
                            System.out.println("=================" + (System.currentTimeMillis() - start));
                        }
                        Thread.sleep(granularity);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                isRunning = false;
            }
        }.start();
    }
}

