/*
 * Decompiled with CFR 0.152.
 */
package oracle.arbori.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.arbori.util.Array;

class IntegerMapImpl {
    private transient Entry root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private volatile transient Set entrySet = null;
    volatile transient Set keySet = null;
    volatile transient AbstractCollection values = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.root == null ? false : (value == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, value));
    }

    private boolean valueSearchNull(Entry n) {
        if (n.value == null) {
            return true;
        }
        return n.left != null && this.valueSearchNull(n.left) || n.right != null && this.valueSearchNull(n.right);
    }

    private boolean valueSearchNonNull(Entry n, Object value) {
        if (value.equals(n.value)) {
            return true;
        }
        return n.left != null && this.valueSearchNonNull(n.left, value) || n.right != null && this.valueSearchNonNull(n.right, value);
    }

    public Object get(int key) {
        Entry p = this.getEntry(key);
        return p == null ? null : p.value;
    }

    public Object firstKey() {
        return IntegerMapImpl.key(this.firstEntry());
    }

    public Object lastKey() {
        return IntegerMapImpl.key(this.lastEntry());
    }

    private Entry getEntry(int key) {
        Entry p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp == 0) {
                return p;
            }
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            p = p.right;
        }
        return null;
    }

    private Entry getCeilEntry(int key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) == 0) {
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right == null) break;
            p = p.right;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.right) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Entry getPrecedingEntry(int key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left == null) break;
            p = p.left;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.left) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static int key(Entry e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    public Object put(int key, Object value) {
        Entry t = this.root;
        if (t == null) {
            this.incrementSize();
            this.root = new Entry(key, value, null);
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, t.key)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                this.incrementSize();
                t.left = new Entry(key, value, t);
                this.fixAfterInsertion(t.left);
                return null;
            }
            if (t.right == null) break;
            t = t.right;
        }
        this.incrementSize();
        t.right = new Entry(key, value, t);
        this.fixAfterInsertion(t.right);
        return null;
    }

    public Object remove(int key) {
        Entry p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    public int[] keySet() {
        return this.keySet(this.root);
    }

    int[] keySet(Entry p) {
        int[] ret = new int[]{};
        Entry left = p.left;
        if (left != null) {
            ret = Array.merge(ret, this.keySet(left));
        }
        ret = Array.insert(ret, p.key);
        Entry right = p.right;
        if (right != null) {
            ret = Array.merge(ret, this.keySet(right));
        }
        return ret;
    }

    public int[] descendingKeySet() {
        int[] tmp = this.keySet();
        int[] ret = new int[tmp.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = tmp[tmp.length - i - 1];
        }
        return ret;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return IntegerMapImpl.this.size();
                }

                @Override
                public boolean contains(Object o) {
                    Entry e = IntegerMapImpl.this.firstEntry();
                    while (e != null) {
                        if (IntegerMapImpl.valEquals(e.getValue(), o)) {
                            return true;
                        }
                        e = IntegerMapImpl.this.successor(e);
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    Entry e = IntegerMapImpl.this.firstEntry();
                    while (e != null) {
                        if (IntegerMapImpl.valEquals(e.getValue(), o)) {
                            IntegerMapImpl.this.deleteEntry(e);
                            return true;
                        }
                        e = IntegerMapImpl.this.successor(e);
                    }
                    return false;
                }

                @Override
                public void clear() {
                    IntegerMapImpl.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new EntryIterator();
                }

                @Override
                public boolean contains(Object o) {
                    Entry entry = (Entry)o;
                    Object value = entry.getValue();
                    Entry p = IntegerMapImpl.this.getEntry(entry.getKey());
                    return p != null && IntegerMapImpl.valEquals(p.getValue(), value);
                }

                @Override
                public boolean remove(Object o) {
                    Entry entry = (Entry)o;
                    Object value = entry.getValue();
                    Entry p = IntegerMapImpl.this.getEntry(entry.getKey());
                    if (p != null && IntegerMapImpl.valEquals(p.getValue(), value)) {
                        IntegerMapImpl.this.deleteEntry(p);
                        return true;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return IntegerMapImpl.this.size();
                }

                @Override
                public void clear() {
                    IntegerMapImpl.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private int compare(int k, int k2) {
        return k < k2 ? -1 : (k == k2 ? 0 : 1);
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private Entry firstEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    private Entry lastEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    private Entry successor(Entry t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static boolean colorOf(Entry p) {
        return p == null ? true : p.color;
    }

    private static Entry parentOf(Entry p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(Entry p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static Entry leftOf(Entry p) {
        return p == null ? null : p.left;
    }

    private static Entry rightOf(Entry p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(Entry p) {
        Entry r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(Entry p) {
        Entry l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void fixAfterInsertion(Entry x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry y;
            if (IntegerMapImpl.parentOf(x) == IntegerMapImpl.leftOf(IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)))) {
                y = IntegerMapImpl.rightOf(IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)));
                if (!IntegerMapImpl.colorOf(y)) {
                    IntegerMapImpl.setColor(IntegerMapImpl.parentOf(x), true);
                    IntegerMapImpl.setColor(y, true);
                    IntegerMapImpl.setColor(IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)), false);
                    x = IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x));
                    continue;
                }
                if (x == IntegerMapImpl.rightOf(IntegerMapImpl.parentOf(x))) {
                    x = IntegerMapImpl.parentOf(x);
                    this.rotateLeft(x);
                }
                IntegerMapImpl.setColor(IntegerMapImpl.parentOf(x), true);
                IntegerMapImpl.setColor(IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)), false);
                if (IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)) == null) continue;
                this.rotateRight(IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)));
                continue;
            }
            y = IntegerMapImpl.leftOf(IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)));
            if (!IntegerMapImpl.colorOf(y)) {
                IntegerMapImpl.setColor(IntegerMapImpl.parentOf(x), true);
                IntegerMapImpl.setColor(y, true);
                IntegerMapImpl.setColor(IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)), false);
                x = IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x));
                continue;
            }
            if (x == IntegerMapImpl.leftOf(IntegerMapImpl.parentOf(x))) {
                x = IntegerMapImpl.parentOf(x);
                this.rotateRight(x);
            }
            IntegerMapImpl.setColor(IntegerMapImpl.parentOf(x), true);
            IntegerMapImpl.setColor(IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)), false);
            if (IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)) == null) continue;
            this.rotateLeft(IntegerMapImpl.parentOf(IntegerMapImpl.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry p) {
        Entry replacement;
        this.decrementSize();
        if (p.left != null && p.right != null) {
            Entry s = this.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry x) {
        while (x != this.root && IntegerMapImpl.colorOf(x)) {
            Entry sib;
            if (x == IntegerMapImpl.leftOf(IntegerMapImpl.parentOf(x))) {
                sib = IntegerMapImpl.rightOf(IntegerMapImpl.parentOf(x));
                if (!IntegerMapImpl.colorOf(sib)) {
                    IntegerMapImpl.setColor(sib, true);
                    IntegerMapImpl.setColor(IntegerMapImpl.parentOf(x), false);
                    this.rotateLeft(IntegerMapImpl.parentOf(x));
                    sib = IntegerMapImpl.rightOf(IntegerMapImpl.parentOf(x));
                }
                if (IntegerMapImpl.colorOf(IntegerMapImpl.leftOf(sib)) && IntegerMapImpl.colorOf(IntegerMapImpl.rightOf(sib))) {
                    IntegerMapImpl.setColor(sib, false);
                    x = IntegerMapImpl.parentOf(x);
                    continue;
                }
                if (IntegerMapImpl.colorOf(IntegerMapImpl.rightOf(sib))) {
                    IntegerMapImpl.setColor(IntegerMapImpl.leftOf(sib), true);
                    IntegerMapImpl.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = IntegerMapImpl.rightOf(IntegerMapImpl.parentOf(x));
                }
                IntegerMapImpl.setColor(sib, IntegerMapImpl.colorOf(IntegerMapImpl.parentOf(x)));
                IntegerMapImpl.setColor(IntegerMapImpl.parentOf(x), true);
                IntegerMapImpl.setColor(IntegerMapImpl.rightOf(sib), true);
                this.rotateLeft(IntegerMapImpl.parentOf(x));
                x = this.root;
                continue;
            }
            sib = IntegerMapImpl.leftOf(IntegerMapImpl.parentOf(x));
            if (!IntegerMapImpl.colorOf(sib)) {
                IntegerMapImpl.setColor(sib, true);
                IntegerMapImpl.setColor(IntegerMapImpl.parentOf(x), false);
                this.rotateRight(IntegerMapImpl.parentOf(x));
                sib = IntegerMapImpl.leftOf(IntegerMapImpl.parentOf(x));
            }
            if (IntegerMapImpl.colorOf(IntegerMapImpl.rightOf(sib)) && IntegerMapImpl.colorOf(IntegerMapImpl.leftOf(sib))) {
                IntegerMapImpl.setColor(sib, false);
                x = IntegerMapImpl.parentOf(x);
                continue;
            }
            if (IntegerMapImpl.colorOf(IntegerMapImpl.leftOf(sib))) {
                IntegerMapImpl.setColor(IntegerMapImpl.rightOf(sib), true);
                IntegerMapImpl.setColor(sib, false);
                this.rotateLeft(sib);
                sib = IntegerMapImpl.leftOf(IntegerMapImpl.parentOf(x));
            }
            IntegerMapImpl.setColor(sib, IntegerMapImpl.colorOf(IntegerMapImpl.parentOf(x)));
            IntegerMapImpl.setColor(IntegerMapImpl.parentOf(x), true);
            IntegerMapImpl.setColor(IntegerMapImpl.leftOf(sib), true);
            this.rotateRight(IntegerMapImpl.parentOf(x));
            x = this.root;
        }
        IntegerMapImpl.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Entry e : this.entrySet()) {
            s.writeObject(e.key);
            s.writeObject(e.value);
        }
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    static class Entry {
        int key;
        Object value;
        Entry left = null;
        Entry right = null;
        Entry parent;
        boolean color = true;

        Entry(int key, Object value, Entry parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            Entry e = (Entry)o;
            return IntegerMapImpl.valEquals(this.key, e.getKey()) && IntegerMapImpl.valEquals(this.value, e.getValue());
        }

        public int hashCode() {
            int keyHash = this.key;
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + String.valueOf(this.value);
        }
    }

    private class SubMapEntryIterator
    extends EntryIterator {
        private final int firstExcludedKey;

        SubMapEntryIterator(Entry first, Entry firstExcluded) {
            super(first);
            this.firstExcludedKey = firstExcluded == null ? -1 : firstExcluded.key;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.key != this.firstExcludedKey;
        }

        @Override
        public Object next() {
            if (this.next == null || this.next.key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private ValueIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private KeyIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry().key;
        }
    }

    private class EntryIterator
    implements Iterator {
        private int expectedModCount;
        private Entry lastReturned;
        Entry next;

        EntryIterator() {
            this.expectedModCount = IntegerMapImpl.this.modCount;
            this.lastReturned = null;
            this.next = IntegerMapImpl.this.firstEntry();
        }

        EntryIterator(Entry first) {
            this.expectedModCount = IntegerMapImpl.this.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        final Entry nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (IntegerMapImpl.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = IntegerMapImpl.this.successor(this.next);
            return this.lastReturned;
        }

        public Object next() {
            return this.nextEntry();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IntegerMapImpl.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            IntegerMapImpl.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    private class SubMap
    extends AbstractMap {
        private boolean fromStart = false;
        private boolean toEnd = false;
        private int fromKey;
        private int toKey;
        private transient Set entrySet = new EntrySetView();

        SubMap(int fromKey, int toKey) {
            if (IntegerMapImpl.this.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        SubMap(int key, boolean headMap) {
            IntegerMapImpl.this.compare(key, key);
            if (headMap) {
                this.fromStart = true;
                this.toKey = key;
            } else {
                this.toEnd = true;
                this.fromKey = key;
            }
        }

        SubMap(boolean fromStart, int fromKey, boolean toEnd, int toKey) {
            this.fromStart = fromStart;
            this.fromKey = fromKey;
            this.toEnd = toEnd;
            this.toKey = toKey;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        public boolean containsKey(int key) {
            return this.inRange(key) && IntegerMapImpl.this.containsKey(key);
        }

        public Object get(int key) {
            if (!this.inRange(key)) {
                return null;
            }
            return IntegerMapImpl.this.get(key);
        }

        @Override
        public Object put(int key, Object value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return IntegerMapImpl.this.put(key, value);
        }

        public Object firstKey() {
            int first = IntegerMapImpl.key(this.fromStart ? IntegerMapImpl.this.firstEntry() : IntegerMapImpl.this.getCeilEntry(this.fromKey));
            if (!this.toEnd && IntegerMapImpl.this.compare(first, this.toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return first;
        }

        public Object lastKey() {
            int last = IntegerMapImpl.key(this.toEnd ? IntegerMapImpl.this.lastEntry() : IntegerMapImpl.this.getPrecedingEntry(this.toKey));
            if (!this.fromStart && IntegerMapImpl.this.compare(last, this.fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return last;
        }

        @Override
        public Set entrySet() {
            return this.entrySet;
        }

        private boolean inRange(int key) {
            return !(!this.fromStart && IntegerMapImpl.this.compare(key, this.fromKey) < 0 || !this.toEnd && IntegerMapImpl.this.compare(key, this.toKey) >= 0);
        }

        private boolean inRange2(int key) {
            return !(!this.fromStart && IntegerMapImpl.this.compare(key, this.fromKey) < 0 || !this.toEnd && IntegerMapImpl.this.compare(key, this.toKey) > 0);
        }

        private class EntrySetView
        extends AbstractSet {
            private transient int size = -1;
            private transient int sizeModCount;

            private EntrySetView() {
            }

            @Override
            public int size() {
                if (this.size == -1 || this.sizeModCount != IntegerMapImpl.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = IntegerMapImpl.this.modCount;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object o) {
                Entry entry = (Entry)o;
                int key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = IntegerMapImpl.this.getEntry(key);
                return node != null && IntegerMapImpl.valEquals(node.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                Entry entry = (Entry)o;
                int key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = IntegerMapImpl.this.getEntry(key);
                if (node != null && IntegerMapImpl.valEquals(node.getValue(), entry.getValue())) {
                    IntegerMapImpl.this.deleteEntry(node);
                    return true;
                }
                return false;
            }

            @Override
            public Iterator iterator() {
                return new SubMapEntryIterator(SubMap.this.fromStart ? IntegerMapImpl.this.firstEntry() : IntegerMapImpl.this.getCeilEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : IntegerMapImpl.this.getCeilEntry(SubMap.this.toKey));
            }
        }
    }
}

