/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.util.logging.Logger;

public class DgUtils {
    protected static final Logger LOGGER = Logger.getLogger(DgUtils.class.getName());

    public static String indent(int level) {
        return String.format("%" + 2 * level + "s", "");
    }

    public static String trimQuotes(String str) {
        if (str != null) {
            return str.replaceAll("^\"|\"$", "").replaceAll("^'|'$", "");
        }
        return null;
    }

    public static int extractMemberId(int objid) {
        return objid >> 24 & 0xFF;
    }

    public static int extractInstanceId(int objid) {
        return objid & 0xFFF;
    }

    public static int toSiteObjid(int dbObjid) {
        int bitmask = -16777216;
        return dbObjid & bitmask;
    }

    public static boolean parseYes(String str) {
        return "YES".equalsIgnoreCase(str);
    }

    public static String nvl(String val, String alt) {
        return val != null ? val : alt;
    }

    public static String nvl(String val) {
        return DgUtils.nvl(val, "");
    }

    public static String toGapString(String str) {
        int gap = -1;
        StringBuffer sb = new StringBuffer();
        try {
            gap = Integer.valueOf(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gap >= 0) {
            int val = gap / 85400;
            if (val > 0) {
                sb.append(String.format("%d %s ", val, val == 1 ? "day" : "days"));
                gap %= 85400;
            }
            if ((val = gap / 3600) > 0) {
                sb.append(String.format("%d %s ", val, val == 1 ? "hour" : "hours"));
                gap %= 3600;
            }
            if ((val = gap / 60) > 0) {
                sb.append(String.format("%d %s ", val, val == 1 ? "minute" : "minutes"));
                gap %= 60;
            }
            sb.append(String.format("%d %s", gap, gap == 1 ? "second" : "seconds"));
            return sb.toString();
        }
        return null;
    }

    public static String toRate(String str) {
        long rate = -1L;
        float k = 1024.0f;
        float m = k * 1024.0f;
        float g = m * 1024.0f;
        try {
            rate = Long.valueOf(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rate >= 0L) {
            if ((float)rate >= g) {
                return String.format("%.2f GByte/s", Float.valueOf((float)rate / g));
            }
            if ((float)rate >= m) {
                return String.format("%.2f MByte/s", Float.valueOf((float)rate / m));
            }
            if ((float)rate >= k) {
                return String.format("%.2f KByte/s", Float.valueOf((float)rate / k));
            }
            return String.format("%lld Byte/s", rate);
        }
        return null;
    }
}

