/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.nativeimage;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

final class NativeImageFeature
implements Feature {
    NativeImageFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        try {
            for (String className : this.findGeneratedProxies()) {
                this.registerClass(a, className);
                this.registerAllConstructor(a, className);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Class pooledConnectionHelper = a.findClassByName("oracle.ucp.jdbc.oracle.FailoverablePooledConnectionHelper");
        if (pooledConnectionHelper != null) {
            this.registerClass(a, "oracle.jdbc.internal.OracleConnection");
            this.registerAllMethods(a, "oracle.jdbc.internal.OracleConnection");
        }
    }

    private void registerClass(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
        }
    }

    private void registerAllConstructor(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            for (Constructor<?> c : clazz.getConstructors()) {
                RuntimeReflection.register((Executable[])new Executable[]{c});
            }
        }
    }

    private void registerAllMethods(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            for (Method m : clazz.getMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{m});
            }
        }
    }

    private List<String> findGeneratedProxies() throws IOException, URISyntaxException {
        Path root;
        String packageName = "oracle.ucp.jdbc.proxy";
        String packagePath = packageName.replaceAll("\\.", "/");
        ArrayList<String> proxies = new ArrayList<String>();
        URI packageUri = Objects.requireNonNull(ClassLoader.getSystemClassLoader().getResource(packagePath)).toURI();
        if (packageUri.toString().startsWith("jar:")) {
            try {
                root = FileSystems.getFileSystem(packageUri).getPath(packagePath, new String[0]);
            }
            catch (FileSystemNotFoundException e) {
                root = FileSystems.newFileSystem(packageUri, Collections.emptyMap()).getPath(packagePath, new String[0]);
            }
        } else {
            root = Paths.get(packageUri);
        }
        String extension = ".class";
        try (Stream<Path> allPaths = Files.walk(root, new FileVisitOption[0]);){
            allPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String path = file.toString().replace('/', '.');
                String name = path.substring(path.indexOf(packageName), path.length() - ".class".length());
                if (name.endsWith("$$$Proxy")) {
                    proxies.add(name);
                }
            });
        }
        return proxies;
    }
}

