/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.async;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;

public class AsyncBorrowRequest {
    private final CompletableFuture<Void> cf;
    private final Queue<AsyncBorrowRequest> asyncBorrowRequestQueue;

    public AsyncBorrowRequest(CompletableFuture<Void> cf, long timeToWait, Queue<AsyncBorrowRequest> asyncBorrowRequestQueue) {
        this.cf = cf;
        this.asyncBorrowRequestQueue = asyncBorrowRequestQueue;
        UniversalConnectionPoolManagerBase.getTimerManager().schedule(() -> this.processTimedOutRequest(), timeToWait, 0L);
    }

    public final void processTimedOutRequest() {
        this.asyncBorrowRequestQueue.remove(this);
        this.cf.complete(null);
    }

    public final void trigger() {
        this.cf.complete(null);
    }
}

