/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mcp.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class StreamClientTransport
implements McpClientTransport {
    private static final Logger logger = LoggerFactory.getLogger(StreamClientTransport.class);
    private final Sinks.Many<McpSchema.JSONRPCMessage> inboundSink;
    private final Sinks.Many<McpSchema.JSONRPCMessage> outboundSink;
    private ObjectMapper objectMapper;
    private Scheduler inboundScheduler;
    private Scheduler outboundScheduler;
    private final Sinks.Many<String> errorSink;
    private volatile boolean isClosing = false;
    private Consumer<String> stdErrorHandler = error -> logger.info("STDERR Message received: {}", error);
    private final InputStream input;
    private final OutputStream output;

    public StreamClientTransport(ObjectMapper objectMapper, InputStream input, OutputStream output) {
        Assert.notNull((Object)objectMapper, (String)"The ObjectMapper can not be null");
        this.inboundSink = Sinks.many().unicast().onBackpressureBuffer();
        this.outboundSink = Sinks.many().unicast().onBackpressureBuffer();
        this.objectMapper = objectMapper;
        this.input = input;
        this.output = output;
        this.errorSink = Sinks.many().unicast().onBackpressureBuffer();
        this.inboundScheduler = Schedulers.fromExecutorService((ExecutorService)Executors.newSingleThreadExecutor(), (String)"inbound");
        this.outboundScheduler = Schedulers.fromExecutorService((ExecutorService)Executors.newSingleThreadExecutor(), (String)"outbound");
    }

    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        return Mono.fromRunnable(() -> {
            this.handleIncomingMessages(handler);
            this.handleIncomingErrors();
            this.startInboundProcessing();
            this.startOutboundProcessing();
        }).subscribeOn(Schedulers.boundedElastic());
    }

    protected ProcessBuilder getProcessBuilder() {
        return new ProcessBuilder(new String[0]);
    }

    public void setStdErrorHandler(Consumer<String> errorHandler) {
        this.stdErrorHandler = errorHandler;
    }

    private void startErrorProcessing() {
    }

    private void handleIncomingMessages(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> inboundMessageHandler) {
        this.inboundSink.asFlux().flatMap(message -> Mono.just((Object)message).transform(inboundMessageHandler).contextWrite(ctx -> ctx.put((Object)"observation", (Object)"myObservation"))).subscribe();
    }

    private void handleIncomingErrors() {
        this.errorSink.asFlux().subscribe(e -> this.stdErrorHandler.accept((String)e));
    }

    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        if (this.outboundSink.tryEmitNext((Object)message).isSuccess()) {
            return Mono.empty();
        }
        return Mono.error((Throwable)new RuntimeException("Failed to enqueue message"));
    }

    private void startInboundProcessing() {
        this.inboundScheduler.schedule(() -> {
            try (BufferedReader processReader = new BufferedReader(new InputStreamReader(this.input));){
                String line;
                while (!this.isClosing && (line = processReader.readLine()) != null) {
                    try {
                        McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)line);
                        if (this.inboundSink.tryEmitNext((Object)message).isSuccess()) continue;
                        if (!this.isClosing) {
                            logger.error("Failed to enqueue inbound message: {}", (Object)message);
                        }
                        break;
                    }
                    catch (Exception e) {
                        if (!this.isClosing) {
                            logger.error("Error processing inbound message for line: " + line, (Throwable)e);
                        }
                        break;
                    }
                }
            }
            catch (IOException e) {
                if (!this.isClosing) {
                    logger.error("Error reading from input stream", (Throwable)e);
                }
            }
            finally {
                this.isClosing = true;
                this.inboundSink.tryEmitComplete();
            }
        });
    }

    private void startOutboundProcessing() {
        this.handleOutbound(messages -> messages.publishOn(this.outboundScheduler).handle((message, s) -> {
            if (message != null && !this.isClosing) {
                try {
                    OutputStream os;
                    String jsonMessage = this.objectMapper.writeValueAsString(message);
                    jsonMessage = jsonMessage.replace("\r\n", "\\n").replace("\n", "\\n").replace("\r", "\\n");
                    OutputStream outputStream = os = this.output;
                    synchronized (outputStream) {
                        os.write(jsonMessage.getBytes(StandardCharsets.UTF_8));
                        os.write("\n".getBytes(StandardCharsets.UTF_8));
                        os.flush();
                    }
                    s.next(message);
                }
                catch (IOException e) {
                    s.error((Throwable)new RuntimeException(e));
                }
            }
        }));
    }

    protected void handleOutbound(Function<Flux<McpSchema.JSONRPCMessage>, Flux<McpSchema.JSONRPCMessage>> outboundConsumer) {
        outboundConsumer.apply((Flux<McpSchema.JSONRPCMessage>)this.outboundSink.asFlux()).doOnComplete(() -> {
            this.isClosing = true;
            this.outboundSink.tryEmitComplete();
        }).doOnError(e -> {
            if (!this.isClosing) {
                logger.error("Error in outbound processing", e);
                this.isClosing = true;
                this.outboundSink.tryEmitComplete();
            }
        }).subscribe();
    }

    public Mono<Void> closeGracefully() {
        return Mono.fromRunnable(() -> {
            this.isClosing = true;
            logger.debug("Initiating graceful shutdown");
        }).then(Mono.defer(() -> {
            this.inboundSink.tryEmitComplete();
            this.outboundSink.tryEmitComplete();
            this.errorSink.tryEmitComplete();
            return Mono.delay((Duration)Duration.ofMillis(100L));
        })).then(Mono.defer(() -> {
            logger.debug("Sending TERM to process");
            return Mono.just((Object)0);
        })).doOnNext(exitCode -> {
            if (exitCode != 0) {
                logger.warn("Process terminated with code " + exitCode);
            }
        }).then(Mono.fromRunnable(() -> {
            try {
                this.inboundScheduler.dispose();
                this.outboundScheduler.dispose();
                logger.debug("Graceful shutdown completed");
            }
            catch (Exception e) {
                logger.error("Error during graceful shutdown", (Throwable)e);
            }
        })).then().subscribeOn(Schedulers.boundedElastic());
    }

    public Sinks.Many<String> getErrorSink() {
        return this.errorSink;
    }

    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.objectMapper.convertValue(data, typeRef);
    }
}

