/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.utils;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.runner.SqlClCommandsRunner;
import oracle.jdbc.OracleCallableStatement;

public class QueryUtils {
    static QueryXMLSupport s_xml = null;

    public static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(QueryUtils.class.getClassLoader(), "oracle/dbtools/extension/mcp/command/xml/McpToolsQueries.xml"));
        }
        return s_xml;
    }

    public static String getOpenMode(Connection conn) {
        return DBUtil.getInstance((Connection)conn).executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("mcp.open.mode", conn).getSql());
    }

    public static String getCharacterSet(Connection conn) {
        SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().context(ScriptRunnerContext.getCurrentContext()).connection(conn).build();
        return sqlcl.run("set sqlformat json\n" + QueryUtils.getXMLQueries().getQuery("mcp.character.set", conn).getSql() + "\n");
    }

    public static String getNlsParams(Connection conn) {
        SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().context(ScriptRunnerContext.getCurrentContext()).connection(conn).build();
        return sqlcl.run("set sqlformat json\n" + QueryUtils.getXMLQueries().getQuery("mcp.nls.params", conn).getSql() + "\n");
    }

    public static void createDbtoolsMcpLogTable(Connection conn) throws SQLException, AuditTableException {
        try {
            String p_stmt = QueryUtils.getXMLQueries().getQuery("dbtools.mcp.log.table", conn).getSql();
            OracleCallableStatement l_stmt = (OracleCallableStatement)conn.prepareCall(p_stmt);
            l_stmt.execute();
            l_stmt.close();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1031) {
                throw new AuditTableException("Warning: Failed to create the auditing table DBTOOLS$MCP_LOG");
            }
            throw new SQLException(e);
        }
    }

    public static void insertIntoDbtoolsMcpLog(Connection conn, String mcp_client, String model, McpUtils.McpCapabilities end_point_type, String end_point_name, String log_message) throws SQLException {
        String p_stmt = QueryUtils.getXMLQueries().getQuery("insert.dbtools.mcp.log", conn).getSql();
        try (OracleCallableStatement l_stmt = (OracleCallableStatement)conn.prepareCall(p_stmt);){
            l_stmt.setString("mcp_client", mcp_client);
            l_stmt.setString("model", model);
            l_stmt.setString("end_point_type", end_point_type.displayName());
            l_stmt.setString("end_point_name", end_point_name);
            l_stmt.setString("log_message", log_message);
            l_stmt.execute();
        }
    }

    public static void insertSessionInfo(Connection conn, String action_name, String model) throws SQLException {
        String p_stmt = QueryUtils.getXMLQueries().getQuery("session.info.track", conn).getSql();
        try (OracleCallableStatement l_stmt = (OracleCallableStatement)conn.prepareCall(p_stmt);){
            l_stmt.setString("module_name", model);
            l_stmt.setString("action_name", action_name);
            l_stmt.execute();
        }
    }

    public static void insertClientInfo(Connection conn, String client_infor) throws SQLException {
        String p_stmt = QueryUtils.getXMLQueries().getQuery("session.client.info", conn).getSql();
        try (OracleCallableStatement l_stmt = (OracleCallableStatement)conn.prepareCall(p_stmt);){
            l_stmt.setString("client_info", client_infor);
            l_stmt.execute();
        }
    }

    public static String getSchemaObjectsFull(ScriptRunnerContext ctx) {
        SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().context(ctx).connection(ctx.getCurrentConnection()).build();
        Query query = QueryUtils.getXMLQueries().getQuery("mcp.schema.objects.full2", ctx.getCurrentConnection());
        if (null == query) {
            return null;
        }
        ctx.putProperty("sql.format", (Object)"csv");
        return sqlcl.run(query.getSql() + "\n");
    }

    public static String getOptimizedDdl(ScriptRunnerContext ctx) {
        SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().context(ctx).connection(ctx.getCurrentConnection()).build();
        Query query = QueryUtils.getXMLQueries().getQuery("mcp.optimized.ddl.format", ctx.getCurrentConnection());
        if (null == query) {
            return null;
        }
        ctx.putProperty("sql.format", (Object)"csv");
        return sqlcl.run(query.getSql() + "\n");
    }
}

